from sessions import get_channels
import argparse
import nile
from nile.api.v1 import (
    clusters,
    filters as nf,
    extractors as ne,
    aggregators as na,
    statface as ns,
    Record
)
import json
import codecs
import sys

class filter_by_content_id(object):
    def __init__(self, channel_video_content_ids):
        self.channel_video_content_ids = channel_video_content_ids
    def __call__(self, recs):
        for rec in recs:
            if rec["UUID"] in self.channel_video_content_ids:
                yield rec

code_template = (
    u'<iframe src="{}?from=yavideo&autoplay=0"'
    ' frameborder="0" scrolling="no" '
    'allowfullscreen="1" aria-label="Video"></iframe>'
)


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--output', type=str, required=True)
    parser.add_argument('--channels_table', type=str, required=True)
    args = parser.parse_args()
    print sys.argv
    channels_info = get_channels()
    channel_video_content_ids = []
    for channel in channels_info:
        status = channel.get('status', [])
        if 'published' in status:
            channel_video_content_ids.append(channel['content_id'])

    cluster = clusters.yt.Hahn()
    job = cluster.job()
    job.table("//home/video-hosting/base/ContentGroup").map(filter_by_content_id(channel_video_content_ids)).put("//tmp/grep_active_channels")
    job.run()

    basket = []
    rows = []
    for rec in cluster.job().table("//tmp/grep_active_channels").read():
        rows.append(Record(url="https://frontend.vh.yandex.ru/player/" + str(rec["ContentGroupID"]),
                           name=rec["Name"], uuid=rec["UUID"], content_group_id=rec["ContentGroupID"]))
        basket.append({"text" : "https://frontend.vh.yandex.ru/player/" + str(rec["ContentGroupID"]),
                       "regionId" : 213, "device" : "DESKTOP",
                       "params" : [ {
                                     "name" : "channel_name",
                                     "value" : rec["Name"].decode('utf8')
                                    }, {
                                     "name" : "channel_uuid",
                                     "value" : rec["UUID"]
                                    }, {
                                     "name" : "channel_content_group_id",
                                     "value" : rec["ContentGroupID"]
                                    },{
                                     "name" : "query_code",
                                     "value" : code_template.format(rec['ContentGroupID']).decode('utf8')
                                    }
                                  ]
                       })
    cluster.job().table(args.channels_table).write(rows)

    json.dump(
        basket, codecs.open(
            args.output, 'w', 'utf8'
        ),
        indent=2, ensure_ascii=False, sort_keys=True
    )

if __name__ == '__main__':
    main()
