from get_vh_recommendations_and_make_metrics_like_serp import get_programs
import argparse
import codecs
import time
from datetime import datetime as dt, timedelta
import json

def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--output', type=str, required=True)
    parser.add_argument('--date', type=str, required=True)
    parser.add_argument('--days_count', type=int, required=True)
    args = parser.parse_args()

    date_range = timedelta(days=args.days_count - 1)
    end_date = args.date
    start_date = dt.strptime(args.date, "%Y-%m-%d") - date_range
    start_date = start_date.strftime("%Y-%m-%d")
    print start_date, end_date
    a = get_programs(start_date, end_date)
    basket = []
    for channel_info in a.items():
        channel_name = channel_info[0]
        channel_title = channel_info[1]['info']['title']
        programs_by_channel = channel_info[1]
        for program in programs_by_channel['programs']:
            title = program['program_title']
            if program['program_title'] != program['title']:
                title = title + " " + program['title']
            basket.append({"text" : "https://frontend.vh.yandex.ru/player/" + str(program['content_id']),
                           "regionId" : 213, "device" : "DESKTOP",
                           "params" : [ {
                                         "name" : "content_id",
                                         "value" : str(program['content_id'])
                                        }, {
                                         "name" : "title",
                                         "value" : title
                                        }, {
                                         "name" : "channel_name",
                                         "value" : channel_name
                                        }, {
                                         "name" : "channel_title",
                                         "value" : channel_title
                                        }
                                  ]
                       })

    with codecs.open(args.output, 'w', 'utf8') as out:
        json.dump(basket, out, indent=2, ensure_ascii=False, sort_keys=True)

if __name__ == '__main__':
    main()
