import datetime
import time
from sessions import get_programs
import argparse
import json
import sys

def get_program(programs_by_channel, uuid, ts):
    for channel_info in programs_by_channel:
        channel_name = channel_info[0]
        program_by_channel = channel_info[1]
        if program_by_channel['info']['content_id'] == uuid:
            for program in program_by_channel['programs']:
                if program['start_time'] <= ts and program['end_time'] >= ts:
                    title = program['program_title']
                    if program['program_title'] != program['title']:
                        title = title + " " + program['title']
                    return title

def main():
    print sys.argv
    parser = argparse.ArgumentParser()
    parser.add_argument('--input', type=str, required=True)
    parser.add_argument('--output', type=str, required=True)
    args = parser.parse_args()

    current_date = datetime.datetime.now().strftime("%Y-%m-%d")
    one_day = datetime.timedelta(days=1)
    prev_date = datetime.datetime.now() - one_day
    prev_date = prev_date.strftime("%Y-%m-%d")

    marks = json.loads(open(args.input, 'r').read().decode('utf-8'))
    results = []
    programs_by_channel = []
    for date in [prev_date, current_date]:
        programs_by_channel += get_programs(date).items()
    current_timestamp = int(time.time())
    for mark in marks:
        mark["channel_program"] = get_program(programs_by_channel, mark["channel_uuid"], current_timestamp)
        if "uuid" in mark:
            mark["program"] = get_program(programs_by_channel, mark["uuid"], current_timestamp)
        results.append(mark)

    f = open(args.output, 'w')
    f.write(json.dumps(results, indent=2, ensure_ascii=False).encode("utf8"))
    f.close()

if __name__ == '__main__':
    main()
