#-*- coding: UTF-8 -*-
import nile
import argparse
import time
from nile.api.v1 import (
    filters as nf,
    aggregators as na,
    extractors as ne,
    statface as ns,
    clusters,
    Record
)
from qb2.api.v1 import (
    extractors as se,
    filters as sf
)
from copy import deepcopy
import datetime
import re
import json
import numpy as np
import sys
import os

REDIR_LOG_PREFIX = "statbox/redir-log"
THUMB_LOAD_ERROR_PATH = "690.1030.1724.8"

def get_event_stats(groups):
    for key, recs in groups:
        hits = 0
        for rec in recs:
            hits += 1
            url = rec["url"]
            platform = "desktop"
            domain = "ru"
            if not url:
                continue
            if "video/touch" in url:
                if "ui=webmobileapp.yandex" in url:
                    platform = "app"
                else:
                    platform = "touch"
            elif "video/pad" in url:
                platform = "pad"
            elif "ui=tvapp" in url:
                platform = "tvapp"
            if url.startswith("https://yandex."):
                domain = url[15:].split('/')[0]
            elif url.startswith("https://www.yandex."):
                domain = url[19:].split('/')[0]
        yield Record(platform=platform,
                     domain=domain,
                     hits=hits,
                     reqids=1)

def push_to_stat_new(report_table, scale, report, stat_username, stat_token):
    client = ns.StatfaceClient(proxy='upload.stat.yandex-team.ru',
                               username=stat_username,
                               token=stat_token)

    ns.StatfaceReport().path(report) \
                       .scale(scale) \
                       .client(client) \
                       .remote_publish(proxy='arnold',
                                       table_path=report_table,
                                       async_mode=False,
                                       upload_config=False)

def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--date', type=str, required=True)
    parser.add_argument('--stat_username', type=str, required=True)
    parser.add_argument('--stat_token', type=str, required=True)
    args = parser.parse_args()
    cluster = clusters.yt.Arnold().env(parallel_operations_limit=10,
                                    yt_spec_defaults=dict(
                                         pool_trees=["physical"],
                                         tentative_pool_trees=["cloud"],
                                         max_failed_job_count=200
                                     ),
                                    templates=dict(
                                        tmp_root='//home/videolog/tmp',
                                        title='ThumbErrorsStat'
                                  ))
    job = cluster.job()
    redir = job.table(REDIR_LOG_PREFIX + '/' + args.date)
    t = redir.qb2(log='redir-log',
                  fields=['path', 'reqid', 'url'],
                  filters=[sf.equals('path', THUMB_LOAD_ERROR_PATH)],
                  mode='yamr_lines') \
             .groupby('reqid') \
             .reduce(get_event_stats) \
             .groupby('domain', 'platform') \
             .aggregate(hits=na.sum('hits'), reqids=na.sum('reqids')) \
             .project(ne.all(), fielddate=ne.const(args.date)) \
             .put('//tmp/mma-2006/prepared_to_stat_' + args.date)
    job.run()

    push_to_stat_new('//tmp/mma-2006/prepared_to_stat_' + args.date, 'daily',
                         'Video.All/ThumbsErrorLoad', args.stat_username, args.stat_token)

if __name__ == '__main__':
    main()
