#!/usr/bin/env python
# -*- coding: utf-8 -*-
import requests
import json
import argparse
import codecs
import time
from datetime import datetime as dt, timedelta
import re
import sys

content_url_re = re.compile(r'^https:\/\/strm\.yandex\.ru\/dvr\/(.*?)/.*$')
content_url_kal_re = re.compile(r'^https:\/\/strm\.yandex\.ru\/kal\/(.*?)\/.*$')

def get_channel_programs(parent_id, date_from, date_to):
    url = 'https://frontend.vh.yandex.ru/episodes?parent_id=%s&end_date__from=%s&start_date__to=%s&geo_id=213&locale=ru' % (
        parent_id, date_from, date_to)

    resp = retry_request('get', kwargs=dict(url=url))
    data = json.loads(resp.text)

    res = data.get('set')

    if not len(res):
        return {}

    return res

def get_channel_by_content_url(content_url):
    match = content_url_re.findall(content_url)

    if (content_url == 'https://www.1tv.ru/embedlive'):
        return '1tv'

    if match:
        return match[0]

    match = content_url_kal_re.findall(content_url)

    if match:
        return match[0]

    return ''

def retry_request(request_type, args=None, kwargs=None):
    if not args:
        args = []
    if not kwargs:
        kwargs = {}
    req = None
    retries = 0
    while ((req is None or req.status_code >= 300) and retries < 10):
        try:
            req = getattr(requests, request_type)(*args, **kwargs)
        except Exception as e:
            time.sleep(60)
            retries += 1
    return req

def get_channels():
    url = 'https://frontend.vh.yandex.ru/channels?geo_id=213&locale=ru&content_type_name=channel'

    resp = retry_request('get', kwargs=dict(url=url))
    data = json.loads(resp.text)

    res = data.get('set')

    if not len(res):
        return {}

    return res

def get_programs(start_date, end_date):
    channels = get_channels()
    channel_programs = {}

    date_from = str(dt.strptime(start_date, '%Y-%m-%d').replace(hour=0,
                                                          minute=0, second=0).strftime("%s"))
    date_to = str(dt.strptime(end_date, '%Y-%m-%d').replace(hour=23,
                                                        minute=59, second=59).strftime("%s"))

    if not len(channels):
        return {}

    for channel in channels:
        channel_name = get_channel_by_content_url(channel['content_url'])

        if channel_name == '':
            continue

        if channel_name in channel_programs and len(channel_programs[channel_name]['programs']):
            continue

        channel_programs[channel_name] = {
            'info': channel,
            'programs': get_channel_programs(channel['content_id'], date_from, date_to)
        }

    return channel_programs

def get_program(programs_by_channel, uuid, ts):
    for channel_info in programs_by_channel:
        channel_name = channel_info[0]
        program_by_channel = channel_info[1]
        if program_by_channel['info']['content_id'] == uuid:
            print "have channel"
            for program in program_by_channel['programs']:
                if program['start_time'] <= ts and program['end_time'] >= ts:
                    title = program['program_title']
                    if program['program_title'] != program['title']:
                        title = title + " " + program['title']
                    return title
    print "No program"

DEFAULT_REQUEST_TEMPLATE = "https://vh-testing.yandex.net/recommender/doc2doc?content_id={}"
DEFAULT_CONTENT_REQUEST_TEMPLATE = "https://frontend.vh.yandex.ru/player/{}.json"

DEFAULT_PLAYER_TEMPLATE = (
    u'<iframe src="{}?from=yavideo&autoplay=0"'
    ' frameborder="0" scrolling="no" '
    'allowfullscreen="1" aria-label="Video"></iframe>'
)

DEFAULT_URL_TEMPLATE = "https://frontend.vh.yandex.ru/player/{}"

def main():
    print sys.argv
    parser = argparse.ArgumentParser()
    parser.add_argument('--input', type=str, required=True)
    parser.add_argument('--output', type=str, required=True)
    parser.add_argument('--request_template', type=str, default=DEFAULT_REQUEST_TEMPLATE)
    parser.add_argument('--content_request_template', type=str, default=DEFAULT_CONTENT_REQUEST_TEMPLATE)
    parser.add_argument('--player_template', type=str, default=DEFAULT_PLAYER_TEMPLATE)
    parser.add_argument('--url_template', type=str, default=DEFAULT_URL_TEMPLATE)
    parser.add_argument('--attempt_count', type=int, default=5)
    args = parser.parse_args()

    with codecs.open(args.input, 'r', 'utf8') as inp:
        data = json.load(inp)

    results = []
    current_date = dt.now().strftime("%Y-%m-%d")
    current_timestamp = int(time.time())
    for elem in data:
        metrics_like_data = {"query" : {"text" : args.url_template.format(elem["content_group_id"])},
                             "query_param.name" : elem["name"],
                             "query_param.content_group_id" : elem["content_group_id"],
                             "query_param.query_code" : args.player_template.format(args.url_template.format(elem["content_group_id"])),
                             "type" : "SERP"}
        try:
            answer = requests.get(args.content_request_template.format(elem["content_group_id"])).json()
            metrics_like_data["query_param.query_title"] = answer["content"]["computed_title"]
        except:
            print "Can't get content data"
            continue

        components_metrics_like_data = []
        print args.request_template.format(elem["content_group_id"])
        i = 0
        while i < args.attempt_count:
            try:
                answer = requests.get(args.request_template.format(elem["content_group_id"])).json()
                if not answer["set"]:
                    raise ValueError("empty answer")
                for result in answer["set"]:
                    content_id = result["content_id"]
                    url = args.url_template.format(content_id)
                    player = args.player_template.format(url)
                    component_metrics_like_info = {"componentInfo": {"alignment": 3,
                                                                     "rank": 1,
                                                                     "type": 1},
                                                   "componentUrl" : {"pageUrl" : url, "viewUrl" : "frontend.vh.yandex.ru"},
                                                   "text.title" : result["computed_title"],
                                                   "thumbadd" : {"urls" : [],
                                                                 "thumbSource" : None,
                                                                 "videoPlayerHtml" : player},
                                                   "text.videoDuration": "00:00",
                                                   "type": "COMPONENT"}
                    components_metrics_like_data.append(component_metrics_like_info)
                metrics_like_data["components"] = components_metrics_like_data
                results.append(metrics_like_data)
                break
            except:
                print "Can't get data, will try again"
                time.sleep(10)
                i += 1
                continue

    with codecs.open(args.output, 'w', 'utf8') as out:
        json.dump(results, out, indent=2, ensure_ascii=False, sort_keys=True)

if __name__ == '__main__':
    main()
