# -*- coding: utf-8 -*-
import sys
import os
import codecs
import argparse
from datetime import datetime, timedelta
from nile.api.v1 import (
    filters as nf,
    aggregators as na,
    extractors as ne,
    clusters,
    Record
)
import json
import time
from random import randint

def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--data', type=str)
    parser.add_argument('--additive', type=str)
    parser.add_argument('--cluster', default='arnold')
    args = parser.parse_args()

    if args.cluster == 'hahn':
        cluster = clusters.yt.Hahn()
    else:
        cluster = clusters.yt.Arnold()
    table_additive = args.additive
    with codecs.open(args.data, "r", "utf8") as inp:
        data = json.load(inp)
    max_pool_date = None
    for elem in data:
        timestamp = elem["ts"] / 1000
        date = datetime.fromtimestamp(timestamp) - timedelta(days=1)
        date_str = date.strftime('%Y-%m-%d')
        if not max_pool_date or date_str > max_pool_date:
            max_pool_date = date_str
    print "Max pool date is {}.".format(max_pool_date)

    max_table_date = cluster.driver.client.get_attribute(table_additive, '_max_date', '')
    while len(max_table_date) == 0 or max_table_date < max_pool_date:
        print "Wait for calc stats, current calculated date is {}".format(max_table_date)
        time.sleep(randint(1, 3600))
        max_table_date = cluster.driver.client.get_attribute(table_additive, '_max_date', '')

if __name__ == "__main__":
    main()
