#-*- coding: UTF-8 -*-
from common import TMP_HITMAN_TV_ONLINE_RECOMMENDATIONS

from nile.api.v1 import (
    filters as nf,
    aggregators as na,
    extractors as ne,
    statface as ns,
    clusters,
    Record
)

from qb2.api.v1 import (
    extractors as se,
    filters as sf
)

import argparse
from time import time
from random import random
import sys
import codecs
from copy import deepcopy
import hashlib
import json

def push_to_stat_new(report_table, proxy, scale, report, username, stat_token):
    client = ns.StatfaceClient(proxy='upload.stat.yandex-team.ru',
                               username=username,
                               token=stat_token)

    ns.StatfaceReport().path(report) \
                       .scale(scale) \
                       .client(client) \
                       .remote_publish(proxy=proxy,
                                       table_path=report_table,
                                       async_mode=False,
                                       upload_config=False)

class calc_stats(object):
    def __init__(self, date):
        self.date = date
    def __call__(self, recs):
        for rec in recs:
            if "p" in rec["key"]:
                continue
            data = json.loads(rec["value"])
            next_seria = 0
            for seria_info in data["series"]:
                if seria_info["info"].get("reason") == "next-seria":
                    next_seria += 1
            yield Record(fielddate=self.date,
                         films=len(data["films"]),
                         oo_films=len(data.get("oo_films", [])),
                         series=len(data["series"]),
                         next_seria=next_seria,
                         channels=len(data["channels"]),
                         bloggers=len(data["bloggers"]),
                         has_film=len(data["films"]) > 0,
                         has_oo_film=len(data.get("oo_films", [])) > 0,
                         has_series=len(data["series"]) > 0,
                         has_next_seria=next_seria > 0,
                         has_channels=len(data["channels"]) > 0,
                         has_bloggers=len(data["bloggers"]) > 0)

def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--cluster', type=str, required=True)
    parser.add_argument('--date', type=str, required=True)
    parser.add_argument('--recommendations_table', type=str, required=True)
    parser.add_argument('--min_recommendatinos_table_size', type=int, required=True)
    parser.add_argument('--stat_username', type=str, required=True)
    parser.add_argument('--stat_token', type=str, required=True)
    args = parser.parse_args()

    cluster_name = args.cluster.lower()

    if cluster_name == 'hahn':
        cluster = clusters.yt.Hahn()
    elif cluster_name == 'arnold':
        cluster = clusters.yt.Arnold()
    else:
        raise ValueError("Unsupported cluster '{}'. Choose 'hahn' (recommended) or 'arnold'".format(args.cluster))

    if cluster.driver.client.get_attribute(args.recommendations_table, 'row_count', 0) < args.min_recommendatinos_table_size:
        raise Exception("Recommendations table is too small")

    stats_table = TMP_HITMAN_TV_ONLINE_RECOMMENDATIONS + "/msvvitaly_test_calc_stats_" + args.date
    job = cluster.job()

    stats = job.table(args.recommendations_table) \
               .map(calc_stats(args.date)) \
               .groupby('fielddate') \
               .aggregate(films=na.mean('films'),
                          oo_films=na.mean('oo_films'),
                          series=na.mean('series'),
                          next_seria=na.mean('next_seria'),
                          channels=na.mean('channels'),
                          bloggers=na.mean('bloggers'),
                          has_film=na.sum('has_film'),
                          has_oo_film=na.sum('has_oo_film'),
                          has_series=na.sum('has_series'),
                          has_next_seria=na.sum('has_next_seria'),
                          has_channels=na.sum('has_channels'),
                          has_bloggers=na.sum('has_bloggers')) \
               .put(stats_table)

    job.run()

    push_to_stat_new(stats_table, args.cluster, 'daily', 'Video.All/Notifier_stats', args.stat_username, args.stat_token)

if __name__ == '__main__':
    main()
