#-*- coding: UTF-8 -*-
from common import *

HISTORY_DAYS_COUNT = 28

HAS_ETHER_VIEW_TVT_THRESHOLD = 300


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--date', type=str, required=True)
    parser.add_argument('--period', type=int, required=True)
    parser.add_argument('--recommendations', type=str, required=True)
    parser.add_argument('--output_prefix', type=str, required=True)
    parser.add_argument('--output_table_for_push', type=str, required=True)
    parser.add_argument('--output_table_for_bell', type=str, required=True)
    args = parser.parse_args()

    cluster = clusters.yt.Hahn().env(parallel_operations_limit=10,
                                         yt_spec_defaults=dict(
                                             pool_trees=["physical"],
                                             tentative_pool_trees=["cloud"]
                                         ),
                                         templates=dict(
                                             tmp_root='//tmp',
                                             title='GetNonReturnedUsers'
                                         ))

    end_date = dt.strptime(args.date, "%Y-%m-%d")
    recommendations_table = args.output_prefix + "recommendations"
    job = cluster.job()

    PERCENTAGE_EXISTING_TABLES = 0.5

    prev_period_tables_paths = [TV_ONLINE_STATS_PREFIX + dt.strftime(end_date - timedelta(delta), "%Y-%m-%d") for delta in xrange(args.period)]
    prev_period_tables = [job.table(table_path) for table_path in
                          get_tables_paths_ignore_missing(cluster, prev_period_tables_paths, PERCENTAGE_EXISTING_TABLES, IgnorePolicy.LAST_MUST_EXIST)]

    prev_prev_period_tables_paths = [TV_ONLINE_STATS_PREFIX + dt.strftime(end_date - timedelta(delta + args.period), "%Y-%m-%d") for delta in xrange(HISTORY_DAYS_COUNT)]
    prev_prev_period_tables = [job.table(table_path) for table_path in
                               get_tables_paths_ignore_missing(cluster, prev_prev_period_tables_paths, PERCENTAGE_EXISTING_TABLES, IgnorePolicy.PERCENT_OF_ALL)]

    prev_period_uids = job.concat(*prev_period_tables) \
                .filter(sf.custom(has_ether_view(HAS_ETHER_VIEW_TVT_THRESHOLD), "tv_online_stats")) \
                .groupby('uid') \
                .aggregate(count=na.count()) \
                .project(prev_period_uid='uid') \
                .put(args.output_prefix + "prev_period_uids")

    prev_prev_period_uids = job.concat(*prev_prev_period_tables) \
                .filter(sf.custom(has_ether_view(HAS_ETHER_VIEW_TVT_THRESHOLD), "tv_online_stats")) \
                .groupby('uid') \
                .aggregate(count=na.count()) \
                .project(prev_prev_period_uid='uid') \
                .put(args.output_prefix + "prev_prev_uids")

    not_returned_users = prev_prev_period_uids.join(prev_period_uids,
                                                  by_left='prev_prev_period_uid',
                                                  by_right='prev_period_uid',
                                                  type='left') \
                                            .filter(sf.not_(sf.defined('prev_period_uid'))) \
                                            .project(uid='prev_prev_period_uid') \
                                            .join(job.table(args.recommendations),
                                                  by_left='uid',
                                                  by_right='key',
                                                  type='left') \
                                            .project('uid', recommendations='value') \
                                            .put(recommendations_table)
    job.run()

    prepare_uids_to_push(cluster, recommendations_table, args.output_table_for_push, ['recommendations'], False)

    prepare_uids_to_bell(cluster, recommendations_table, args.output_table_for_bell, ['recommendations'], False)


if __name__ == "__main__":
    main()
