#-*- coding: UTF-8 -*-
MIN_BLOGGER_TVT = 10 * 60
MIN_BLOGGER_VIEWS = 3

from common import *

def make_data_for_push(push_template, table,
                       title, body_template,
                       stream_id, from_block,
                       blogger, episode_name, schedule, ttl, regions=[]):
    push = deepcopy(push_template)
    regions_add = ""
    if len(regions) > 0:
        regions_add += " AND geo_5 IN (" + ",".join(regions) + ")"
    push["receiver"] = [push["receiver"].format("yt:{}?".format(table)) + regions_add]
    push["notification"]["title"] = title.format(blogger)
    push["notification"]["body"] = body_template.format(episode_name)

    push["data"]["push_uri"] = push["data"]["push_uri"].format("yandex", stream_id, from_block)
    push["data"]["push_id"] = from_block
    push["data"]["content_id"] = stream_id

    push["ttl"] = ttl
    push["schedule"] = schedule
    return json.dumps(push, ensure_ascii=False)

def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--push_folder', type=str, required=True)
    parser.add_argument('--desktop_push_template', type=str, required=True)
    parser.add_argument('--mobile_push_template', type=str, required=True)
    parser.add_argument('--pp_push_template', type=str, required=True)
    parser.add_argument('--regions', type=str, required=True)
    parser.add_argument('--title', type=str, required=True)
    parser.add_argument('--body_template', type=str, required=True)
    parser.add_argument('--ttl', type=int, required=True)
    parser.add_argument('--schedule', type=str, required=True)
    parser.add_argument('--from_block', type=str, required=True)
    parser.add_argument('--new_documents', type=str, required=True)
    parser.add_argument('--recipients', type=str, required=True)
    parser.add_argument('--timestamp_str', type=str, required=True)
    args = parser.parse_args()

    push_folder = args.push_folder if not args.push_folder.endswith('/') else args.push_folder[:-1]

    title = args.title.decode('utf8')
    body_template = args.body_template.decode('utf8')

    desktop_push_template = get_push_template(args.desktop_push_template)
    mobile_push_template = get_push_template(args.mobile_push_template)
    pp_push_template = get_push_template(args.pp_push_template)
    new_documents = get_mr_table(args.new_documents)
    recipients = get_mr_table(args.recipients)

    regions = get_regions(args.regions)

    cluster = clusters.yt.Hahn().env(parallel_operations_limit=10,
                                     yt_spec_defaults=dict(
                                         pool_trees=["physical"],
                                         tentative_pool_trees=["cloud"]
                                     ),
                                     templates=dict(
                                         tmp_root='//tmp',
                                         title='BloggerNewContentRecommendations'
                                     ))

    # read new docs
    print("start read docs")
    new_videos = {}
    for rec in cluster.driver.read(new_documents):
        new_videos[rec["uuid"]] = {
            "episode_name": rec["title"].decode('utf8'),
            "publisher_name": rec["publisher_name"].decode('utf8'),
            "install_ids": []
        }
    print("end read doc")

    # read recipients
    print("start read recipients")
    for rec in cluster.driver.read(recipients):
        new_videos[rec["uuid"]]["install_ids"].append(Record(install_id=rec["install_id"]))
    print("end read recipients")

    print("START WRITE")
    records = []
    for uuid, blogger_info in new_videos.items():
        print("--------------------------------------------------------------> ", uuid)
        if blogger_info["episode_name"] == "test video":
            continue
        install_ids = blogger_info["install_ids"]
        if len(install_ids) == 0:
            continue
        blogger_uids_table = (push_folder + '/new_blogger_content_{}/blogger_{}').format(args.timestamp_str, uuid)
        print(blogger_uids_table, len(install_ids))
        cluster.driver.write(blogger_uids_table, install_ids)


        desktop_push = make_data_for_push(desktop_push_template, blogger_uids_table,
                                          title, body_template,
                                          uuid, args.from_block + "_desktop",
                                          blogger_info["publisher_name"], blogger_info["episode_name"], args.schedule, args.ttl)
        pp_push = make_data_for_push(pp_push_template, blogger_uids_table,
                                     title, body_template,
                                     uuid, args.from_block + "_pp",
                                     blogger_info["publisher_name"], blogger_info["episode_name"], args.schedule, args.ttl, regions)
        mobile_browser_push = make_data_for_push(mobile_push_template, blogger_uids_table,
                                                 title, body_template,
                                                 uuid, args.from_block + "_mobile",
                                                 blogger_info["publisher_name"], blogger_info["episode_name"], args.schedule, args.ttl, regions)
        records.append(Record(push=desktop_push))
        records.append(Record(push=pp_push))
        records.append(Record(push=mobile_browser_push))

    print("END WRITE")
    push_table = push_folder + '/' + args.timestamp_str + '_first_2'
    cluster.driver.write(push_table, records)

if __name__ == '__main__':
    main()

