#-*- coding: UTF-8 -*-
import nile
import argparse
import time
from nile.api.v1 import (
    filters as nf,
    aggregators as na,
    extractors as ne,
    statface as ns,
    clusters,
    Record
)
from qb2.api.v1 import (
    extractors as se,
    filters as sf
)
from copy import deepcopy
import uatraits
import urllib
from datetime import datetime as dt, timedelta
import os
import sys
import codecs
from random import random
import hashlib
import urllib2
import json

def make_data_for_custom(puid, stream_id, from_block, custom, thumb):
    url = "https://yandex.ru/efir?stream_id={0}&from_block={1}_bell".format(stream_id, from_block)

    meta = {
        "text": {
            "type": "string",
            "text": custom
        },
        "action": {
            "type": "link",
            "link": url
        }
    }

    if thumb:
        meta["entity"] = {
                "type": "resource",
                "preview": thumb
        }

    return "&service=ether&actor=ya_ether&uid={0}&type={1}&meta={2}&group_key={3}".format(
        puid,
        "custom",
        urllib2.quote(json.dumps(meta)),
        stream_id
    )

def main():

    parser = argparse.ArgumentParser()
    parser.add_argument('--input_table', type=str, required=True)
    parser.add_argument('--from_block', type=str, required=True)
    parser.add_argument('--stream_id', type=str, required=True)
    parser.add_argument('--custom', type=str, required=True)
    parser.add_argument('--thumb', type=str, default="")
    parser.add_argument('--output_table', type=str, required=True)
    args = parser.parse_args()

    cluster = clusters.yt.Hahn().env(parallel_operations_limit=10,
                                     yt_spec_defaults=dict(
                                         pool_trees=["physical"],
                                         tentative_pool_trees=["cloud"]
                                     ),
                                     templates=dict(
                                         tmp_root='//tmp',
                                         title='MakeDataForCustom'
                                     ))

    job = cluster.job()
    job.table(args.input_table).project(ne.all(),
                                        from_block=ne.const(args.from_block),
                                        stream_id=ne.const(args.stream_id),
                                        custom=ne.const(args.custom),
                                        thumb=ne.const(args.thumb)) \
       .groupby('puid').aggregate(stream_id=na.any('stream_id'), from_block=na.any('from_block'), custom=na.any('custom'), thumb=na.any('thumb')) \
       .project(ne.all(), data=ne.custom(make_data_for_custom, 'puid', 'stream_id', 'from_block', 'custom', 'thumb')) \
       .put(args.output_table)
    job.run()

if __name__ == "__main__":
    main()
