#-*- coding: UTF-8 -*-
from common import *

from random import randint
from time import time
import urllib2
import hashlib

import codecs
import json

YA_SHOW_CONFIG = []


def is_ya_show(uuid):
    for seria in YA_SHOW_CONFIG:
        if seria["UUID"] == uuid or seria["ContentGroupID"] == uuid:
            return True
    return False


def write_show_info(cluster, date, ya_show_info_table):
    records = []

    new_episode_uuid = None
    for elem in YA_SHOW_CONFIG:
        if elem["date"] == date:
            new_episode_uuid = elem["UUID"]

    if new_episode_uuid:
        for i in range(len(YA_SHOW_CONFIG) - 1):
            records.append(Record(serial_id="ya_show",
                                  duration=YA_SHOW_CONFIG[i]["duration"],
                                  serial_name_with_braces="«Такая история»",
                                  UUID=YA_SHOW_CONFIG[i]["UUID"],
                                  Episode=i + 1,
                                  Season=1,
                                  NextUUID=YA_SHOW_CONFIG[i + 1]["UUID"],
                                  NextEpisode=i + 2,
                                  NextSeason=1,
                                  NewEpisodeUUID=new_episode_uuid,
                                  RestrictionAgeNext="12"))
            records.append(Record(serial_id="ya_show",
                                  duration=YA_SHOW_CONFIG[i]["duration"],
                                  serial_name_with_braces="«Такая история»",
                                  UUID=YA_SHOW_CONFIG[i]["ContentGroupID"],
                                  Episode=i + 1,
                                  Season=1,
                                  NextUUID=YA_SHOW_CONFIG[i + 1]["UUID"],
                                  NextEpisode=i + 2,
                                  NextSeason=1,
                                  NewEpisodeUUID=new_episode_uuid,
                                  RestrictionAgeNext="12"))

    cluster.driver.write(ya_show_info_table, records)

YA_SHOW_NEW_EPISODE_PUSH_BODIES = [u"Чем запомнился этот день — смотрите в «Такой истории» (12+)",
                                   u"«Такая история» про этот день — смотрите новую серию (12+)"]
YA_SHOW_NEW_EPISODE_PUSH_TITLES = [u"Яндекс.Эфир",
                                   u"Яндекс.Эфир"]

YA_SHOW_NEW_EPISODE_BELL_TEXTS = [u"Чем запомнился этот день — смотрите в «Такой истории» (12+)",
                                  u"«Такая история» про этот день — смотрите новую серию (12+)"]

YA_SHOW_NEXT_EPISODE_PUSH_COMMON_BODIES = [u"«Такая история» — смотрите следующую серию (12+)"]
YA_SHOW_NEXT_EPISODE_PUSH_COMMON_TITLES = [u"Яндекс.Эфир"]

YA_SHOW_NEXT_EPISODE_BELL_COMMON_TEXTS = [u"«Такая история» — смотрите следующую серию (12+)"]

YA_SHOW_NEW_EPISODE_MIN_PUSH_TIMEDELTA = 3 * 24 * 60 * 60

def get_possible_push_titles_and_bodies(uuid, new_episode_uuid):
    possible_bodies = []
    possible_titles = []
    if uuid == new_episode_uuid:
        possible_bodies += YA_SHOW_NEW_EPISODE_PUSH_BODIES
        possible_titles += YA_SHOW_NEW_EPISODE_PUSH_TITLES
    else:
        possible_bodies += YA_SHOW_NEXT_EPISODE_PUSH_COMMON_BODIES
        possible_titles += YA_SHOW_NEXT_EPISODE_PUSH_COMMON_TITLES

    for elem in YA_SHOW_CONFIG:
        if elem["UUID"] == uuid and elem.get("bodies"):
            possible_bodies += elem["bodies"]
            possible_titles += elem["titles"]

    return possible_titles, possible_bodies

def get_possible_bell_texts(uuid, new_episode_uuid):
    possible_texts = []

    if uuid == new_episode_uuid:
        possible_texts += YA_SHOW_NEW_EPISODE_BELL_TEXTS
    else:
        possible_texts += YA_SHOW_NEXT_EPISODE_BELL_COMMON_TEXTS

    for elem in YA_SHOW_CONFIG:
        if elem["UUID"] == uuid and elem.get("texts"):
            possible_texts += elem["texts"]

    return possible_texts

def make_data_for_next_episode_bell(puid, stream_id, from_block, series, episode, season):
    url = "https://yandex.ru/efir?stream_id={0}&from_block={1}_bell".format(stream_id, from_block)

    meta = {
        "series": {
            "type": "text",
            "text": series
        },
        "episode": {
            "type": "text",
            "text": str(episode)
        },
        "season": {
            "type": "text",
            "text": str(season)
        },
        "action": {
            "type": "link",
            "link": url
        }
    }

    return "&service=ether&actor=ya_ether&uid={0}&type={1}&meta={2}&group_key={3}".format(
        puid,
        "next-episode",
        urllib2.quote(json.dumps(meta)),
        stream_id
    )

def make_data_for_show_bell(puid, text, from_block, stream_id, thumb=""):
    url = "https://yandex.ru/efir?stream_id={0}&from_block={1}_bell".format(stream_id, from_block)

    meta = {
        "text": {
            "type": "string",
            "text": text
        },
        "action": {
            "type": "link",
            "link": url
        }
    }

    if thumb:
        meta["entity"] = {
                "type": "resource",
                "preview": thumb
        }

    return "&service=ether&actor=ya_ether&uid={0}&type={1}&meta={2}&group_key={3}".format(
        puid,
        "custom",
        urllib2.quote(json.dumps(meta)),
        stream_id
    )

def additional_restriction_age(restriction_age):
    return " ({}+)".format(restriction_age) if restriction_age is not None else ""

class make_data_for_next_seria_bell(object):
    def __init__(self,
                 min_push_timedelta,
                 testing_mode,
                 from_block):
        self.min_push_timedelta = min_push_timedelta
        self.testing_mode = testing_mode
        self.from_block = from_block

    def __call__(self, groups):
        for key, recs in groups:
            serials_info = []
            current_ts = int(time())
            next_seria_sended = False
            ya_show = None

            for rec in recs:
                if not self.testing_mode and not can_send_push(current_ts, rec.get("timestamps", []), self.min_push_timedelta):
                    break
                if not self.testing_mode and rec["UUID"] in rec.get("content_ids", []):
                    if rec["serial_id"] != "ya_show":
                        continue
                    if rec["serial_id"] == "ya_show" and not rec.get("NewEpisodeUUID"):
                        continue
                    if not self.testing_mode and not can_send_push(current_ts, rec.get("timestamps", []), YA_SHOW_NEW_EPISODE_MIN_PUSH_TIMEDELTA):
                        continue
                serials_info.append(rec.to_dict())
                if rec["serial_id"] == "ya_show":
                    ya_show = rec.to_dict()
                    next_seria_sended = rec["UUID"] in rec.get("content_ids", [])

            from_block = self.from_block
            if ya_show != None:
                uuid = ya_show["UUID"]
                if next_seria_sended:
                    uuid = ya_show["NewEpisodeUUID"]
                from_block += "_takayaistoriya"

                possible_texts = get_possible_bell_texts(uuid, ya_show["NewEpisodeUUID"])
                if uuid == ya_show["NewEpisodeUUID"]:
                    from_block += "_new_episode"

                text_index = randint(0, len(possible_texts) - 1)
                text = possible_texts[text_index]
                from_block += "_text_exp_{}".format(text_index)

                yield Record(puid=key["puid"],
                             content_ids=[uuid],
                             from_block=from_block,
                             timestamps=[current_ts],
                             data=make_data_for_show_bell(key['puid'],
                                                          text,
                                                          from_block,
                                                          uuid
                                                          ))
                continue
            for rec in serials_info:
                yield Record(puid=key["puid"],
                             content_ids=[rec["UUID"]],
                             from_block=from_block,
                             timestamps=[current_ts],
                             data=make_data_for_next_episode_bell(key['puid'],
                                                     rec["UUID"],
                                                     from_block,
                                                     rec["serial_name_with_braces"] + additional_restriction_age(rec["RestrictionAgeNext"]),
                                                     rec["episode"],
                                                     rec["season"]))
                break

def aggregate_sended_bells(groups):
    for key, recs in groups:
        common_texts = []
        content_ids = []
        timestamps = []
        for rec in recs:
            common_texts += rec.get("common_texts", [])
            content_ids += rec.get("content_ids", [])
            timestamps += rec.get("timestamps", [])
        yield Record(puid=key["puid"],
                     common_texts=common_texts,
                     content_ids=content_ids,
                     timestamps=timestamps)

class make_data_for_next_seria_push(object):
    def __init__(self,
                 from_block,
                 testing_mode,
                 min_push_timedelta,
                 schedule,
                 ttl):
        self.from_block = from_block
        self.testing_mode = testing_mode
        self.min_push_timedelta = min_push_timedelta
        self.schedule = schedule
        self.ttl = ttl

    def __call__(self, groups):
        for key, recs in groups:

            serials_info = []
            current_ts = int(time())
            ya_show = None
            next_seria_sended = False

            ya_show_episode_number_by_uuid = {}
            for i, elem in enumerate(YA_SHOW_CONFIG):
                ya_show_episode_number_by_uuid[elem["UUID"]] = i

            install_id_hash = int(hashlib.md5(key["install_id"]).hexdigest(), 16)
            exp_id = install_id_hash % 4
            suffix = ""

            for rec in recs:
                if not self.testing_mode and not can_send_push(current_ts, rec.get("timestamps", []), self.min_push_timedelta):
                    break
                if not self.testing_mode and rec["UUID"] in rec.get("content_ids", []):
                    if rec["serial_id"] != "ya_show":
                        continue
                    if rec["serial_id"] == "ya_show" and not rec.get("NewEpisodeUUID"):
                        continue

                    new_episodes_show_sends = 0
                    for uuid in rec.get("content_ids"):
                        if ya_show_episode_number_by_uuid.get(uuid, 0) > ya_show_episode_number_by_uuid[rec["UUID"]]:
                            new_episodes_show_sends += 1

                    if new_episodes_show_sends > exp_id:
                        continue

                    suffix = "intensity_exp_{}".format(exp_id)

                serials_info.append(rec.to_dict())
                if rec["serial_id"] == "ya_show":
                    ya_show = rec.to_dict()
                    next_seria_sended = rec["UUID"] in rec.get("content_ids", [])

            from_block = self.from_block
            if ya_show != None:
                from_block += "_takayaistoriya"
                uuid = ya_show["UUID"]
                if next_seria_sended:
                    uuid = ya_show["NewEpisodeUUID"]

                possible_titles, possible_bodies = get_possible_push_titles_and_bodies(uuid, ya_show["NewEpisodeUUID"])
                if uuid == ya_show["NewEpisodeUUID"]:
                    from_block += "_new_episode"

                title_body_index = randint(0, len(possible_bodies) - 1)
                title = possible_titles[title_body_index]
                body = possible_bodies[title_body_index]
                from_block += "_text_exp_{}".format(title_body_index) + suffix
                url = ETHER_PUSH_URL_TEMPLATE.format(uuid, from_block)

                yield Record(install_id=key["install_id"],
                             title=title,
                             body=body,
                             content_id=uuid,
                             push_id=from_block,
                             url=url,
                             schedule=self.schedule,
                             ttl=self.ttl,
                             content_ids=[uuid],
                             timestamps=[current_ts])
                continue
            for rec in serials_info:
                uuid = rec["UUID"]
                title = u"Яндекс.Эфир"
                body = u'{} - cмотрите следующую серию{}'.format(
                    rec["serial_name_with_braces"].decode("utf8"),
                    additional_restriction_age(rec["RestrictionAgeNext"]),
                )
                url = ETHER_PUSH_URL_TEMPLATE.format(uuid, from_block)

                yield Record(install_id=key["install_id"],
                             title=title,
                             body=body,
                             content_id=uuid,
                             push_id=from_block,
                             url=url,
                             schedule=self.schedule,
                             ttl=self.ttl,
                             content_ids=[uuid],
                             timestamps=[current_ts])
                break

def get_next_seria_info(groups):
    for key, recs in groups:
        season_episode_list = []
        for rec in recs:
            season_episode_list.append((rec["season"], rec["episode"], rec["UUID"], rec))
        season_episode_list.sort()
        for i in range(len(season_episode_list) - 1):
            yield Record(serial_id=key["serial_id"],
                         duration=season_episode_list[i][3]["duration"],
                         serial_name_with_braces=season_episode_list[i][3]["serial_name_with_braces"],
                         UUID=season_episode_list[i][3]["UUID"],
                         Episode=season_episode_list[i][1],
                         Season=season_episode_list[i][0],
                         NextUUID=season_episode_list[i + 1][2],
                         NextEpisode=season_episode_list[i + 1][1],
                         NextSeason=season_episode_list[i + 1][0],
                         RestrictionAgeNext=season_episode_list[i + 1][3]["restriction_age"])

def get_uid_serial_info(recs):
    for rec in recs:
        for uuid in rec.get("tv_online_stats", []):
            yield Record(uid=rec["uid"],
                         UUID=uuid,
                         tvt=rec["tv_online_stats"][uuid]["tvt"])

def aggregate_sended_pushes(groups):
    for key, recs in groups:
        common_texts = []
        content_ids = []
        timestamps = []
        for rec in recs:
            common_texts += rec.get("common_texts", [])
            content_ids += rec.get("content_ids", [])
            timestamps += rec.get("timestamps", [])
        yield Record(install_id=key["install_id"],
                     common_texts=common_texts,
                     content_ids=content_ids,
                     timestamps=timestamps)

def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--desktop_push_template', type=str, required=True)
    parser.add_argument('--mobile_push_template', type=str, required=True)
    parser.add_argument('--pp_push_template', type=str, required=True)
    parser.add_argument('--ya_show_episodes', type=str, required=True)
    parser.add_argument('--from_block', type=str, required=True)
    parser.add_argument('--output_dir', type=str, required=True)
    parser.add_argument('--sended_pushes_table', type=str, required=True)
    parser.add_argument('--sended_bells_table', type=str, required=True)
    parser.add_argument('--schedule', type=str, required=True)
    parser.add_argument('--ttl', type=int, required=True)
    parser.add_argument('--input_stat_table', type=str, required=True)
    parser.add_argument('--date', type=str, required=True)
    parser.add_argument('--regions', type=str, required=True)
    parser.add_argument('--min_push_timedelta', type=int, required=True)
    parser.add_argument('--testing_mode', default=False, action="store_true")
    parser.add_argument('--prepare_bell', default=False, action="store_true")
    args = parser.parse_args()

    global YA_SHOW_CONFIG
    with codecs.open(args.ya_show_episodes, "r", encoding="utf8") as ya_show_file:
        YA_SHOW_CONFIG = json.load(ya_show_file)

    desktop_push_templates = [get_push_template(args.desktop_push_template)]
    mobile_push_templates = [get_push_template(args.mobile_push_template),
                             get_push_template(args.pp_push_template)]

    regions = get_regions(args.regions)

    cluster = get_cluster('hahn', title='NewSeriesPush')

    vh_serial_uuids = set()
    for rec in cluster.driver.read(VH_OTT_INFO):
        if rec["content_type"] == "ott-episode" and not rec["is_animation"]:
            vh_serial_uuids.add(rec["uuid"])

    tv_online_uids_ready_table = args.output_dir + "/uids_ready"
    tv_online_puids_ready_table = args.output_dir + "/puids_ready"
    tv_online_stat_table = args.output_dir + "/tv_online_stat"

    stats_for_show = []
    for table in sorted(cluster.driver.list(STATS_PREFIX[:-1])):
        if table.startswith("tv_online_"):
            stats_for_show.append(STATS_PREFIX + table)
    stats_for_show = sorted(stats_for_show)[-14:]
    job = cluster.job()
    tv_online_stats_for_show = job.concat(*[job.table(table) for table in stats_for_show]) \
                                  .map(get_uid_serial_info) \
                                  .filter(nf.custom(lambda uuid: is_ya_show(uuid), "UUID"))
    tv_online_stat_for_next_seria = job.table(args.input_stat_table) \
                                       .map(get_uid_serial_info) \
                                       .filter(nf.custom(lambda uuid: uuid in vh_serial_uuids, "UUID"))
    job.concat(tv_online_stats_for_show, tv_online_stat_for_next_seria) \
       .sort("uid") \
       .put(tv_online_stat_table)
    job.run()
    prepare_uids_to_push(cluster, tv_online_stat_table, tv_online_stat_table, ["UUID", "tvt"])
    if args.prepare_bell:
        prepare_uids_to_bell(cluster, tv_online_stat_table, tv_online_stat_table, ["UUID", "tvt", "install_id", "in_sup_base"])

    ya_show_info_table = args.output_dir + "/show_info"
    write_show_info(cluster, args.date, ya_show_info_table)
    job = cluster.job()
    classic_serial_info = job.table(ACTUAL_URLS) \
                             .filter(sf.defined("Resources"),
                                     nf.custom(lambda Resources: "tvseries_serial_coid" in Resources and "duration" in Resources, "Resources")) \
                             .project("UUID",
                                     duration=ne.custom(lambda Resources: int(Resources["duration"]), "Resources"),
                                     serial_id=ne.custom(lambda Resources: Resources["tvseries_serial_coid"], "Resources"),
                                     season=ne.custom(lambda Resources: int(Resources["tvseries_season"]), "Resources"),
                                     episode=ne.custom(lambda Resources: int(Resources["tvseries_episode"]), "Resources"),
                                     serial_name_with_braces=ne.custom(lambda Resources: "«" + Resources["parent_name"] + "»", "Resources"),
                                     restriction_age=ne.custom(lambda Resources: Resources["restriction_age"] if "restriction_age" in Resources else None)) \
                             .groupby("serial_id") \
                             .reduce(get_next_seria_info)
    ya_show_serial_info = job.table(ya_show_info_table)
    serial_info = job.concat(classic_serial_info, ya_show_serial_info)

    nonviewed = job.table(tv_online_stat_table) \
       .join(serial_info, type="left", by="UUID") \
       .filter(sf.defined("duration"),
                nf.custom(is_deep_view, "tvt", "duration"),
                sf.defined("NextUUID"), files=nfi_common) \
       .join(job.table(VIEWED_CONTENT_TABLE), by_left=['uid', 'NextUUID'], by_right=['uid', 'uuid'], type='left_only')

    nonviewed.filter(sf.defined('install_id'),
                     sf.defined('in_sup_base'),
                     sf.equals('in_sup_base', True)) \
       .groupby("serial_id", "serial_name_with_braces", "install_id", "RestrictionAgeNext") \
       .aggregate(episode=na.last("NextEpisode", by=("NextSeason", "NextEpisode")),
                  season=na.last("NextSeason", by=("NextSeason", "NextEpisode")),
                  UUID=na.last("NextUUID", by=("NextSeason", "NextEpisode")),
                  NewEpisodeUUID=na.any('NewEpisodeUUID')) \
       .put(tv_online_uids_ready_table)

    if args.prepare_bell:
        nonviewed.filter(sf.defined("puid")) \
           .groupby("serial_id", "serial_name_with_braces", "puid", "RestrictionAgeNext") \
           .aggregate(episode=na.last("NextEpisode", by=("NextSeason", "NextEpisode")),
                      season=na.last("NextSeason", by=("NextSeason", "NextEpisode")),
                      UUID=na.last("NextUUID", by=("NextSeason", "NextEpisode")),
                      NewEpisodeUUID=na.any('NewEpisodeUUID')) \
           .put(tv_online_puids_ready_table)

    job.run()

    job = cluster.job()
    job.table(tv_online_uids_ready_table) \
       .join(job.table(args.sended_pushes_table), type="left", by="install_id") \
       .groupby("install_id") \
       .reduce(make_data_for_next_seria_push(args.from_block,
                                             args.testing_mode,
                                             args.min_push_timedelta,
                                             args.schedule,
                                             args.ttl), files=nfi_common) \
       .put(args.output_dir + "/for_push")

    if args.prepare_bell:
        job.table(tv_online_puids_ready_table) \
           .join(job.table(args.sended_bells_table), type='left', by='puid') \
           .groupby("puid") \
           .reduce(make_data_for_next_seria_bell(args.min_push_timedelta, args.testing_mode, args.from_block), files=nfi_common) \
           .sort("puid") \
           .put(args.output_dir + "/for_bell")

    job.run()

    regions_add = " AND geo_5 IN (" + ",".join(regions) + ")"

    min_push_audience = 300
    big_push_uids_directory = "//tmp/next_seria_push_{}/".format(int(time()))

    prepare_data_to_push(cluster, desktop_push_templates, mobile_push_templates,
                         args.output_dir + "/for_push", args.output_dir + "/for_push_prepared",
                         big_push_uids_directory, min_push_audience, regions_add)

    if not args.testing_mode:
        job = cluster.job()
        job.concat(job.table(args.sended_pushes_table), job.table(args.output_dir + "/for_push")) \
           .groupby('install_id') \
           .reduce(aggregate_sended_pushes) \
           .sort('install_id') \
           .put(args.sended_pushes_table)

        if args.prepare_bell:
            job.concat(job.table(args.sended_bells_table), job.table(args.output_dir + "/for_bell")) \
               .groupby('puid') \
               .reduce(aggregate_sended_bells) \
               .sort('puid') \
               .put(args.sended_bells_table)

    job.run()

if __name__ == "__main__":
    main()
