#-*- coding: UTF-8 -*-
from common import *

import urllib2
from time import time
from random import randint

MAX_WATCHING_SERIAL_LAST_SERIES_TIMEDELTA = 7 * 24 * 60 * 60

MIN_RETURN_PUSH_TIMEDELTA = 7 * 24 * 60 * 60

FILM_PERSONAL_NOTIFY_TYPE = 'film'
SERIAL_PERSONAL_NOTIFY_TYPE = 'serial'
NEXT_SERIA_PERSONAL_NOTIFY_TYPE = 'next-seria'
CHANNEL_PERSONAL_NOTIFY_TYPE = 'channel'

INDEX_MAPPER = ["_first", "_second", "_third", "_fourth", "_fifth", "_sixth", "_seventh", "_eighth", "_ninth", "_tenth"]

ALLOWED_CHANNEL_IDS_TEXTS = {
    "100000" : u"Развлекательные фильмы для всех возрастов на канале «Семейные комедии»",
    "100001" : u"Смотрите отечественные и зарубежные мультфильмы для детей на отдельном канале",
    "100002" : u"Смотрите подборку отечественных сериалов всех жанров",
    "100003" : u"Смотрите романтические и тёплые фильмы о любви",
    "100004" : u"Смотрите любимые советские фильмы для всей семьи",
    "100014" : u"Маша и Медведь: все серии популярного мультика на отдельном канале",
    "100017" : u"Смотрите развлекательные фильмы и отдыхайте вместе с Яндекс.Эфиром",
    "100018" : u"Смотрите волшебные фильмы на канале «Фантастика»",
    "100019" : u"Кино для любителей пощекотать нервы на канале «Фильмы ужасов»",
    "100020" : u"Канал драматических фильмов для тех, кто любит сопереживать",
    "100022" : u"Смотрите зрелищные и захватывающие дух фильмы в жанре боевик",
    "1539866172" : u"Подборка кулинарных передач и телешоу на канале «Еда»",
    "1588854330" : u"Стендап и юмор от блогеров в Эфире",
}


def make_data_for_next_episode_bell(puid, stream_id, from_block, series, episode, season, thumb, type_suffix):
    url = "https://yandex.ru/efir?stream_id={0}&from_block={1}_bell".format(stream_id, from_block)

    meta = {
        "series": {
            "type": "text",
            "text": series
        },
        "episode": {
            "type": "text",
            "text": str(episode)
        },
        "season": {
            "type": "text",
            "text": str(season)
        },
        "action": {
            "type": "link",
            "link": url
        }
    }

    if thumb:
        meta["entity"] = {
                "type": "resource",
                "preview": thumb
        }

    return "&service=ether&actor=ya_ether&uid={0}&type={1}&meta={2}&group_key={3}".format(
        puid,
        "next-episode" + type_suffix,
        urllib2.quote(json.dumps(meta)),
        stream_id
    )

def make_data_for_film_recommendation_bell(puid, stream_id, from_block, film, thumb, type_suffix):
    url = "https://yandex.ru/efir?stream_id={0}&from_block={1}_bell".format(stream_id, from_block)

    meta = {
        "film": {
            "type": "text",
            "text": film
        },
        "action": {
            "type": "link",
            "link": url
        }
    }

    if thumb:
        meta["entity"] = {
                "type": "resource",
                "preview": thumb
        }

    return "&service=ether&actor=ya_ether&uid={0}&type={1}&meta={2}&group_key={3}".format(
        puid,
        "recommendation" + type_suffix,
        urllib2.quote(json.dumps(meta)),
        stream_id
    )

def make_data_for_common_recommendation_bell(puid, text, from_block, url, thumb, type_suffix):
    meta = {
        "text": {
            "type": "string",
            "text": text
        },
        "action": {
            "type": "link",
            "link": url + '&from_block={}_bell'.format(from_block)
        }
    }

    if thumb:
        meta["entity"] = {
                "type": "resource",
                "preview": thumb
        }

    return "&service=ether&actor=ya_ether&uid={0}&type={1}&meta={2}&group_key={3}".format(
        puid,
        "custom" + type_suffix,
        urllib2.quote(json.dumps(meta)),
        from_block
    )

class get_data_for_bell_recommendation(object):
    def __init__(self, personal_bell_types, from_block_suffix, type_suffix, common_texts, common_urls, common_thumbnails, vh_ott_uuids):
        self.personal_bell_types = personal_bell_types
        self.from_block_suffix = from_block_suffix
        self.type_suffix = type_suffix
        self.common_texts = common_texts
        self.common_urls = common_urls
        self.common_thumbnails = common_thumbnails
        self.vh_ott_uuids = vh_ott_uuids

    def find_possible_bell(self, recoms_list, recom_type, make_data_for_bell, content_ids, puid):
        for recom in recoms_list:
            current_ts = int(time())
            recom_info = recom["info"]
            if recom_type == 'recommend_film' and recom_info.get("info"):
                recom_info = recom_info["info"]

            if recom_info["uuid"] in content_ids:
                continue
            if recom_type == 'next_seria' and (recom_info['reason'] != NEXT_SERIA_PERSONAL_NOTIFY_TYPE or recom_info["timestamp"] + MAX_WATCHING_SERIAL_LAST_SERIES_TIMEDELTA <= current_ts):
                continue
            if recom_info["uuid"] not in self.vh_ott_uuids:
                continue

            args_for_make_data_for_bell = [puid,
                                           recom_info["uuid"],
                                           "tv_online_not_returned_" + recom_type + self.from_block_suffix]
            if recom_type == "next_seria":
                args_for_make_data_for_bell.extend([recom_info["serial_name"],
                                                    recom_info["episode"],
                                                    recom_info["season"],
                                                    recom_info["thumb"]])
            elif recom_type == "recommend_film":
                args_for_make_data_for_bell.extend([recom_info["title"],
                                                    recom_info["thumb"]])
            elif recom_type == "recommend_serial":
                args_for_make_data_for_bell.extend([recom_info["serial_name"],
                                                    recom_info["thumb"]])
            else:
                raise Exception("Unknown Recommendation Type")

            args_for_make_data_for_bell.append(self.type_suffix)

            return (True, Record(puid=puid,
                                 content_ids=[recom_info["uuid"]],
                                 from_block="tv_online_not_returned_" + recom_type,
                                 timestamps=[current_ts],
                                 data=make_data_for_bell(*args_for_make_data_for_bell)))
        return (False, None)

    def __call__(self, recs):
        for rec in recs:
            current_ts = time()
            can_send = True
            for ts in rec.get("timestamps", []):
                if ts + MIN_RETURN_PUSH_TIMEDELTA > current_ts:
                    can_send = False
                    break
            if not can_send:
                continue
            recoms = {}
            if rec.get("recommendations"):
                recoms = json.loads(rec["recommendations"])
            has_personal_recommendation = False

            #try to find next_seria bell
            if NEXT_SERIA_PERSONAL_NOTIFY_TYPE in self.personal_bell_types:
                has_personal_recommendation, record = self.find_possible_bell(recoms.get("series", []),
                                                                              "next_seria",
                                                                              make_data_for_next_episode_bell,
                                                                              rec.get("content_ids", []),
                                                                              rec["puid"])
            if has_personal_recommendation:
                yield record
                continue

            #try to find recommend_film bell
            if FILM_PERSONAL_NOTIFY_TYPE in self.personal_bell_types:
                has_personal_recommendation, record = self.find_possible_bell(recoms.get("films", []),
                                                                              "recommend_film",
                                                                              make_data_for_film_recommendation_bell,
                                                                              rec.get("content_ids", []),
                                                                              rec["puid"])
            if has_personal_recommendation:
                yield record
                continue

            #try to find recommend_serial bell
            if SERIAL_PERSONAL_NOTIFY_TYPE in self.personal_bell_types:
                has_personal_recommendation, record = self.find_possible_bell(recoms.get("series", []),
                                                                              "recommend_serial",
                                                                              make_data_for_film_recommendation_bell,
                                                                              rec.get("content_ids", []),
                                                                              rec["puid"])
            if has_personal_recommendation:
                yield record
                continue

            #try to find common bell
            if self.common_texts:
                texts = []
                urls = []
                thumbnails = []
                indexes = []
                for i in range(len(self.common_texts)):
                    if self.common_texts[i] not in rec.get("common_texts", []):
                        texts.append(self.common_texts[i])
                        urls.append(self.common_urls[i])
                        thumbnails.append(self.common_thumbnails[i])
                        indexes.append(i)
                if len(texts) == 0:
                    continue
                index = randint(0, len(texts) - 1)
                yield Record(puid=rec["puid"],
                             common_texts=[texts[index]],
                             common_sended_texts=rec.get("common_texts", []),
                             from_block="tv_online_not_returned_common_text" + INDEX_MAPPER[indexes[index]],
                             timestamps=[current_ts],
                             data=make_data_for_common_recommendation_bell(rec["puid"],
                                                                           texts[index],
                                                                           "tv_online_not_returned_common_text" + INDEX_MAPPER[indexes[index]] + self.from_block_suffix,
                                                                           urls[index],
                                                                           thumbnails[index],
                                                                           self.type_suffix))

def aggregate_sended_bells(groups):
    for key, recs in groups:
        common_texts = []
        content_ids = []
        timestamps = []
        for rec in recs:
            common_texts += rec.get("common_texts", [])
            content_ids += rec.get("content_ids", [])
            timestamps += rec.get("timestamps", [])
        yield Record(puid=key["puid"],
                     common_texts=common_texts,
                     content_ids=content_ids,
                     timestamps=timestamps)


class get_data_for_push_recommendation(object):
    def __init__(self,
                 content_id,
                 personal_push_types,
                 from_block_suffix,
                 type_suffix,
                 send_common_text_for_pp,
                 send_common_text_for_browser,
                 common_titles,
                 common_bodies,
                 common_urls,
                 common_thumbnails,
                 common_tables_prefix,
                 desktop_push_template,
                 mobile_push_template,
                 pp_push_template,
                 schedule,
                 ttl,
                 regions,
                 vh_ott_uuids):
        self.content_id = content_id
        self.personal_push_types = personal_push_types
        self.from_block_suffix = from_block_suffix
        self.type_suffix = type_suffix
        self.send_common_text_for_pp = send_common_text_for_pp
        self.send_common_text_for_browser = send_common_text_for_browser
        self.common_titles = common_titles
        self.common_bodies = common_bodies
        self.common_urls = common_urls
        self.common_thumbnails = common_thumbnails
        self.common_tables_prefix = common_tables_prefix
        self.desktop_push_template = desktop_push_template
        self.mobile_push_template = mobile_push_template
        self.pp_push_template = pp_push_template
        self.schedule = schedule
        self.ttl = ttl
        self.regions = regions
        self.vh_ott_uuids = vh_ott_uuids

    def __call__(self, recs):
        for rec in recs:
            regions_add = ""
            try:
                bro_uid = int(rec["install_id"])
                is_bro_uid = True
            except:
                if len(self.regions) > 0:
                    regions_add += " AND geo_5 IN (" + ",".join(self.regions) + ")"
                is_bro_uid = False
            if is_bro_uid:
                push_templates = [self.desktop_push_template]
            else:
                push_templates = [self.pp_push_template, self.mobile_push_template]

            can_send = True
            current_ts = time()
            for ts in rec.get("timestamps", []):
                if ts + MIN_RETURN_PUSH_TIMEDELTA > current_ts:
                    can_send = False
            if not can_send:
                continue
            recoms = {}
            if rec.get("recommendations"):
                recoms = json.loads(rec["recommendations"])
            rand = random()
            has_personal_recommendation = False

            for push_template in push_templates:
                has_personal_recommendation = False
                #try to find next_seria push
                if NEXT_SERIA_PERSONAL_NOTIFY_TYPE in self.personal_push_types:
                    has_personal_recommendation, record = self.find_possible_push(recoms.get("series", []),
                                                                                 'next_seria',
                                                                                  self.make_data_for_recommend_next_seria_push,
                                                                                  rec.get("content_ids", []),
                                                                                  rec["install_id"],
                                                                                  push_template,
                                                                                  regions_add)
                if has_personal_recommendation:
                    yield record
                    continue

                #try to find recommed_film push
                if FILM_PERSONAL_NOTIFY_TYPE in self.personal_push_types:
                    films = recoms.get("films", [])
                    suffix = ""
                    if len(recoms.get("oo_films", [])) > 0:
                        if rand < 0.5:
                            films = recoms["oo_films"]
                            suffix = "_oo_recommendations"
                            if films[0]["info"]["user_total_actions"] >= 5:
                                suffix = "_oo_recommendations_hot"
                        else:
                            suffix = "_oo_associations"
                    has_personal_recommendation, record = self.find_possible_push(films,
                                                                                 'recommend_film',
                                                                                  self.make_data_for_recommend_film_push,
                                                                                  rec.get("content_ids", []),
                                                                                  rec["install_id"],
                                                                                  push_template,
                                                                                  regions_add)
                if has_personal_recommendation:
                    yield record
                    continue

                #try to find recommend_serial push
                if SERIAL_PERSONAL_NOTIFY_TYPE in self.personal_push_types:
                    has_personal_recommendation, record = self.find_possible_push(recoms.get('series', []),
                                                                                 'recommend_serial',
                                                                                  self.make_data_for_recommend_film_push,
                                                                                  rec.get("content_ids", []),
                                                                                  rec["install_id"],
                                                                                  push_template,
                                                                                  regions_add)
                if has_personal_recommendation:
                    yield record
                    continue

                #try to find recommend_channel push
                if CHANNEL_PERSONAL_NOTIFY_TYPE in self.personal_push_types:
                    has_personal_recommendation, record = self.find_possible_push(recoms.get('channels', []),
                                                                                  'recommend_channel',
                                                                                  self.make_data_for_recommend_channel_push,
                                                                                  rec.get("content_ids", []),
                                                                                  rec["install_id"],
                                                                                  push_template,
                                                                                  regions_add)
                if has_personal_recommendation:
                    yield record
                    continue

            if has_personal_recommendation:
                continue
            #try to find common_push
            if self.common_titles and ((is_bro_uid and self.send_common_text_for_browser) or (not is_bro_uid and self.send_common_text_for_pp)):
                titles = []
                bodies = []
                urls = []
                thumbnails = []
                indexes = []
                for i in range(len(self.common_titles)):
                    if self.common_titles[i] + " " + self.common_bodies[i] not in rec.get("common_texts", []):
                        titles.append(self.common_titles[i])
                        bodies.append(self.common_bodies[i])
                        urls.append(self.common_urls[i])
                        thumbnails.append(self.common_thumbnails[i])
                        indexes.append(i)
                if len(titles) == 0:
                    continue
                index = randint(0, len(titles) - 1)
                push_type_base = "tv_online_not_returned_common_text" + INDEX_MAPPER[indexes[index]]

                push_data = self.make_data_for_common_recommend_push(
                    self.common_tables_prefix + "_" + str(indexes[index]),
                    urls[index],
                    push_type_base + self.from_block_suffix,
                    push_type_base + self.type_suffix,
                    titles[index],
                    bodies[index],
                    thumbnails[index],
                    self.desktop_push_template
                )
                deep_update(push_data, MOBILE_SILENT_SETTINGS)

                yield Record(install_id=rec["install_id"],
                             common_texts=[titles[index] + " " + bodies[index]],
                             common_sended_texts=rec.get("common_texts", []),
                             from_block="tv_online_not_returned_common_text" + INDEX_MAPPER[indexes[index]],
                             timestamps=[current_ts],
                             commmon_push_index=indexes[index],
                             push=json.dumps(push_data, ensure_ascii=False))


    def find_possible_push(self, recoms_list, recom_type, make_data_for_push, content_ids, install_id, push_template, regions_add):
        for recom in recoms_list:
            current_ts = int(time())
            recom_info = recom["info"]
            if recom_type == 'recommend_film' and recom_info.get("info"):
                recom_info = recom_info["info"]

            if recom_info["uuid"] in content_ids:
                continue
            if recom_type == 'next_seria' and (recom_info['reason'] != NEXT_SERIA_PERSONAL_NOTIFY_TYPE or recom_info["timestamp"] + MAX_WATCHING_SERIAL_LAST_SERIES_TIMEDELTA <= current_ts):
                continue
            if recom_type != 'recommend_channel' and recom_info["uuid"] not in self.vh_ott_uuids:
                continue

            unique_args_for_make_push = []
            if recom_type == 'next_seria':
                unique_args_for_make_push = [recom_info["serial_name"],
                                             recom_info["episode"],
                                             recom_info["season"],
                                             recom_info["thumb"]]
            elif recom_type == 'recommend_film':
                unique_args_for_make_push = [recom_info["title"],
                                             recom_info["thumb"],
                                             recom_info.get("watched_objects", []),
                                             int(recom_info.get("personal_score", 0))]
            elif recom_type == 'recommend_serial':
                unique_args_for_make_push = [recom_info["serial_name"],
                                             recom_info["thumb"],
                                             recom_info.get("watched_objects", []),
                                             0]
            elif recom_type == 'recommend_channel':
                channel_id = str(recom_info["channel_id"])
                if channel_id not in ALLOWED_CHANNEL_IDS_TEXTS:
                    continue
                unique_args_for_make_push = [ALLOWED_CHANNEL_IDS_TEXTS[channel_id]]
            else:
                raise Exception("Unknown Recommendation Type")

            args_for_make_push = [install_id,
                                  recom_info["uuid"],
                                  "tv_online_not_returned_" + recom_type + self.from_block_suffix,
                                  "tv_online_not_returned_" + recom_type + self.type_suffix]
            args_for_make_push.extend(unique_args_for_make_push)
            args_for_make_push.extend([push_template,
                                       regions_add])

            push_data = make_data_for_push(*args_for_make_push)
            deep_update(push_data, MOBILE_SILENT_SETTINGS)
            return (True, Record(install_id=install_id,
                                 content_ids=[recom_info["uuid"]],
                                 from_block="tv_online_not_returned_" + recom_type,
                                 timestamps=[current_ts],
                                 push=json.dumps(push_data, ensure_ascii=False)))
        return (False, None)

    def make_data_for_recommend_next_seria_push(self, install_id, stream_id, from_block, push_type, recommend, episode, season, icon, push_template, regions_add):

        push = deepcopy(push_template)
        push["receiver"] = [push["receiver"].format("tag:uuid==\'{}\' AND ".format(install_id)) + regions_add]
        push["ttl"] = self.ttl

        push["notification"]["title"] = u"Яндекс.Эфир"
        push["notification"]["body"] = u'«{}» - cмотрите следующую серию.'.format(recommend)

        push["data"]["push_id"] = push_type
        push["data"]["push_uri"] = push["data"]["push_uri"].format("yandex", stream_id, from_block)
        push["data"]["content_id"] = self.content_id
        push["schedule"] = self.schedule
        return push

    def make_data_for_recommend_film_push(self, install_id, stream_id, from_block, push_type, recommend, icon, watched_objects, personal_score, push_template, regions_add):

        push = deepcopy(push_template)
        push["receiver"] = [push["receiver"].format("tag:uuid==\'{}\' AND ".format(install_id)) + regions_add]
        push["ttl"] = self.ttl
        if "film" in from_block:
            suffix = u"фильм"
        else:
            suffix = u"сериал"

        push["notification"]["title"] = u"Яндекс.Эфир"
        push["notification"]["body"] = u"Рекомендуем {} «{}»".format(suffix, recommend)
        if personal_score >= 80:
            push["notification"]["body"] += u". Подходит вам с вероятностью {}%".format(personal_score)

        push["data"]["push_id"] = push_type
        push["data"]["push_uri"] = push["data"]["push_uri"].format("yandex", stream_id, from_block)
        push["data"]["content_id"] = self.content_id
        push["schedule"] = self.schedule
        return push

    def make_data_for_recommend_channel_push(self, install_id, stream_id, from_block, push_type, text, push_template, regions_add):

        push = deepcopy(push_template)
        push["receiver"] = [push["receiver"].format("tag:uuid==\'{}\' AND ".format(install_id)) + regions_add]
        push["ttl"] = self.ttl

        push["notification"]["title"] = u"Яндекс.Эфир"
        push["notification"]["body"] = text

        push["data"]["push_id"] = push_type
        push["data"]["push_uri"] = push["data"]["push_uri"].format("yandex", stream_id, from_block)
        push["data"]["content_id"] = self.content_id
        push["schedule"] = self.schedule
        return push

    def make_data_for_common_recommend_push(self, table, url, from_block, push_type, title, body, thumbnail, desktop_browser_template):
        push = deepcopy(desktop_browser_template)
        push["receiver"] = [push["receiver"].format("yt:{}?".format(table))]
        push["ttl"] = self.ttl
        push["notification"]["title"] = title
        push["notification"]["body"] = body
        push["data"]["push_id"] = push_type
        push["data"]["push_uri"] = url + "&from_block={}".format(from_block)
        push["data"]["content_id"] = self.content_id
        push["schedule"] = self.schedule
        if thumbnail:
            push.update({
                "android_features": {"image": thumbnail},
                "browser_features": {"image": thumbnail},
            })
        return push

def aggregate_sended_pushes(groups):
    for key, recs in groups:
        common_texts = []
        content_ids = []
        timestamps = []
        for rec in recs:
            common_texts += rec.get("common_texts", [])
            content_ids += rec.get("content_ids", [])
            timestamps += rec.get("timestamps", [])
        yield Record(install_id=key["install_id"],
                     common_texts=common_texts,
                     content_ids=content_ids,
                     timestamps=timestamps)


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--desktop_push_template', type=str, required=True)
    parser.add_argument('--mobile_push_template', type=str, required=True)
    parser.add_argument('--pp_push_template', type=str, required=True)
    parser.add_argument('--regions', type=str, required=True)
    parser.add_argument('--input_table_push', type=str, required=True)
    parser.add_argument('--input_table_bell', type=str, required=False)
    parser.add_argument('--sended_pushes_table', type=str, required=True)
    parser.add_argument('--sended_bells_table', type=str, required=True)
    parser.add_argument('--content_id', type=str, required=True)
    parser.add_argument('--personal_push_types', nargs='+', default=[])
    parser.add_argument('--personal_bell_types', nargs='+', default=[])
    parser.add_argument('--common_push_channels_config', type=str, required=True)
    parser.add_argument('--common_bell_channels_config', type=str, required=True)
    parser.add_argument('--send_common_text_for_pp', type=int, required=True)
    parser.add_argument('--send_common_text_for_browser', type=int, required=True)
    parser.add_argument('--output_table_for_push', type=str, required=True)
    parser.add_argument('--output_table_for_bell', type=str, required=False)
    parser.add_argument('--schedule', type=str, required=True)
    parser.add_argument('--ttl', type=int, required=True)
    parser.add_argument('--push_from_block_suffix', type=str, default="")
    parser.add_argument('--push_type_suffix', type=str, default="")
    parser.add_argument('--bell_from_block_suffix', type=str, default="")
    parser.add_argument('--bell_type_suffix', type=str, default="")
    parser.add_argument('--testing_mode', default=False, action="store_true")
    parser.add_argument('--prepare_bell', default=False, action="store_true")
    args = parser.parse_args()

    common_push_titles = []
    common_push_bodies = []
    common_push_urls = []
    common_push_thumbnails = []

    with codecs.open(args.common_push_channels_config, "r", "utf8") as inp:
        common_push_channels_content = json.load(inp)

    for channel_content in common_push_channels_content:
        common_push_titles.append(channel_content["title"])
        common_push_bodies.append(channel_content["body"])
        common_push_urls.append(channel_content["url"])
        common_push_thumbnails.append(channel_content["thumbnail"])

    common_bell_texts = []
    common_bell_urls = []
    common_bell_thumbnails = []

    with codecs.open(args.common_bell_channels_config, "r", "utf8") as inp:
        common_bell_channels_content = json.load(inp)

    for channel_content in common_bell_channels_content:
        common_bell_texts.append(channel_content["text"])
        common_bell_urls.append(channel_content["url"])
        common_bell_thumbnails.append(channel_content["thumbnail"])

    with codecs.open(args.desktop_push_template, 'r', 'utf8') as inp:
        desktop_push_template = json.load(inp)

    with codecs.open(args.mobile_push_template, 'r', 'utf8') as inp:
        mobile_push_template = json.load(inp)

    with codecs.open(args.pp_push_template, 'r', 'utf8') as inp:
        pp_push_template = json.load(inp)

    regions = [line.rstrip() for line in open(args.regions)]
    print "Regions : ", regions

    cluster = clusters.yt.Hahn().env(parallel_operations_limit=10)

    vh_ott_uuids = set()
    for rec in cluster.driver.read(VH_OTT_INFO):
        vh_ott_uuids.add(rec["uuid"])

    common_tables_prefix = args.output_table_for_push + "_common_push"

    job = cluster.job()
    data_for_recom = job.table(args.input_table_push) \
                        .filter(sf.defined('in_sup_base'),
                                sf.equals('in_sup_base', True)) \
                        .join(job.table(args.sended_pushes_table), type='left', by='install_id') \
                        .map(get_data_for_push_recommendation(args.content_id,
                                                              args.personal_push_types,
                                                              args.push_from_block_suffix,
                                                              args.push_type_suffix,
                                                              args.send_common_text_for_pp,
                                                              args.send_common_text_for_browser,
                                                              common_push_titles,
                                                              common_push_bodies,
                                                              common_push_urls,
                                                              common_push_thumbnails,
                                                              common_tables_prefix,
                                                              desktop_push_template,
                                                              mobile_push_template,
                                                              pp_push_template,
                                                              args.schedule, args.ttl,
                                                              regions,
                                                              vh_ott_uuids),
                             files=nfi_common) \
                        .sort('install_id') \
                        .put(args.output_table_for_push)
    job.run()

    if not args.testing_mode:
        job = cluster.job()
        job.concat(job.table(args.sended_pushes_table), job.table(args.output_table_for_push)) \
        .groupby('install_id') \
        .reduce(aggregate_sended_pushes) \
        .sort('install_id') \
        .put(args.sended_pushes_table)
        job.run()

    job = cluster.job()

    personal_pushes = job.table(args.output_table_for_push) \
                             .filter(sf.not_(sf.defined('commmon_push_index'))) \
                             .project('push')

    common_pushes = []
    for i in range(len(common_push_titles)):
        uids_with_common_push = job.table(args.output_table_for_push).filter(sf.equals('commmon_push_index', i))
        common_push = uids_with_common_push.groupby('push').aggregate(count=na.count())
        common_pushes.append(common_push)
        uids_with_common_push.project('install_id').sort('install_id').put(common_tables_prefix + "_" + str(i))

    job.concat(job.concat(*common_pushes), personal_pushes) \
       .put(args.output_table_for_push)

    job.run()

    if args.prepare_bell:
        job = cluster.job()
        data_for_recom = job.table(args.input_table_bell) \
                            .filter(sf.custom(lambda x, y : x and y, 'need_push', 'puid')) \
                            .join(job.table(args.sended_bells_table), type='left', by='puid') \
                            .map(get_data_for_bell_recommendation(args.personal_bell_types,
                                                                  args.bell_from_block_suffix,
                                                                  args.bell_type_suffix,
                                                                  common_bell_texts,
                                                                  common_bell_urls,
                                                                  common_bell_thumbnails,
                                                                  vh_ott_uuids)) \
                            .put(args.output_table_for_bell)
        job.run()

        if not args.testing_mode:
            job = cluster.job()
            job.concat(job.table(args.sended_bells_table), job.table(args.output_table_for_bell)) \
            .groupby('puid') \
            .reduce(aggregate_sended_bells) \
            .sort('puid') \
            .put(args.sended_bells_table)
            job.run()


if __name__ == '__main__':
    main()

