#-*- coding: UTF-8 -*-
from common import *

MIN_WATCHING_SERIAL_WATCHED_SERIES_COUNT = 1
MAX_WATCHING_SERIAL_LAST_WATCH_TIMEDELTA = 7 * 24 * 60 * 60

CHANNEL_IDS_BLACK_LIST = ['1539775176']

CHANNEL_ID_BY_GENRE = {"comedy" : "100000",
                       "drama" : "100020",
                       "melodrama" : "100020",
                       "Action Film" : "100022",
                       "thriller" : "100021",
                       "fantastique" : "100018",
                       "fantasy" : "100018",
                       "horror" : "100019",
                       "animated film" : "100001",
                       "family film" : "100001",
                       "food" : "1539866172",
                       "auto" : "1538069317"}
MIN_GENRES_COUNT = 3

MIN_CHANNEL_TVT = 10 * 60

MIN_BLOGGER_TVT = 10 * 60
MIN_BLOGGER_VIEWS = 3

class prepare_oo_recommendations_to_join(object):
    def __init__(self, object_ids_film_info):
        self.object_ids_film_info = object_ids_film_info
    def __call__(self, groups):
        for key, recs in groups:
            oo_film_recommendations = []
            for rec in recs:
                if not rec["ontoid"] in self.object_ids_film_info:
                    continue

                info = delete_keys_from_dict(self.object_ids_film_info[rec["ontoid"]]["info"], ['tvt', 'object_id'])
                info["personal_score"] = rec["personal_score"]
                info["user_total_actions"] = rec["user_total_actions"]
                info["ranking_score"] = rec["ranking_score"]

                oo_film_recommendations.append({"info" : info, "type" : "film", "from_default" : False})

            oo_film_recommendations = sorted(oo_film_recommendations, key=lambda x : -x["info"]["ranking_score"])

            puid = key["id"]
            if puid.startswith("p/"):
                puid = puid[2:]

            if len(oo_film_recommendations) > 0:
                yield Record(puid=puid,
                            oo_film_recommendations=oo_film_recommendations)

def delete_keys_from_dict(dictionary, keys):
    result = deepcopy(dictionary)
    for key in keys:
        del result[key]
    return result

def get_recommendations(recomms_stats, total_stats, reason):
    recoms = []
    for object_id in recomms_stats:
        if object_id in total_stats:
            recomms_stats[object_id]["tvt"] = total_stats[object_id]["tvt"]
        else:
            recomms_stats[object_id]["tvt"] = 0
    if reason == "associations":
        recomms_stats_sorted = sorted(recomms_stats.items(), key=lambda x : [-x[1]["count"], -x[1]["watched_objects"][0]["timestamp"]])
    else:
        recomms_stats_sorted = sorted(recomms_stats.items(), key=lambda x : [-x[1]["count"], -x[1]["tvt"]])
    for elem in recomms_stats_sorted:
        info = delete_keys_from_dict(elem[1], ['tvt', 'count'])
        info["reason"] = reason
        if "serial_name" in info:
            recom_type = "series"
        else:
            recom_type = "film"
        recoms.append({"info" : info, "type" : recom_type, "from_default" : False})
    return recoms

class get_final_recommendations(object):
    def __init__(self,
                 channel_id_to_uuid,
                 sport_channel_id_to_uuid,
                 total_films_and_serials_stats,
                 recommendations_by_type_count):
        self.channel_id_to_uuid = channel_id_to_uuid
        self.sport_channel_id_to_uuid = sport_channel_id_to_uuid
        self.total_films_and_serials_stats = total_films_and_serials_stats
        self.recommendations_by_type_count = recommendations_by_type_count

    def __call__(self, recs):
        for rec in recs:
            current_ts = int(time.time())
            recommendations_by_type_count = self.recommendations_by_type_count
            channels_recoms = []
            sport_channels_recoms = []
            next_seria_recoms = []
            film_recoms = []
            oo_film_recoms = rec.get("oo_film_recommendations", [])
            serial_recoms = []
            mixed_recoms = []

            blogger_recoms = []
            for elem in rec["bloggers"]:
                if elem["view_time"] < MIN_BLOGGER_TVT or len(elem['watched_episodes']) < MIN_BLOGGER_VIEWS:
                    continue
                blogger_info = delete_keys_from_dict(elem, ['watched_episodes'])
                blogger_recoms.append({"info" : blogger_info, "type" : "blogger", "from_default" : False})
            blogger_recoms = blogger_recoms[:recommendations_by_type_count]

            film_recoms = deepcopy(oo_film_recoms)
            film_recoms += get_recommendations(rec["film_recoms"], self.total_films_and_serials_stats, "associations")
            film_recoms += get_recommendations(rec["vitrine_film_recoms"], self.total_films_and_serials_stats, "vitrine")
            film_recoms = film_recoms[:recommendations_by_type_count]

            for object_id in rec["next_seria_recoms"]:
                if rec["next_seria_recoms"][object_id]["series_watched"] < MIN_WATCHING_SERIAL_WATCHED_SERIES_COUNT:
                    continue
                if rec["next_seria_recoms"][object_id]["timestamp"] + MAX_WATCHING_SERIAL_LAST_WATCH_TIMEDELTA < current_ts:
                    continue
                serial_info = delete_keys_from_dict(rec["next_seria_recoms"][object_id], ['series_watched'])
                serial_info["reason"] = "next-seria"
                to_append = {"info" : serial_info, "type" : "series", "from_default" : False}
                next_seria_recoms.append(deepcopy(to_append))
                mixed_recoms.append(deepcopy(to_append))

            channels_stat = {}
            for channel_id in rec["channels_stat"]:
                tvt = sum([elem[1] for elem in rec["channels_stat"][channel_id].items()])
                if tvt < MIN_CHANNEL_TVT:
                    continue
                if not channel_id in self.channel_id_to_uuid:
                    continue
                stat = sum([float(elem[1]) / (current_ts - float(elem[0])) for elem in rec["channels_stat"][channel_id].items()])
                channels_stat[channel_id] = stat

            channels_stat = sorted(channels_stat.items(), key=lambda x : -x[1])
            channel_ids = set()
            for i, elem in enumerate(channels_stat):
                channel_id = elem[0]
                if channel_id in CHANNEL_IDS_BLACK_LIST:
                    continue
                channel_ids.add(channel_id)
                channel_info = {"info" : {"channel_id" : channel_id, "uuid" : self.channel_id_to_uuid[channel_id], "reason" : "channel_views"}, "type" : "channel", "from_default" : False}
                channels_recoms.append(channel_info)
                if channel_id in self.sport_channel_id_to_uuid:
                    sport_channels_recoms.append(channel_info)
                mixed_recoms.append(channel_info)

            serial_recoms += get_recommendations(rec["serial_recoms"], self.total_films_and_serials_stats, "associations")
            serial_recoms += get_recommendations(rec["vitrine_serial_recoms"], self.total_films_and_serials_stats, "vitrine")

            mixed_recoms += deepcopy(oo_film_recoms)
            total_assoc_recoms = deepcopy(rec["serial_recoms"])
            total_vitrine_recoms = deepcopy(rec["vitrine_serial_recoms"])
            for object_id in rec["film_recoms"]:
                total_assoc_recoms[object_id] = deepcopy(rec["film_recoms"][object_id])
            for object_id in rec["vitrine_film_recoms"]:
                total_vitrine_recoms[object_id] = deepcopy(rec["vitrine_film_recoms"][object_id])
            mixed_recoms += get_recommendations(total_assoc_recoms, self.total_films_and_serials_stats, "associations")
            mixed_recoms += get_recommendations(total_vitrine_recoms, self.total_films_and_serials_stats, "vitrine")

            serial_recoms = next_seria_recoms + serial_recoms
            serial_recoms = serial_recoms[:recommendations_by_type_count]

            genres_stat = sorted(rec["genres_stat"].items(), key=lambda x : -x[1])
            for elem in genres_stat:
                if elem[1] < MIN_GENRES_COUNT or not elem[0] in CHANNEL_ID_BY_GENRE:
                    continue
                channel_id = CHANNEL_ID_BY_GENRE[elem[0]]
                if not channel_id in self.channel_id_to_uuid or channel_id in channel_ids:
                    continue
                channel_ids.add(channel_id)
                channel_info = {"info" : {"channel_id" : channel_id, "uuid" : self.channel_id_to_uuid[channel_id], "reason" : "theme_interest"}, "type" : "channel", "from_default" : False}
                channels_recoms.append(channel_info)
                mixed_recoms.append(channel_info)

            if len(channels_recoms) > 0 or len(film_recoms) > 0 or len(serial_recoms) > 0 or len(blogger_recoms) > 0 or len(oo_film_recoms) > 0:
                recommendations = {"channels" : channels_recoms,
                                   "sport_channels" : sport_channels_recoms,
                                   "films" : film_recoms,
                                   "oo_films" : oo_film_recoms,
                                   "series" : serial_recoms,
                                   "mixed" : mixed_recoms[:recommendations_by_type_count],
                                   "bloggers" : blogger_recoms}
                yield Record(key=rec["uid"],
                             value=json.dumps(recommendations))

def make_cold_start_recommendations(channel_id_to_uuid, sport_channel_id_to_uuid,
                                    film_stats, serial_stats, channels_stats,
                                    bloggers_stat, recommendations_by_type_count):
    sorted_films_stats = [{"type" : "film", "info" : delete_keys_from_dict(elem[1]["info"], ['tvt', 'object_id']), "from_default" : True} for elem in sorted(film_stats.items(), key=lambda x : -x[1]["tvt"])]

    sorted_serials_stats = [{"type" : "series", "info" : delete_keys_from_dict(elem[1]["info"], ['tvt', 'object_id']), "from_default" : True} for elem in sorted(serial_stats.items(), key=lambda x : -x[1]["tvt"])]

    sorted_channels_stats = []
    sorted_sport_channels_stats = []
    for elem in sorted(channels_stats.items(), key=lambda x : -x[1]["tvt"]):
        if elem[1]["info"]["channel_id"] in channel_id_to_uuid:
            info = delete_keys_from_dict(elem[1]["info"], ['tvt'])
            info["uuid"] = channel_id_to_uuid[info["channel_id"]]
            sorted_channels_stats.append({"type" : "channel", "info" : info, "from_default" : True})
            if info["channel_id"] in sport_channel_id_to_uuid:
                sorted_sport_channels_stats.append({"type" : "channel", "info" : info, "from_default" : True})

    sorted_blogggers_stats = [{"type" : "blogger", "info" : delete_keys_from_dict(elem[1]["info"], ['tvt']), "from_default" : True} for elem in sorted(bloggers_stat.items(), key=lambda x : -x[1]["tvt"])]

    cold_start_recommendations = {"channels" : sorted_channels_stats[:recommendations_by_type_count],
                                  "sport_channels" : sorted_sport_channels_stats[:recommendations_by_type_count],
                                  "films" : sorted_films_stats[:recommendations_by_type_count],
                                  "oo_films" : [],
                                  "series" : sorted_serials_stats[:recommendations_by_type_count],
                                  "bloggers" : sorted_blogggers_stats[:recommendations_by_type_count],
                                  "mixed" : sorted_channels_stats[:recommendations_by_type_count]}

    return cold_start_recommendations

def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--recommendations_by_type_count', type=int, required=True)
    parser.add_argument('--total_tv_online_stats', type=str, required=True)
    parser.add_argument('--input_table', type=str, required=True)
    parser.add_argument('--output_table', type=str, required=True)
    args = parser.parse_args()

    cluster = clusters.yt.Hahn().env(parallel_operations_limit=10,
                                     yt_spec_defaults=dict(
                                         pool_trees=["physical"],
                                         tentative_pool_trees=["cloud"]
                                     ),
                                     templates=dict(
                                         tmp_root=TMP_HITMAN_TV_ONLINE_RECOMMENDATIONS,
                                         title='GetRecommendationsForUids'
                                     ))
    channel_id_to_uuid = get_channel_id_to_uuid()
    sport_channel_id_to_uuid = get_channel_id_to_uuid(['sport'])

    total_tv_online_stats = args.total_tv_online_stats

    total_films_stats = {}
    total_serials_stats = {}
    total_films_and_serials_stats = {}
    total_channels_stats = {}
    total_bloggers_stats = {}
    for rec in cluster.driver.read(total_tv_online_stats):
        if rec["content_type"] == "film":
            total_films_stats[rec["info"]["object_id"]] = {"info" : rec["info"], "tvt" : rec["tvt"]}
            total_films_and_serials_stats[rec["info"]["object_id"]] = {"info" : rec["info"], "tvt" : rec["tvt"]}
        if rec["content_type"] == "series":
            total_serials_stats[rec["info"]["object_id"]] = {"info" : rec["info"], "tvt" : rec["tvt"]}
            total_films_and_serials_stats[rec["info"]["object_id"]] = {"info" : rec["info"], "tvt" : rec["tvt"]}
        if rec["content_type"] == "channel":
            total_channels_stats[rec["info"]["channel_id"]] = {"info" : rec["info"], "tvt" : rec["tvt"]}
        if rec["content_type"] == "blogger":
            total_bloggers_stats[rec["id"]] = {"info" : rec["info"], "tvt" : rec["tvt"]}

    cold_start_recommendations = make_cold_start_recommendations(channel_id_to_uuid,
                                                                 sport_channel_id_to_uuid,
                                                                 total_films_stats,
                                                                 total_serials_stats,
                                                                 total_channels_stats,
                                                                 total_bloggers_stats,
                                                                 args.recommendations_by_type_count)

    cold_start_uid = "0"
    cold_start_records = [Record(key=cold_start_uid, value=json.dumps(cold_start_recommendations))]
    for i in range(1, 1001):
        cold_start_uid = "def" + str(i)
        cold_start_records.append(Record(key=cold_start_uid, value=json.dumps(cold_start_recommendations)))
    cluster.driver.write(args.output_table + "_cold_start", cold_start_records)

    job = cluster.job()
    job.table(ONTODB_RECOMMENDATIONS_PATH) \
       .groupby('id') \
       .reduce(prepare_oo_recommendations_to_join(total_films_stats)) \
       .join(job.table(CRYPTA_UID_PUID_TABLE), by_left='puid', by_right='target_id') \
       .project('oo_film_recommendations', uid='id') \
       .groupby('uid') \
       .aggregate(oo_film_recommendations=na.any('oo_film_recommendations')) \
       .sort('uid') \
       .put(args.input_table + '_oo_recommendations')
    job.run()

    job = cluster.job()
    final_recommendations = job.table(args.input_table) \
                               .join(job.table(args.input_table + '_oo_recommendations'), by='uid', type='left') \
                               .map(get_final_recommendations(channel_id_to_uuid,
                                                              sport_channel_id_to_uuid,
                                                              total_films_and_serials_stats,
                                                              args.recommendations_by_type_count), files=nfi_common)

    final_recommendations_for_puid = final_recommendations.join(job.table(CRYPTA_UID_PUID_TABLE), by_left='key', by_right='id') \
                                                          .project('value', key=ne.custom(lambda x : 'p' + x, 'target_id')) \
                                                          .groupby('key') \
                                                          .aggregate(value=na.any('value')) \
                                                          .put(args.output_table + "_final_puid")

    job.concat(final_recommendations, final_recommendations_for_puid, job.table(args.output_table + "_cold_start")) \
       .project('key', 'value') \
       .sort('key') \
       .put(args.output_table)
    job.run()

if __name__ == '__main__':
    main()
