import json
import sys
import requests
import time
import ticket_parser2 as tp2
from ticket_parser2.low_level import ServiceContext
import os


def obtain_tvm_ticket():
	secret = os.environ['BELL_TOKEN']
	tvm_api_url = 'tvm-api.yandex.net'
	ts = int(time.time())
	src = 2001814
	dst = 132

	# Getting TVM keys
	tvm_keys = requests.get(
	    'https://{tvm_api_url}/2/keys?lib_version={version}'.format(
	        tvm_api_url=tvm_api_url,
	        version=tp2.__version__,
	    )
	).content

	# Create context
	service_context = ServiceContext(src, secret, tvm_keys)

	# Getting tickets
	ticket_response = requests.post(
	    'https://%s/2/ticket/' % tvm_api_url,
	    data={
	        'grant_type': 'client_credentials',
	        'src': src,
	        'dst': dst,
	        'ts': ts,
	        'sign': service_context.sign(ts, dst)
	    }
	).json()

	return ticket_response[str(dst)]['ticket']


def send_notifications(filename, tvm_ticket):
	for data in open(filename, 'r'):
		data = data.strip()
		print "data =", data
		url = 'https://bell.yandex.net/v1/notifier/service/add-notification?{}'.format(data)
		headers = {
			'X-Ya-Service-Ticket': tvm_ticket
		}

		for i in range(10):
			try:
				print 'Try # ', i + 1
				response = requests.post(url=url, headers=headers, verify=False)
				response.raise_for_status()
				print response
				break
			except Exception as e:
				print 'Exception raised:', e


if __name__ == "__main__":
	tvm_ticket = obtain_tvm_ticket()
	print tvm_ticket
	send_notifications(sys.argv[1], tvm_ticket)
