# -*- coding: utf-8 -*-
from common import get_regions

import json
import sys
import argparse
import codecs
import hashlib

reload(sys)
sys.setdefaultencoding('utf8')

topic_push_list = ["efir_nhl", "stream_push"]

def is_nhl(topic_push):
    return topic_push == "efir_nhl"

def check_push_info(uids_table,
                    title,
                    body,
                    icon,
                    push_type,
                    stat_id,
                    from_block_prefix,
                    from_block,
                    stream_id,
                    custom_push_url,
                    schedule,
                    topic_push):
    errors = []

    if title == "":
        errors.append("empty push title")
    if body == "":
        errors.append("empty push body")
    if icon == "":
        errors.append("empty push icon")
    if topic_push == "":
        errors.append("empty push topic_push")
    if uids_table == "":
        errors.append("empty push uids_table")
    if from_block_prefix == "":
        errors.append("empty push from_block_prefix")

    if stream_id == "" and custom_push_url == "":
        errors.append("empty push stream_id and custom_push_url")
    if stream_id != "":
        if custom_push_url != "":
            errors.append("nonempty push stream_id and custom_push_url")
    if schedule == "":
        errors.append("empty push schedule")

    if push_type == "" and stat_id != "":
        errors.append("nonempty push stat_id with empty push_type")
    if push_type != "" and stat_id == "":
        errors.append("nonempty push_type with empty push stat_id")
    if (push_type == "" or stat_id == "") and from_block == "":
        errors.append("empty push_type or stat_id while empty push from_block")
    if (push_type != "" or stat_id != "") and from_block != "":
        errors.append("nonempty push_type or stat_id while nonempty push from_block")

    if errors:
        raise ValueError(";  ".join(errors))

def convert(push_template,
            uids_table,
            ttl,
            title,
            body,
            icon,
            nhl_icon,
            image,
            data_ttl,
            push_type,
            stat_id,
            from_block_prefix,
            from_block,
            from_block_suffix,
            stream_id,
            custom_push_url,
            schedule,
            button_no,
            button_yes,
            sportevent,
            use_regions,
            regions,
            request_schedule,
            topic_push):

    check_push_info(uids_table,
                    title,
                    body,
                    icon,
                    push_type,
                    stat_id,
                    from_block_prefix,
                    from_block,
                    stream_id,
                    custom_push_url,
                    schedule,
                    topic_push)

    if request_schedule:
        push_template["request_schedule"] = request_schedule
    push_template["schedule"] = schedule

    push_template["ttl"] = ttl
    push_template["notification"]["title"] = title
    push_template["notification"]["body"] = body

    domain = "yandex"
    if is_nhl(topic_push):
        push_template["notification"]["icon"] = nhl_icon
        domain = "yandexsport"
    else:
        push_template["notification"]["icon"] = icon

    push_template["data"]["ttl"] = data_ttl

    if push_type:
        assert stat_id, "stat_id must be nonempty if push_type is nonempty"
        from_block_pre_final = from_block_prefix + stat_id
        push_template["data"]["push_id"] = push_type
        push_template["data"]["stat_id"] = stat_id
    else:
        assert from_block, "from_block must be nonempty if push_type is empty"
        from_block_pre_final = from_block_prefix + from_block
        push_template["data"]["push_id"] = from_block_pre_final

    url_for_hash = ""
    if custom_push_url:
        url_for_hash = custom_push_url
        push_template["data"]["push_uri"] = custom_push_url
    else:
        assert stream_id, "stream_id must be nonempty if custom_push_url is empty"
        url_for_hash = push_template["data"]["push_uri"].format(domain, stream_id, from_block_pre_final)
        push_template["data"]["push_uri"] = push_template["data"]["push_uri"].format(domain, stream_id, from_block_pre_final + from_block_suffix)
    push_template["data"]["content_id"] = hashlib.md5(url_for_hash + "-" + schedule).hexdigest()

    if topic_push in topic_push_list:
        push_template["data"]["topic_push"] = topic_push
    elif topic_push != "":
        raise ValueError("invalid topic_push: {} not in {}".format(topic_push, topic_push_list))

    regions_add = ""
    if use_regions:
        regions_add = " AND geo_5 IN (" + ",".join(regions) + ")"

    sportevent_add = ""
    if sportevent:
        sportevent_add = " AND sportEvent2 != '{}'".format(sportevent)
    push_template["receiver"] = [push_template["receiver"].format("yt:{}?".format(uids_table)) + sportevent_add + regions_add]

    pp_or_mobile_push = from_block_suffix == "_pp" or from_block_suffix == "_mobile"
    if pp_or_mobile_push:
        assert button_no and button_yes, "buttons must be specified in pp/mobile pushes"
        push_template["actions"] = [{"id": "unrel", "title": button_no},
                                    {"id": "rel", "title": button_yes, "link": push_template["data"]["push_uri"]}]

    if image:
        if pp_or_mobile_push:
            push_template["android_features"]["image"] = image
        else:
            if "browser_features" not in push_template:
                push_template["browser_features"] = {}
            push_template["browser_features"]["image"] = image

    return push_template

def main():
    parser = argparse.ArgumentParser(description='.')
    parser.add_argument("--push_template", type=str, required=True)
    parser.add_argument("--request_schedule", type=str, default="")
    parser.add_argument("--uids_table", type=str, required=True)
    parser.add_argument("--ttl", type=int, required=True)
    parser.add_argument("--title", type=str, required=True)
    parser.add_argument("--body", type=str, required=True)
    parser.add_argument("--icon", type=str, required=True)
    parser.add_argument("--nhl_icon", type=str, required=True)
    parser.add_argument("--image", type=str, default="")
    parser.add_argument("--data_ttl", type=int, required=True)
    parser.add_argument("--push_type", type=str, default="")
    parser.add_argument("--stat_id", type=str, default="")
    parser.add_argument("--from_block_prefix", type=str, required=True)
    parser.add_argument("--from_block", type=str, default="")
    parser.add_argument("--from_block_suffix", type=str, default="")
    parser.add_argument("--stream_id", type=str, default="")
    parser.add_argument("--custom_push_url", type=str, default="")
    parser.add_argument("--schedule", type=str, required=True)
    parser.add_argument("--button_no", type=str, default="")
    parser.add_argument("--button_yes", type=str, default="")
    parser.add_argument("--sportevent", type=str, default="")
    parser.add_argument("--use_regions", type=int, default=False)
    parser.add_argument("--regions", type=str, default="")
    parser.add_argument("--topic_push", type=str, default="stream_push")
    parser.add_argument("--output", type=str, required=True)
    args = parser.parse_args(sys.argv[1:])

    regions = []
    if args.regions != "":
        regions = get_regions(args.regions)

    with codecs.open(args.push_template, "r", "utf8") as inp:
        push_template = json.load(inp)

    push = convert(push_template,
                   args.uids_table,
                   args.ttl,
                   args.title,
                   args.body,
                   args.icon,
                   args.nhl_icon,
                   args.image,
                   args.data_ttl,
                   args.push_type,
                   args.stat_id,
                   args.from_block_prefix,
                   args.from_block,
                   args.from_block_suffix,
                   args.stream_id,
                   args.custom_push_url,
                   args.schedule,
                   args.button_no,
                   args.button_yes,
                   args.sportevent,
                   args.use_regions,
                   regions,
                   args.request_schedule,
                   args.topic_push)

    with codecs.open(args.output, 'w', 'utf8') as out:
        json.dump(push, out, ensure_ascii=False, sort_keys=True)

if __name__ == "__main__":
    main()
