#-*- coding: UTF-8 -*-
import argparse
import codecs
from nile.api.v1 import (
    clusters,
    Record
)
from datetime import datetime
from time import sleep
import json
import requests
import urllib2

CLONE_GRAPH_TEMPLATE = "https://nirvana.yandex-team.ru/api/public/v1/cloneWorkflow?workflowId={}&newName={}&newQuotaProjectId={}"
SET_GRAPH_PARAMS = "https://nirvana.yandex-team.ru/api/public/v1/setGlobalParameters"
START_GRAPH_TEMPLATE = "https://nirvana.yandex-team.ru/api/public/v1/startWorkflow?workflowId={}"

QUOTA_ETHER_DEV = "ether-dev"

SPORT_API_URL = "https://api.sport.news.yandex.ru/v2/{}/competitions/{}"

UIDS_TABLE_DIRECTORY = "//home/ether_prod/pushes/pushes/"
TIME_FORMAT_UTC = '%Y-%m-%dT%H:%M:%S+03:00'

SECONDS_IN_DAY = 86400


def find_event(events, home_team_info, away_team_info, start_ts):
    for event in events:
        if abs(event.get("timestamp", 0) - start_ts) > SECONDS_IN_DAY:
            continue
        teams = set()
        for team in event["teams"]:
            teams.add(team.get("id", ""))
        if home_team_info["id"] in teams and away_team_info["id"] in teams:
            return event

def fetch_url(url):
    page_json = json.loads(robust_fetch(url))
    return page_json

def robust_fetch(url, retries=3):
    for ntry in range(retries):
        try:
            resp = urllib2.urlopen(url).read()
            return resp
        except Exception:
            sleep(100)
    raise Exception("Failed to open url %s" % url)

def get_team_name_for_push(team_info):
    if team_info.get("name_for_push"):
        return team_info["name_for_push"]
    return team_info["name"]

def get_sport_game_title(home_team_info, away_team_info, league_push_info, base_emoji):
    if league_push_info.get("title_prefix"):
        title = league_push_info["title_prefix"]
    else:
        title = base_emoji
    title += get_team_name_for_push(home_team_info)
    title += u' - '
    title += get_team_name_for_push(away_team_info)
    if league_push_info.get("title_suffix"):
        title += league_push_info["title_suffix"]
    else:
        title += " " + base_emoji
    return title

def get_push_time(start_time_ts, push_info, time_before_game, with_gap=True):
    ts = start_time_ts + with_gap * push_info["start_time_gap"] * 60 - time_before_game
    return datetime.fromtimestamp(ts).strftime(TIME_FORMAT_UTC)


def get_sport_league_game_push_info(rec, config, push_info):
    channel_uuid = rec["YaTvChannel.UUID"]
    episode = rec["YaTvEpisode.Name"].decode('utf8')
    title_full_computed_name = rec["title_full_computed_name"].decode('utf8')
    for sport_league_info in config["sport_leagues"]:
        if not channel_uuid in sport_league_info["push_info"]["auto_channels_uuids"]:
            continue
        if sport_league_info["push_info"].get("title_substring") and not sport_league_info["push_info"]["title_substring"] in title_full_computed_name:
            continue
        home_team_info = {}
        away_team_info = {}
        for team_info in sport_league_info["teams"]:
            if team_info["name"] in episode:
                ## TODO : better
                if episode.startswith(team_info["name"]):
                    home_team_info = team_info
                else:
                    away_team_info = team_info
        if not home_team_info or not away_team_info:
            continue
        base_emoji = config["sport_pushes_info"]["emoji_by_sport"][sport_league_info["league_type"]]
        if sport_league_info["push_info"].get("auto_send", 0):
            push_info["send"] = "yes"
        push_info["title"] = get_sport_game_title(home_team_info, away_team_info, sport_league_info["push_info"], base_emoji)
        push_info["body"] = sport_league_info["push_info"]["body"]
        push_info["uuid"] = rec["YaTvEpisode.UUID"]
        if "image" in sport_league_info["push_info"]:
            push_info["image"] = sport_league_info["push_info"]["image"]
        push_info["push_time_moscow"] = get_push_time(int(rec["start_time_ts"]), sport_league_info["push_info"], time_before_game=300)
        push_info["request_schedule"] = get_push_time(int(rec["start_time_ts"]), sport_league_info["push_info"], time_before_game=3600, with_gap=False)
        push_info["from_block"] = sport_league_info["push_info"]["from_block_prefix"] + home_team_info["name_en"] + "_" + away_team_info["name_en"]
        push_info["uids_table"] = UIDS_TABLE_DIRECTORY + push_info["push_time_moscow"][:10] + "_" + push_info["from_block"]
        push_info["sport_league"] = '\"' + sport_league_info["name"] + '\"'
        push_info["teams"] = ['\"' + get_team_name_for_push(home_team_info) + '\"',
                              '\"' + get_team_name_for_push(away_team_info) + '\"']
        push_info["regions"] = []
        for team_info in [home_team_info, away_team_info]:
            if "region" in team_info:
                push_info["regions"].append(team_info["region"])
        if "competition_id" in sport_league_info:
            events = fetch_url(SPORT_API_URL.format(sport_league_info["league_type"], sport_league_info["competition_id"]))["events"]
            event_info = find_event(events, home_team_info, away_team_info, int(rec["start_time_ts"]))
            push_info["event_id"] = event_info["id"]
        base_fetch_settings = config["sport_pushes_info"]["base_fetch_settings"]
        for param in ["teams_request_threshold",
                      "sport_league_request_threshold",
                      "tv_online_team_tvt_threshold",
                      "tv_online_league_tvt_threshold",
                      "tv_online_programs_tvt_threshold",
                      "tv_online_channels_tvt_threshold",
                      "team_website_visits",
                      "league_website_visits"]:
            if base_fetch_settings.get(param):
                push_info[param] = base_fetch_settings[param]
            if sport_league_info["push_info"].get(param):
                push_info[param] = sport_league_info["push_info"][param]
        for param in ["tv_online_programs",
                      "tv_online_channels"]:
            if base_fetch_settings.get(param):
                push_info[param] = ["\"" + elem + "\"" for elem in base_fetch_settings[param]]
            if sport_league_info["push_info"].get(param):
                push_info[param] = ["\"" + elem + "\"" for elem in sport_league_info["push_info"][param]]
        return True

def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--table', type=str, required=True)
    parser.add_argument('--base_workflow_id', type=str, required=True)
    parser.add_argument('--fnl_workflow_ids', nargs='+', default=[])
    parser.add_argument('--fnl_from_block_prefixes', nargs='+', default=[])
    parser.add_argument('--nirvana_token', type=str, required=True)
    parser.add_argument('--config', type=str, required=True)
    parser.add_argument('--quota_id', type=str, default=QUOTA_ETHER_DEV)
    args = parser.parse_args()

    headers = {'Content-Type': 'application/json',
               'Authorization': 'OAuth {}'.format(args.nirvana_token)}

    with codecs.open(args.config, 'r', 'utf8') as inp:
        config = json.load(inp)

    cluster = clusters.yt.Arnold()

    for index, rec in enumerate(cluster.driver.read(args.table)):
        if index > 0:
            sleep(1 * 60)

        if "deleted" in rec["YaTvEpisode.Options"]:
            continue
        if "ya-main" not in json.loads(rec["YaTvEpisode.TMP_OvsServiceFlags"]):
            continue

        push_info = {}
        is_push_info = get_sport_league_game_push_info(rec, config, push_info)
        if not is_push_info:
            continue

        ## Clone graph
        regions = push_info.pop("regions")
        print push_info["push_time_moscow"][:10], push_info["title"].encode('utf8')
        r = requests.get(
            CLONE_GRAPH_TEMPLATE.format(
                args.base_workflow_id,
                (push_info["push_time_moscow"][:10] + " " + push_info["title"]).encode('utf8'),
                args.quota_id,
            ),
            headers=headers,
            verify=False
        )
        print r.json(), r.status_code
        graph_id = r.json()['result']
        print "New workflow: ", "https://nirvana.yandex-team.ru/flow/{}".format(graph_id)

        ## Set params
        params = [{'parameter': elem, 'value': push_info[elem]} for elem in push_info]
        r = requests.post(
            SET_GRAPH_PARAMS,
            data=json.dumps({
                'jsonrpc': "2.0",
                'id': 'id',
                'method': 'setGlobalParameters',
                'params': {'workflowId': graph_id,
                           'params': params}
            }),
            verify=False,
            headers=headers,
        )

        ## Run
        requests.get(START_GRAPH_TEMPLATE.format(graph_id), headers=headers, verify=False)

        if len(regions) != 0 and  push_info["sport_league"] == u"\"ФНЛ\"":
            push_info["regions"] = regions
            from_block = push_info["from_block"]
            for i in range(len(args.fnl_workflow_ids)):
                workflow_id = args.fnl_workflow_ids[i]

                prefix = args.fnl_from_block_prefixes[i]
                r = requests.get(
                    CLONE_GRAPH_TEMPLATE.format(
                        workflow_id,
                        (push_info["push_time_moscow"][:10] + " " + push_info["title"] + prefix[1:]).encode('utf8'),
                        args.quota_id,
                    ),
                    headers=headers,
                    verify=False)
                print r.json(), r.status_code
                graph_id = r.json()['result']
                print "New workflow: ", "https://nirvana.yandex-team.ru/flow/{}".format(graph_id)

                ## Set params
                push_info["from_block"] = from_block + prefix
                push_info["uids_table"] = UIDS_TABLE_DIRECTORY + push_info["push_time_moscow"][:10] + "_" + push_info["from_block"]
                params = [{'parameter': elem, 'value': push_info[elem]} for elem in push_info]
                r = requests.post(
                    SET_GRAPH_PARAMS,
                    data=json.dumps({
                        'jsonrpc': "2.0",
                        'id': 'id',
                        'method': 'setGlobalParameters',
                        'params': {'workflowId': graph_id,
                                   'params': params}
                    }),
                    verify=False,
                    headers=headers,
                )

                ## Run
                requests.get(START_GRAPH_TEMPLATE.format(graph_id), headers=headers, verify=False).json()

if __name__ == '__main__':
    main()
