#-*- coding: UTF-8 -*-
from common import *
from social_push_common import *

from time import time
from random import randint
import urllib2

MIN_RATE_VIDEO_PUSH_TIMEDELTA = 3 * 24 * 60 * 60

TVT_COMMON_TYPE = "common"
TVT_DISLIKE_TYPE = "dislike"
TVT_NO_PUSH_TYPE = "no_push"

CONTENT_ID_WHITELIST_DURATION = {}

def is_enough_tvt_to_push(tvt, duration):
    if duration <= 180:
        min_view_time = 0
        min_view_percents = 57
    elif duration <= 1200:
        min_view_time = 72
        min_view_percents = 17
    elif duration <= 3600:
        min_view_time = 252
        min_view_percents = 2
    else:
        min_view_time = 216
        min_view_percents = 3
    return tvt > min_view_time + 1.0 / 100 * duration * min_view_percents

def get_type_of_push(tvt, duration):
    if duration <= 180:
        min_view_time = 0
        min_view_percents = 57
    elif duration <= 1200:
        min_view_time = 72
        min_view_percents = 17
    elif duration <= 3600:
        min_view_time = 252
        min_view_percents = 2
    else:
        min_view_time = 216
        min_view_percents = 3
    if tvt >= min_view_time + 1.0 / 100 * duration * min_view_percents:
        return TVT_COMMON_TYPE
    elif tvt >= 0.5 * (min_view_time + 1.0 / 100 * duration * min_view_percents):
        return TVT_DISLIKE_TYPE
    else:
        return TVT_NO_PUSH_TYPE

def can_send_push(timestamps):
    current_ts = int(time())
    for ts in timestamps:
        if ts + MIN_RATE_VIDEO_PUSH_TIMEDELTA > current_ts:
            return False
    return True

def get_install_id(rec):
    if rec["install_id"] == None:
        return rec["uid"]
    return rec["install_id"]

def make_data_for_bell(puid, stream_id, from_block, content_info, text_template):
    url = "https://yandex.ru/efir?stream_id={0}&from_block={1}_bell".format(stream_id, from_block)
    title = content_info["computed_program"].decode('utf8')

    meta = {
        "text": {
            "type": "text",
            "text": text_template.format(title)
        },
        "action": {
            "type": "link",
            "link": url
        }
    }

    return "&service=ether&actor=ya_ether&uid={0}&type={1}&meta={2}&group_key={3}".format(
        puid,
        "custom",
        urllib2.quote(json.dumps(meta)),
        stream_id
    )


class get_data_for_rate_video_bell:
    def __init__(self, text_templates):
        self.text_templates = text_templates

    def __call__(self, recs):
        for rec in recs:
            if not can_send_push(rec.get("timestamps", [])):
                continue

            random_text_index = randint(0, len(self.text_templates) - 1)
            text_template = self.text_templates[random_text_index]

            content_ids = {}
            if rec.get("tv_online_stats"):
                content_ids = rec.get("tv_online_stats")
            for content_id in content_ids:
                content_info = content_ids[content_id]
                if content_id in rec.get("content_ids", []):
                    continue
                if content_id not in CONTENT_ID_WHITELIST_DURATION:
                    continue
                if not is_enough_tvt_to_push(content_info['tvt'], CONTENT_ID_WHITELIST_DURATION[content_id]):
                    continue

                yield Record(puid=rec['puid'],
                             content_ids=[content_id],
                             from_block='tv_online_rate_video' + '_exp_' + str(random_text_index + 1),
                             timestamps=[int(time())],
                             data=make_data_for_bell(rec['puid'],
                                                     content_id,
                                                     'tv_online_rate_video' + '_exp_' + str(random_text_index + 1),
                                                     content_info,
                                                     text_template))
                break


def aggregate_sended_bells(groups):
    for key, recs in groups:
        content_ids = []
        timestamps = []
        for rec in recs:
            content_ids += rec.get("content_ids", [])
            timestamps += rec.get("timestamps", [])
        yield Record(puid=key["puid"],
                     content_ids=content_ids,
                     timestamps=timestamps)


class get_data_for_rate_video_push:
    def __init__(self,
                 content_id,
                 ttl,
                 schedule,
                 text_templates,
                 dislike_text_templates,
                 title_templates,
                 dislike_title_templates,
                 desktop_push_template,
                 pp_push_template,
                 mobile_push_template,
                 regions):
        self.content_id = content_id
        self.ttl = ttl
        self.schedule = schedule
        self.text_templates = text_templates
        self.dislike_text_templates = dislike_text_templates
        self.title_templates = title_templates
        self.dislike_title_templates = dislike_title_templates
        self.desktop_push_template = desktop_push_template
        self.pp_push_template = pp_push_template
        self.mobile_push_template = mobile_push_template
        self.regions = regions

    def __call__(self, recs):
        for rec in recs:
            install_id = get_install_id(rec)
            regions_add = ""
            try:
                bro_uid = int(install_id)
                is_bro_uid = True
            except:
                if len(self.regions) > 0:
                    regions_add = " AND geo_5 IN (" + ",".join(self.regions) + ")"
                is_bro_uid = False
            if is_bro_uid:
                push_templates = [self.desktop_push_template]
            else:
                push_templates = [self.pp_push_template, self.mobile_push_template]

            if not can_send_push(rec.get("timestamps", [])):
                continue

            random_text_index = randint(0, len(self.text_templates) - 1)
            text_template = self.text_templates[random_text_index]
            title_template = self.title_templates[random_text_index]

            content_ids = rec["tv_online_stats"]
            for content_id in content_ids:
                content_info = content_ids[content_id]
                if content_info["stream_block"] == "initial.pip":
                    continue
                if content_id in rec.get("content_ids", []):
                    continue
                if content_id not in CONTENT_ID_WHITELIST_DURATION:
                    continue
                type_of_push = get_type_of_push(content_info['tvt'], CONTENT_ID_WHITELIST_DURATION[content_id])
                if type_of_push == TVT_NO_PUSH_TYPE:
                    continue
                elif type_of_push == TVT_COMMON_TYPE:
                    random_text_index = randint(0, len(self.text_templates) - 1)
                    text_template = self.text_templates[random_text_index]
                    title_template = self.title_templates[random_text_index]
                    suffix = ""
                elif type_of_push == TVT_DISLIKE_TYPE:
                    random_text_index = randint(0, len(self.dislike_text_templates) - 1)
                    text_template = self.dislike_text_templates[random_text_index]
                    title_template = self.dislike_title_templates[random_text_index]
                    suffix = "_dislike"
                else:
                    raise Exception('Unknown type_of_push')
                for push_template in push_templates:
                    yield Record(install_id=install_id,
                                 content_ids=[content_id],
                                 from_block='tv_online_rate_video' + suffix,
                                 timestamps=[int(time())],
                                 push=self.make_data_for_push(install_id,
                                                              content_id,
                                                              'tv_online_rate_video' + suffix,
                                                              content_info,
                                                              text_template,
                                                              title_template,
                                                              push_template,
                                                              regions_add))
                break

    def make_data_for_push(self, install_id, stream_id, from_block, content_info, text_template, title_template,  push_template, regions_add):

        push = deepcopy(push_template)
        push["receiver"] = [push["receiver"].format("tag:uuid==\'{}\' AND ".format(install_id)) + regions_add]
        push["ttl"] = self.ttl

        name = content_info["computed_program"].decode('utf8')
        if title_template != u"Яндекс.Эфир":
            title_template = title_template.format(name)
        else:
            text_template = text_template.format(name)
        push["notification"]["title"] = title_template
        push["notification"]["body"] = text_template

        push["data"]["push_id"] = from_block
        push["data"]["push_uri"] = push["data"]["push_uri"].format("yandex", stream_id, from_block)
        push["data"]["content_id"] = self.content_id
        push["schedule"] = self.schedule
        return json.dumps(push, ensure_ascii=False)

def aggregate_sended_pushes(groups):
    for key, recs in groups:
        content_ids = []
        timestamps = []
        for rec in recs:
            content_ids += rec.get("content_ids", [])
            timestamps += rec.get("timestamps", [])
        yield Record(install_id=key["install_id"],
                     content_ids=content_ids,
                     timestamps=timestamps)


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--desktop_push_template', type=str, required=True)
    parser.add_argument('--mobile_push_template', type=str, required=True)
    parser.add_argument('--pp_push_template', type=str, required=True)
    parser.add_argument('--regions', type=str, required=True)
    parser.add_argument('--input_stat_table', type=str, required=True)
    parser.add_argument('--sended_pushes_table', type=str, required=True)
    parser.add_argument('--sended_bells_table', type=str, required=True)
    parser.add_argument('--content_id', type=str, required=True)
    parser.add_argument('--text_templates', nargs='+', default=[])
    parser.add_argument('--title_templates', nargs='+', default=[])
    parser.add_argument('--dislike_text_templates', nargs='+', default=[])
    parser.add_argument('--dislike_title_templates', nargs='+', default=[])
    parser.add_argument('--text_templates_for_bell', nargs='+', default=[])
    parser.add_argument('--output_table_for_push', type=str, required=True)
    parser.add_argument('--output_table_for_bell', type=str, required=True)
    parser.add_argument('--schedule', type=str, required=True)
    parser.add_argument('--ttl', type=int, required=True)
    parser.add_argument('--testing_mode', default=False, action="store_true")
    parser.add_argument('--prepare_bell', default=False, action="store_true")
    args = parser.parse_args()

    text_templates = [elem.decode('utf8') for elem in args.text_templates]
    title_templates = [elem.decode('utf8') for elem in args.title_templates]
    dislike_text_templates = [elem.decode('utf8') for elem in args.dislike_text_templates]
    dislike_title_templates = [elem.decode('utf8') for elem in args.dislike_title_templates]
    text_templates_for_bell = [elem.decode('utf8') for elem in args.text_templates_for_bell]

    with codecs.open(args.desktop_push_template, 'r', 'utf8') as inp:
        desktop_push_template = json.load(inp)

    with codecs.open(args.mobile_push_template, 'r', 'utf8') as inp:
        mobile_push_template = json.load(inp)

    with codecs.open(args.pp_push_template, 'r', 'utf8') as inp:
        pp_push_template = json.load(inp)

    regions = [line.rstrip() for line in open(args.regions)]

    cluster = clusters.yt.Hahn().env(parallel_operations_limit=10,
                                     yt_spec_defaults=dict(
                                         pool_trees=["physical"],
                                         tentative_pool_trees=["cloud"]
                                     ),
                                     templates=dict(
                                         tmp_root='//tmp',
                                         title='RateVideo'
                                     ))
    job = cluster.job()
    job.table('//home/videolog/strm_meta/iron_branch/concat') \
       .filter(nf.custom(lambda x: x in CONTENT_ID_WHITELIST, 'UUID')) \
       .put('//tmp/ryan112_whitelist_duration')
    job.run()
    for rec in cluster.driver.read('//tmp/ryan112_whitelist_duration'):
        if rec['duration'] != None:
            CONTENT_ID_WHITELIST_DURATION[rec['UUID']] = rec['duration']

    job = cluster.job()
    job.table(args.input_stat_table) \
       .join(job.table(UID_INSTALL_ID_TABLE), type='left', by='uid') \
       .join(job.table(args.sended_pushes_table), type='left', by='install_id') \
       .map(get_data_for_rate_video_push(args.content_id,
                                         args.ttl,
                                         args.schedule,
                                         text_templates,
                                         dislike_text_templates,
                                         title_templates,
                                         dislike_title_templates,
                                         desktop_push_template,
                                         pp_push_template,
                                         mobile_push_template,
                                         regions)) \
       .sort('install_id') \
       .put(args.output_table_for_push)
    job.run()

    if not args.testing_mode:
        job = cluster.job()
        job.concat(job.table(args.sended_pushes_table), job.table(args.output_table_for_push)) \
           .groupby('install_id') \
           .reduce(aggregate_sended_pushes) \
           .sort('install_id') \
           .put(args.sended_pushes_table)
        job.run()

    # QUESTION(vett0): Don't understand why we need this extra work. So I commented this till we get answer.
    # job = cluster.job()
    # job.table(args.output_table_for_push) \
    #    .project('push') \
    #    .put(args.output_table_for_push)
    # job.run()

    if args.prepare_bell:
        job = cluster.job()
        job.table(args.input_stat_table) \
           .join(job.table(CRYPTA_YUID_PUID_TABLE), type='left', by_left='uid', by_right='id') \
           .filter(sf.defined('target_id')) \
           .project(ne.all(), puid="target_id") \
           .join(job.table(args.sended_bells_table), type='left', by='puid') \
           .map(get_data_for_rate_video_bell(text_templates_for_bell)) \
           .put(args.output_table_for_bell)
        job.run()

        if not args.testing_mode:
            job = cluster.job()
            job.concat(job.table(args.sended_bells_table), job.table(args.output_table_for_bell)) \
               .groupby('puid') \
               .reduce(aggregate_sended_bells) \
               .sort('puid') \
               .put(args.sended_bells_table)
            job.run()


if __name__ == '__main__':
    main()

