#-*- coding: UTF-8 -*-
from common import *
from social_push_common import *

from time import time
from collections import Counter
import sys

ONE_REPLY_SOCIAL_TYPE = "comment"
REPLIES_SOCIAL_TYPE = "comments"

ONE_LIKE_SOCIAL_TYPE = "like"
LIKES_SOCIAL_TYPE = "likes"

DISCUSSION_SOCIAL_TYPE = "discussion"

NEW_COMMENTS_SOCIAL_TYPE = "new_interested_content_comments"

SOCIAL_SUFFIX = "sociality"

VIDEO_SERVICE = "video"
ETHER_SERVICE = "ether"

FAKE_COMMENT_ID = "fake_comment_id"

MIN_FIRST_ACTION_TS = 1566917758

PUID_WHITELIST = {"912059367", "269820800", "860248063", "268143712",
                  "256947674", "413256807", "342969442", "307232909"}

CONTENT_ID_WHITELIST_NAME = {}

def can_send_push(last_push_ts, min_push_timedelta):
    return last_push_ts + min_push_timedelta < int(time())

class get_data_for_social_comment_push():
    def __init__(self,
                 desktop_push_template,
                 mobile_push_template,
                 pp_push_template,
                 send_desktop_push,
                 send_mobile_push,
                 service,
                 content_id,
                 ttl,
                 schedule,
                 min_push_timedelta,
                 regions):
        self.desktop_push_template = desktop_push_template
        self.mobile_push_template = mobile_push_template
        self.pp_push_template = pp_push_template
        self.send_desktop_push = send_desktop_push
        self.send_mobile_push = mobile_push_template
        self.service = service
        self.content_id = content_id
        self.ttl = ttl
        self.schedule = schedule
        self.min_push_timedelta = min_push_timedelta
        self.regions = regions

    def __call__(self, groups):
        current_ts = int(time())

        push_templates = []
        if self.send_desktop_push:
            push_templates.append(self.desktop_push_template)
        if self.send_mobile_push:
            push_templates.append(self.mobile_push_template)
            push_templates.append(self.pp_push_template)

        for key, recs in groups:
            last_push_ts = 0
            has_push_to_send = False
            most_replied_comment_replies = 0
            most_liked_comment_likes = 0
            most_commented_uuid_comments = 0

            uuid = None
            entity_url = None
            comment_id = None

            for rec in recs:
                if self.service == VIDEO_SERVICE:
                    if rec.get("is_porno") in [True, None]:
                        continue
                    if rec.get("entity_url") in [None, ""]:
                        continue
                last_user_uuid_interaction_ts = MIN_FIRST_ACTION_TS

                if len(rec["timestamps"]) > 0:
                    last_push_ts = max(last_push_ts, rec["timestamps"][-1])
                    last_user_uuid_interaction_ts = max(last_user_uuid_interaction_ts, rec["timestamps"][-1])

                if len(rec["user_actions"]) > 0:
                    last_user_uuid_interaction_ts = max(last_user_uuid_interaction_ts, rec["user_actions"][-1]["ts"])

                for cmnt_id in rec["likes_or_replies_by_comment_id"]:
                    new_comment_replies = [el for el in rec["likes_or_replies_by_comment_id"][cmnt_id] if el["type"] == COMMENT_ACTION_TYPE and el["ts"] > last_user_uuid_interaction_ts]
                    new_comment_replies_delete = [el for el in rec["likes_or_replies_by_comment_id"][cmnt_id] if el["type"] == DELETE_COMMENT_ACTION_TYPE and el["ts"] > last_user_uuid_interaction_ts]
                    new_replies = len(new_comment_replies) - len(new_comment_replies_delete)
                    if new_replies > most_replied_comment_replies:
                        has_push_to_send = True
                        uuid = rec["uuid"]
                        entity_url = rec.get("entity_url")
                        comment_id = cmnt_id
                        most_replied_comment_replies = new_replies

                    new_comment_likes = [el for el in rec["likes_or_replies_by_comment_id"][cmnt_id] if el["type"] == LIKE_COMMENT_ACTION_TYPE and el["reaction_type"] == "128077" and el["ts"] > last_user_uuid_interaction_ts]
                    new_comment_likes_delete = [el for el in rec["likes_or_replies_by_comment_id"][cmnt_id] if el["type"] == DELETE_LIKE_ACTION_TYPE and el["reaction_type"] == "128077" and el["ts"] > last_user_uuid_interaction_ts]
                    new_likes = len(new_comment_likes) - len(new_comment_likes_delete)
                    if most_replied_comment_replies == 0 and new_likes > most_liked_comment_likes:
                        has_push_to_send = True
                        uuid = rec["uuid"]
                        entity_url = rec.get("entity_url")
                        comment_id = cmnt_id
                        most_liked_comment_likes = new_likes
                    if most_replied_comment_replies == 0 and most_liked_comment_likes == 0:
                        new_uuid_comments = [el for el in rec["uuid_actions"] if el["type"] == COMMENT_ACTION_TYPE and el["ts"] > last_user_uuid_interaction_ts]
                        if len(new_uuid_comments) > most_commented_uuid_comments:
                            has_push_to_send = True
                            uuid = rec["uuid"]
                            entity_url = rec.get("entity_url")
                            comment_id = cmnt_id
                            most_commented_uuid_comments = len(new_uuid_comments)

            if not can_send_push(last_push_ts, self.min_push_timedelta) or not has_push_to_send:
                continue

            if most_replied_comment_replies > 0:
                actions_count = most_replied_comment_replies
                social_type = REPLIES_SOCIAL_TYPE
            elif most_liked_comment_likes > 0:
                actions_count = most_liked_comment_likes
                social_type = LIKES_SOCIAL_TYPE
            elif most_commented_uuid_comments > 0:
                actions_count = most_commented_uuid_comments
                social_type = NEW_COMMENTS_SOCIAL_TYPE
            else:
                continue

            if self.service == VIDEO_SERVICE and comment_id != FAKE_COMMENT_ID and social_type in [REPLIES_SOCIAL_TYPE, LIKES_SOCIAL_TYPE]:
                entity_url += "&commentId=" + comment_id

            for push_template in push_templates:
                regions_add = ""
                if push_template != self.desktop_push_template:
                    regions_add = " AND geo_5 IN (" + ",".join(self.regions) + ")"
                text, from_block = self.get_push_text_and_from_block(social_type, actions_count, uuid)
                yield Record(puid=key["puid"],
                             uuid=uuid,
                             timestamps=[current_ts],
                             push=self.make_data_for_push(key["puid"],
                                                         uuid,
                                                         entity_url,
                                                         from_block,
                                                         text,
                                                         push_template,
                                                         regions_add))

    def get_push_text_and_from_block(self, social_type, actions_count, uuid):
        text_suffix = ""
        from_block_suffix = ""
        has_uuid_name = False
        if uuid in CONTENT_ID_WHITELIST_NAME:
            has_uuid_name = True
            uuid_name = CONTENT_ID_WHITELIST_NAME[uuid].decode("utf8")
            text_suffix = u" к видео «{}»".format(uuid_name)
            from_block_suffix = "_with_video_name"

        if self.service == ETHER_SERVICE:
            prefix = "tv_online_"
        elif self.service == VIDEO_SERVICE:
            prefix = "video_"
        else:
            raise Exception("Unknown service")

        from_block = prefix + "{}_{}".format(social_type, SOCIAL_SUFFIX) + from_block_suffix + "_exp"

        if social_type == NEW_COMMENTS_SOCIAL_TYPE:
            if has_uuid_name:
                text_suffix = u" про видео «{}»".format(uuid_name)
                return u"✍️Пользователи обсуждают интересное вам видео. Посмотрите, что " + get_write_word(actions_count) + u" еще " + \
                    str(actions_count) + " " + get_user_word(actions_count) + text_suffix + u"✍️", from_block
            else:
                return u"✍️Видео, которое вы прокомментировали, обсуждают. Посмотрите, что " + get_write_word(actions_count) + u" еще " + \
                    str(actions_count) + " " + get_user_word(actions_count) + u"✍️", from_block
        if social_type == REPLIES_SOCIAL_TYPE:
            return u"Еще " + str(actions_count) + " " + get_user_word(actions_count) + " " + get_answer_word(actions_count) + \
                   u" на ваш комментарий" + text_suffix + u"💬", from_block
        if social_type == LIKES_SOCIAL_TYPE:
            return u"Еще " + str(actions_count) + " " + get_user_word(actions_count) + " " + get_like_word(actions_count) + \
                   u" ваш комментарий" + text_suffix + u"👍", from_block

    def make_data_for_push(self, puid, stream_id, entity_url, from_block, text, push_template, regions_add):
        push = deepcopy(push_template)
        push["receiver"] = [push["receiver"].format("tag:uid==\'{}\' AND ".format(puid)) + regions_add]
        push["ttl"] = self.ttl
        push.pop("throttle_policies")

        if self.service == ETHER_SERVICE:
            push["notification"]["title"] = u"Яндекс.Эфир"
            sys.stderr.write(str(push["data"]["push_uri"]) + "\n");
            sys.stderr.write(str(("yandex", stream_id, from_block)) + "\n");
            push["data"]["push_uri"] = push["data"]["push_uri"].format("yandex", stream_id, from_block)
        elif self.service == VIDEO_SERVICE:
            push["notification"]["title"] = u"Яндекс.Видео"
            push["data"]["push_uri"] = entity_url + "&source=" + from_block
            push["notification"]["icon"] = "https://yastatic.net/iconostasis/_/UqctDK-6xKDThL4IP43Q8O4JikM.png"
        push["notification"]["body"] = text

        push["data"]["push_id"] = from_block
        push["schedule"] = self.schedule
        return json.dumps(push, ensure_ascii=False)

def get_write_word(num):
    if num % 10 == 1 and num % 100 != 11:
        return u"пишет"
    else:
        return u"пишут"

def get_answer_word(num):
    if num % 10 == 1 and num % 100 != 11:
        return u"ответил"
    else:
        return u"ответили"

def get_like_word(num):
    if num % 10 == 1 and num % 100 != 11:
        return u"оценил"
    else:
        return u"оценили"

def get_user_word(num):
    if num % 10 in [5, 6, 7, 8, 9, 0] or num % 100 in [11, 12, 13, 14]:
        return u"пользователей"
    elif num % 10 == 1:
        return u"пользователь"
    elif num % 10 in [2, 3, 4]:
        return u"пользователя"
    else:
        raise Exception("Unknown word")

def get_tables_list(sended_cmnt_push_table, input_fast_squeeze_dir, cluster, job):
    last_date = ""
    if cluster.driver.exists(sended_cmnt_push_table):
        last_date = cluster.driver.read(sended_cmnt_push_table)[0]["date"]
    return [job.table("{}/{}".format(input_fast_squeeze_dir, suffix)) for suffix in filter(lambda date: date > last_date, cluster.driver.list(input_fast_squeeze_dir))]

def aggregate_new_social_info(groups):
    for key, recs in groups:
        likes_or_replies_by_comment_id = Counter()

        user_actions = []

        common_fields = {"puid" : key["puid"],
                         "uuid" : key["uuid"]}

        for rec in recs:
            if rec["puid"] == rec["action_owner_puid"]:
                user_actions += [{"ts" : int(rec["ts"]), "type" : rec["action_type"], "comment_id" : rec.get("comment_id", FAKE_COMMENT_ID)}]
            else:
                comment_id = rec.get("comment_id", FAKE_COMMENT_ID)
                info = {"puid" : rec["action_owner_puid"],
                        "comment_id" : rec.get("action_owner_comment_id", FAKE_COMMENT_ID),
                        "ts" : int(rec["ts"]),
                        "type" : rec["action_type"],
                        "reaction_type" : rec["reaction_type"]}
                likes_or_replies_by_comment_id[comment_id] = likes_or_replies_by_comment_id.get(comment_id, []) + [info]

        yield Record(user_actions=user_actions,
                     likes_or_replies_by_comment_id=likes_or_replies_by_comment_id,
                     **common_fields)

def aggregate_new_uuid_actions(groups):
    for key, recs in groups:
        new_uuid_actions = []
        for rec in recs:
            new_uuid_actions.append({"ts" : int(rec["ts"]), "type" : rec["action_type"], "comment_id" : rec.get("comment_id", FAKE_COMMENT_ID), "puid" : rec["puid"]})
        yield Record(uuid=key["uuid"], new_uuid_actions=new_uuid_actions)

def update_social_info(groups):
    for key, recs in groups:

        likes_or_replies_by_comment_id = Counter()
        user_actions = []
        uuid_actions = []
        timestamps = []

        common_fields = {"puid" : key["puid"],
                         "uuid" : key["uuid"]}

        for rec in recs:
            for comment_id in rec.get("likes_or_replies_by_comment_id", []):
                likes_or_replies_by_comment_id[comment_id] = likes_or_replies_by_comment_id.get(comment_id, []) + rec["likes_or_replies_by_comment_id"][comment_id]
            user_actions += rec.get("user_actions", [])
            uuid_actions += rec.get("uuid_actions", [])

            timestamps += rec.get("timestamps", [])
            if "entity_url" in rec:
                common_fields["entity_url"] = rec["entity_url"]
            if "is_porno" in rec:
                common_fields["is_porno"] = rec["is_porno"]

        yield Record(likes_or_replies_by_comment_id=likes_or_replies_by_comment_id,
                     user_actions=sorted(user_actions, key=lambda x : x["ts"]),
                     uuid_actions=sorted(uuid_actions, key=lambda x : x["ts"]),
                     timestamps=sorted(timestamps),
                     **common_fields)

def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--desktop_push_template', type=str, required=True)
    parser.add_argument('--mobile_push_template', type=str, required=True)
    parser.add_argument('--pp_push_template', type=str, required=True)
    parser.add_argument('--regions', type=str, required=True)
    parser.add_argument('--sended_cmnt_push_table', type=str, required=True)
    parser.add_argument('--service', type=str, required=True)
    parser.add_argument('--send_desktop_push', type=int, required=True)
    parser.add_argument('--send_mobile_push', type=int, required=True)
    parser.add_argument('--input_fast_squeeze_dir', type=str, required=True)
    parser.add_argument('--likes_and_cmnt_table', type=str, required=True)
    parser.add_argument('--output_table_for_push', type=str, required=True)
    parser.add_argument('--content_id', type=str, required=True)
    parser.add_argument('--ttl', type=int, required=True)
    parser.add_argument('--schedule', type=str, required=True)
    parser.add_argument('--min_push_timedelta', type=int, required=True)
    args = parser.parse_args()

    with codecs.open(args.desktop_push_template, 'r', 'utf8') as inp:
        desktop_push_template = json.load(inp)

    with codecs.open(args.mobile_push_template, 'r', 'utf8') as inp:
        mobile_push_template = json.load(inp)

    with codecs.open(args.pp_push_template, 'r', 'utf8') as inp:
        pp_push_template = json.load(inp)

    regions = [line.rstrip() for line in open(args.regions)]

    if len(regions) == 0:
        return

    cluster = clusters.yt.Hahn().env(parallel_operations_limit=10,
                                     yt_spec_defaults=dict(
                                         pool_trees=["physical"],
                                         tentative_pool_trees=["cloud"]
                                     ),
                                     templates=dict(
                                         tmp_root='//tmp',
                                         title='SocialCommentPush'
                                     ))

    if args.service == ETHER_SERVICE:
        job = cluster.job()
        job.table(STRM_META_PATH) \
        .filter(nf.custom(lambda x: x in CONTENT_ID_WHITELIST, 'UUID')) \
        .put('//tmp/ryan112_whitelist_name')
        job.run()
        for rec in cluster.driver.read('//tmp/ryan112_whitelist_name'):
            if rec['computed_program'] != None:
                CONTENT_ID_WHITELIST_NAME[rec['UUID']] = rec['computed_program']

    job = cluster.job()
    last_date = max(cluster.driver.list(args.input_fast_squeeze_dir))
    tables_list = get_tables_list(args.sended_cmnt_push_table, args.input_fast_squeeze_dir, cluster, job)
    if len(tables_list) != 0:
        new_likes_and_cmnt_stats_table = job.concat(*tables_list) \
                                         .filter(sf.equals('servicetype', args.service)) \
                                         .groupby("uuid", "puid") \
                                         .reduce(aggregate_new_social_info)

        new_uuid_actions_table = job.concat(*tables_list) \
                                     .filter(sf.equals('servicetype', args.service),
                                             nf.custom(lambda puid, puidto: puid == puidto, "action_owner_puid", "puid")) \
                                     .groupby("uuid") \
                                     .reduce(aggregate_new_uuid_actions)

        new_uuid_info_table = job.concat(*tables_list) \
                                 .filter(sf.equals('servicetype', args.service)) \
                                 .groupby("uuid") \
                                 .aggregate(new_is_porno=na.last("is_porno", by="is_porno"),
                                            new_entity_url=na.last("entity_url", by="entity_url"))

        to_concat = [new_likes_and_cmnt_stats_table]
        if cluster.driver.exists(args.likes_and_cmnt_table):
            to_concat.append(job.table(args.likes_and_cmnt_table))
        job.concat(*to_concat) \
           .groupby("puid", "uuid") \
           .reduce(update_social_info) \
           .join(new_uuid_actions_table, by='uuid', type='left') \
           .join(new_uuid_info_table, by='uuid', type='left') \
           .project(ne.all(exclude=('new_uuid_actions', 'uuid_actions', 'new_is_porno', 'is_porno', 'new_entity_url', 'entity_url')),
                    is_porno=ne.custom(lambda x, y : y if y != None else x, 'is_porno', 'new_is_porno'),
                    entity_url=ne.custom(lambda x, y : y if y else x, 'entity_url', 'new_entity_url'),
                    uuid_actions=ne.custom(lambda x, y : sorted(x + y, key=lambda x : x["ts"]) if y else x, 'uuid_actions', 'new_uuid_actions')) \
           .sort("puid", "uuid") \
           .put(args.likes_and_cmnt_table)
    job.run()

    cluster.driver.write(args.sended_cmnt_push_table, [Record(date=last_date)])

    job = cluster.job()

    job.table(args.likes_and_cmnt_table) \
       .groupby("puid") \
       .reduce(get_data_for_social_comment_push(desktop_push_template,
                                                mobile_push_template,
                                                pp_push_template,
                                                args.send_desktop_push,
                                                args.send_mobile_push,
                                                args.service,
                                                args.content_id,
                                                args.ttl,
                                                args.schedule,
                                                args.min_push_timedelta,
                                                regions)) \
       .put(args.output_table_for_push)
    job.run()

    job = cluster.job()
    sended_likes_and_cmnt_table = job.table(args.output_table_for_push) \
                                     .groupby("puid", "uuid") \
                                     .aggregate(timestamps=na.any("timestamps"))

    job.concat(job.table(args.likes_and_cmnt_table),
               sended_likes_and_cmnt_table) \
       .groupby("puid", "uuid") \
       .reduce(update_social_info) \
       .sort("puid", "uuid") \
       .put(args.likes_and_cmnt_table)
    job.run()

    job = cluster.job()
    job.table(args.output_table_for_push) \
       .project("push") \
       .put(args.output_table_for_push + "_prepared")
    job.run()

if __name__ == '__main__':
    main()
