from datetime import datetime

JS_API_PLAYER_ID_START_DATE = {
    "html5_regexps_content_url" : datetime.strptime("20180320", "%Y%m%d"),
    "html5_vtextractor.video.nothumb_html5" : datetime.strptime("20180320", "%Y%m%d"),
    "html5_vtextractor.video.thumb_html5" : datetime.strptime("20180320", "%Y%m%d"),
    "raw_json.semantic.schema_embed_url" : datetime.strptime("20180320", "%Y%m%d"),
    "raw_opengraph_embed_url" : datetime.strptime("20180320", "%Y%m%d"),
    "raw_opengraph_iframe" : datetime.strptime("20180320", "%Y%m%d"),
    "raw_refapi_embed_url" : datetime.strptime("20180320", "%Y%m%d"),
    "raw_refapi_iframe" : datetime.strptime("20180320", "%Y%m%d"),
    "raw_wildplayer_iframe" : datetime.strptime("20180320", "%Y%m%d"),
    "24video" : datetime.strptime("20180320", "%Y%m%d"),
    "clipiki" : datetime.strptime("20180320", "%Y%m%d"),
    "dailymotion" : datetime.strptime("20180320", "%Y%m%d"),
    "hdgo" : datetime.strptime("20180320", "%Y%m%d"),
    "ioua" : datetime.strptime("20180320", "%Y%m%d"),
    "kinoluvr" : datetime.strptime("20180320", "%Y%m%d"),
    "mailru" : datetime.strptime("20180320", "%Y%m%d"),
    "mirsexy" : datetime.strptime("20180320", "%Y%m%d"),
    "moonwalk" : datetime.strptime("20180320", "%Y%m%d"),
    "myvi" : datetime.strptime("20180320", "%Y%m%d"),
    "myvitv" : datetime.strptime("20180320", "%Y%m%d"),
    "newstube" : datetime.strptime("20180320", "%Y%m%d"),
    "nurkz" : datetime.strptime("20180320", "%Y%m%d"),
    "ok" : datetime.strptime("20180320", "%Y%m%d"),
    "planeta-online" : datetime.strptime("20180320", "%Y%m%d"),
    "prostoporno" : datetime.strptime("20180320", "%Y%m%d"),
    "rutube" : datetime.strptime("20180320", "%Y%m%d"),
    "semyana" : datetime.strptime("20180320", "%Y%m%d"),
    "sibnet" : datetime.strptime("20180320", "%Y%m%d"),
    "stormo" : datetime.strptime("20180320", "%Y%m%d"),
    "uakino" : datetime.strptime("20180320", "%Y%m%d"),
    "vh" : datetime.strptime("20180320", "%Y%m%d"),
    "videomore" : datetime.strptime("20180320", "%Y%m%d"),
    "vimeo" : datetime.strptime("20180320", "%Y%m%d"),
    "vk" : datetime.strptime("20180320", "%Y%m%d"),
    "youtube" : datetime.strptime("20180320", "%Y%m%d")
}

PLAYER_EVENT_INITED = "player-events.inited";
PLAYER_EVENT_STARTED = "player-events.started";
PLAYER_EVENT_PAUSED = "player-events.paused";
PLAYER_EVENT_ENDED = "player-events.ended";

MAX_PLAYER_EVENT_TIME_DELTA = 1
BASE_REFUSE_THRESHOLD = 30
AUTOOPEN_REFUSE_THRESHOLD = 120

BASE_CORRECTED_COEF = 0.85
DESKTOP_PORNO_AUTOOPEN_COEF = 0.55
DESKTOP_NOT_PORNO_AUTOOPEN_COEF = 0.75
TOUCH_PORNO_AUTOOPEN_COEF = 0.7

def is_autoopen(result, position):
    return position == 0 and len(result.GetClicks()) == 0

def can_use_js_api_events(result, result_player_events, request_ts):
    if len(result_player_events) == 0:
        return False
    return result.PlayerId in JS_API_PLAYER_ID_START_DATE and datetime.fromtimestamp(request_ts) >= JS_API_PLAYER_ID_START_DATE[result.PlayerId]

def get_corrected_coef(is_autoopen, request):
    is_porno = request.IsA('TMiscRequestProperties') and request.SearchPropsValues.get('VIDEO.VideoPorno.vidprn') == 'ipq1'

    if request.IsA("TTouchUIProperties") or request.IsA("TMobileAppUIProperties"):
        platform = "touch"
    else:
        platform = "desktop"

    if is_autoopen:
        if is_porno:
            if platform == "desktop":
                return DESKTOP_PORNO_AUTOOPEN_COEF
            if platform == "touch":
                return TOUCH_PORNO_AUTOOPEN_COEF
        else:
            if platform == "desktop":
                return DESKTOP_NOT_PORNO_AUTOOPEN_COEF
    return BASE_CORRECTED_COEF

def get_player_events_by_url(request, url):
    player_events = []
    for tech_event in request.GetYandexTechEvents():
        if tech_event.IsA("TVideoPlayerEvent") and tech_event.Url == url:
            player_events.append(tech_event)
    return player_events

def get_view_time_borders(request, result):
    duration = request.FindVideoDurationInfo(result)
    view_time = 0
    if duration:
        view_time = min(duration.PlayingDuration, duration.Duration)

    heartbeat = request.FindVideoHeartbeat(result, 'ANY')
    if heartbeat:
        view_time = max(view_time, min(heartbeat.Ticks, heartbeat.Duration))
    if len(result.GetClicks()) == 0:
        start_ts = request.Timestamp
    else:
        start_ts = result.GetClicks()[-1].Timestamp
    return start_ts, start_ts + view_time

def calculate_corrected_view_time_borders(request, result, position):
    result_player_events = get_player_events_by_url(request, result.Url)

    start_ts, end_ts = get_view_time_borders(request, result)
    if start_ts == end_ts:
        return 0, 0

    ### Updating start_ts using player-events.inited

    for player_event in result_player_events:
        if player_event.Path == PLAYER_EVENT_INITED:
            start_ts = max(start_ts, player_event.Timestamp)
            break

    if can_use_js_api_events(result, result_player_events, request.Timestamp):

        ### If no player-events.started in result_player_events, then there is no real view

        has_started = False
        for player_event in result_player_events:
            if player_event.Path == PLAYER_EVENT_STARTED:
                has_started = True
                start_ts = max(start_ts, player_event.Timestamp)
                break
        if not has_started:
            return 0, 0
        start_ts = min(start_ts, end_ts)

        ### If last player_event is player-events.{paused, ended} and there are no player-event with similar timestamp,
        ### this action is end of real view

        if result_player_events[-1].Path in [PLAYER_EVENT_PAUSED, PLAYER_EVENT_ENDED]:
            has_player_event_near = len(result_player_events) > 1 and abs(result_player_events[-2].Timestamp - result_player_events[-1].Timestamp) < MAX_PLAYER_EVENT_TIME_DELTA
            if not has_player_event_near:
                end_ts = min(end_ts, result_player_events[-1].Timestamp)
        end_ts = max(end_ts, start_ts)

        return start_ts, end_ts

    else:

        ### If there is "bad" player, we use old_tvt corrected by special coef and refuse_threshold

        view_time = max(end_ts - start_ts, 0)
        refuse_threshold = BASE_REFUSE_THRESHOLD

        if is_autoopen(result, position):
            refuse_threshold = AUTOOPEN_REFUSE_THRESHOLD

        view_time = (view_time > refuse_threshold) * view_time

        corrected_coef = get_corrected_coef(is_autoopen(result, position), request)

        return end_ts - int(corrected_coef * view_time), end_ts
