#!/usr/bin/env python
# -*- coding: utf-8 -*-
import json
import codecs
import argparse
import itertools


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('input')
    parser.add_argument('output')
    parser.add_argument('output_serps')
    args = parser.parse_args()

    obj = json.load(open(args.input))
    serps_output = []
    result = []
    player_urls = {}
    for it in obj:
        urls = []
        for x in it['serp-page']['parser-results']['components']:
            if x['type'] != 'SEARCH_RESULT' or len(urls) >= 10:
                continue
            urls.append(x['page-url'])
            player_urls[x['page-url']] = x.get('video-player-html') or ''
        serps_output.append(
            {
                'query': it[
                    'serp-request-explained'
                ]['per-query-parameters']['query-text'],
                'serp': urls
            }
        )
        for pair in itertools.combinations(urls, 2):
            result.append(sorted(pair))

    json.dump(
        {'pairs': result, 'player_urls': player_urls},
        open(args.output, 'w'), indent=2
    )
    json.dump(
        serps_output, codecs.open(args.output_serps, 'w', 'utf8'),
        indent=2, sort_keys=True, ensure_ascii=False
    )


if __name__ == "__main__":
    main()
