#!/usr/bin/env python
# -*- coding: utf-8 -*-
from __future__ import unicode_literals
from __future__ import division
import sys
import os
import codecs
import argparse
import json


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('input_pairs')
    parser.add_argument('input_ok')
    parser.add_argument('output')
    args = parser.parse_args()

    ok = {x['ji']['url'] for x in json.load(open(args.input_ok))}

    pairs = json.load(open(args.input_pairs))

    pairs = [pair for pair in pairs if pair['url1'] in ok]

    json.dump(pairs, open(args.output, 'w'), indent=2)


if __name__ == "__main__":
    main()
