use hahn;
pragma yt.Pool = "${pool}";
pragma yt.PoolTrees = "physical";
pragma yt.UseDefaultTentativePoolTrees;

$table = "//home/videolog/pcode-11712-gogol/${date_from}_${date_to}/events_full_joined";

$total = (select count(*) from $table);

SELECT 
    jstracer, gogol, count(*) as `count`, count(*) / cast($total as Double) as share
from $table
group by
    IF(EventName is null, 0, 1) as jstracer,
    IF(eventName is null, 0, 1) as gogol
order by `count` desc