#!/usr/bin/env python
# -*- coding: utf-8 -*-
import json
import argparse


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('input')
    parser.add_argument('output')
    parser.add_argument('--threshold', default=20, type=int)
    args = parser.parse_args()

    obj = json.load(open(args.input))
    result = []
    for it in obj:
        for x in it['serp-page']['parser-results']['components']:
            if len(result) >= args.threshold:
                continue
            try:
                url = x['page-url']
            except (KeyError, TypeError):
                continue
            viewkey = url.split('viewkey=')[-1]
            player = (
                '<iframe src="//www.pornhub.com/embed/{}"'
                ' frameborder="0" scrolling="no" allowfullscreen="1" '
                'aria-label="Video"/>'.format(viewkey)
            )
            result.append({'url': url, 'player': player})

    json.dump(result, open(args.output, 'w'), indent=2)


if __name__ == "__main__":
    main()
