#!/usr/bin/env python
# -*- coding: utf-8 -*-
from __future__ import division
import sys
import os
import codecs
import argparse
from nile.api.v1 import (
    clusters,
    filters as nf,
    extractors as ne,
    aggregators as na,
    Record
)
import getpass
import datetime


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('table')
    parser.add_argument('output')
    parser.add_argument('--token', default="")
    parser.add_argument('--threshold', type=int, default=200)
    args = parser.parse_args()

    with open(args.table) as f:
        table = f.read().strip()

    hahn = clusters.yt.Hahn(token=args.token)

    recs = hahn.read(table)

    with codecs.open(args.output, 'w', 'utf8') as f:
        for rec in recs:
            if rec.amount < args.threshold:
                continue
            f.write(u'{}\t{}\t{}\t{}\n'.format(
                rec.query.decode('utf8', errors='replace'),
                rec.episode.decode('utf8', errors='replace').split(u';')[0],
                rec.episode.decode('utf8', errors='replace').split(u';')[1],
                rec.episode.decode('utf8', errors='replace').split(u';')[3]
            ))


if __name__ == "__main__":
    main()
