#!/usr/bin/env python
# -*- coding: utf-8 -*-
from __future__ import division
import sys
import os
import codecs
import json
import argparse
from copy import deepcopy

from nile.api.v1 import statface as ns


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--data', '-d', required=True)
    parser.add_argument('--additional', '-a', default=None)
    parser.add_argument('--stat_login', '-sl', default='robot_pecheny')
    parser.add_argument('--stat_password', '-sp', required=True)
    parser.add_argument('--report', '-r', required=True)
    parser.add_argument('--replace_mask', '-rm', default=None)
    parser.add_argument(
        '--dont_normalize_fielddate', '-dnf', action='store_true'
    )
    args = parser.parse_args()

    data = json.load(open(args.data))
    add = None
    if args.additional:
        add = json.load(open(args.additional))

    data = data['values']

    data = [x for x in data if '_empty_row' not in x]
    for x in data:
        for k in x.keys():
            if k.endswith(('__ms', '_override_by_dictionary')):
                x.pop(k)
            if k == 'fielddate' and not args.dont_normalize_fielddate:
                x[k] = x[k].split(' ')[0]

    result = []
    if add:
        for x in data:
            for a in add:
                new = deepcopy(x)
                new.update(a)
                result.append(new)
    else:
        result = data

    client = ns.StatfaceClient(
        proxy='upload.stat.yandex-team.ru',
        username=args.stat_login,
        password=args.stat_password
    )

    report = ns.StatfaceReport().path(
        args.report
    ).scale('daily').client(
        client
    )

    if args.replace_mask:
        report = report.replace_mask(args.replace_mask)

    report.data(
        result
    ).publish()


if __name__ == "__main__":
    main()
