use hahn;
PRAGMA yt.Pool = 'search-research_pecheny';
$getChannelPyScript = @@
import re
request_re = re.compile(r'^\/dvr\/(.*)/.*-(.*)\.ts$')
request_kal_re = re.compile(r'^\/kal\/(.*)/(.*)/.*-([0-9]+)-.*\.ts$')
vod_request_re = re.compile(r'vh-(.*)-converted/vod-content/.*\.ts')
zen_request_re = re.compile(r'/(.*)-vod/vod-content/.*\.ts')

def strip_string(s):
    s = re.sub(r'[^a-z_]', '', s)
    return s.split('/')[0].split('-')[0]

def get_channel(request):
    if not request or len(request) < 50:
        return ["unknown", "unknown"]
    match = request_re.findall(request)

    if request.find('cdn1tvru/live') > -1:
        return ['1tv', 'live']

    if request.find('cdn1tvru/vod') > -1:
        return ['1tv', 'vod']

    if match:
        return [strip_string(match[0][0]), 'live']

    match = request_kal_re.findall(request)

    if match:
        return [strip_string(match[0][0]), 'live']

    match = vod_request_re.findall(request)

    if match:
        return [strip_string(match[0]), 'vod']

    match = zen_request_re.findall(request)

    if match:
        return [strip_string(match[0]), 'vod']

    if '/get-video-hosting' in request:
        return ['ott', 'vod']

    return ['unknown', 'unknown']
@@;


$ornull = ($y, $z) -> {RETURN IF($y IS NULL, $z, $y)};
$getChannel = ($y) -> {
    RETURN $ornull(ListConcat(ListTake(ListSkip(String::SplitToList($y, '/'),7), 1)))
};
-- $getMinute = ($x) -> {
--     $y = CAST($x as UInt64);
--     RETURN DateTime::ToStringFormat(DateTime::TimestampFromSeconds(
--         $y + 10800 - $y % 3600
--     ), "%Y-%m-%d %H:%M:00")
-- };
$getChannelPyBase = Python::get_channel("(String?)->List<String>", $getChannelPyScript);
$getChannelPy = ($x) -> {RETURN $getChannelPyBase($x){0}};
$getViewTypePy = ($x) -> {RETURN $getChannelPyBase($x){1}};

$tmp = (
    select
    CAST(bytes_sent AS UInt64) as bytes_sent,
    $ornull(Geo::RoundRegionByIp(ip, "country").en_name, "NULL") as country,
    $ornull($getChannelPy(request), "unknown") as channel,
    $ornull($getViewTypePy(request), "unknown") as view_type,
    "%DATE%" as fielddate
    from [//logs/strm-access-log/1d/%DATE%]
);

$tmp2 = (
    select
    fielddate,
    country,
    channel,
    view_type,
    sum(bytes_sent) as bytes_sent,
    CAST(sum(bytes_sent) AS Double)/ 1099511627776.0 as tib_sent
    from $tmp
    group by fielddate, view_type, country, channel
);

insert into [%OUT_PATH%] with truncate
SELECT 
    fielddate,
    $ornull(country, "_total_") as country,
    $ornull(channel, "_total_") as channel,
    $ornull(view_type, "_total_") as view_type,
    sum(tib_sent) as tib_sent,
    sum(bytes_sent) as bytes_sent
    
from $tmp2
group by fielddate, cube(
    country,
    channel,
    view_type
)
order by fielddate, bytes_sent;