#!/usr/bin/env python
# -*- coding: utf-8 -*-
from __future__ import unicode_literals
from __future__ import division
import sys
import os
import codecs
import argparse
import urllib
import json
import requests
import os
import subprocess
import shlex
import tqdm
import time
os.environ['REQUESTS_CA_BUNDLE'] = '/etc/ssl/certs/ca-certificates.crt'

devnull = open(os.devnull, 'w')


def sh(s):
    subprocess.call(shlex.split(s), stdout=devnull, stderr=devnull)


def upload_to_mds(filename, target_filename):
    sh('aws --endpoint-url=http://s3.mds.yandex.net s3 cp {filename} s3://vlt-converted/{target_filename}'.format(
        filename=filename,
        target_filename=target_filename
    ))


iframe_stub = '<iframe src="https://yastatic.net/yandex-video-player-iframe-api/?mq_url={}&preview=https%3A//vlt-converted.s3.yandex.net/preview.png&autoplay=false&hidden=timeline&preload=false" frameborder="0" scrolling="no" allowfullscreen="1" aria-label="Video"></iframe>'
iframe_src = 'https://yastatic.net/yandex-video-player-iframe-api/?mq_url={}&preview=https%3A//vlt-converted.s3.yandex.net/preview.png&autoplay=false&hidden=timeline&preload=false'


def retry(link):
    tries = 0
    req = None
    while tries < 5 and (not req):
        try:
            req = requests.get(link)
            return req
        except requests.exceptions.ConnectionError:
            time.sleep(1)
            tries += 1


def main():
    info = json.load(open('video_info_good_processed2.json'))

    for i, obj in enumerate(tqdm.tqdm(info)):
        if 'task_id' not in obj:
            continue
        if 'letter_bad' not in obj:
            if obj['letter'] == 'a':
                obj['letter_bad'] = 'b'
            else:
                obj['letter_bad'] = 'a'
            obj['prefix_bad'] = '{}_{}'.format(obj['md5'], obj['letter_bad'])
        if 'iframe' not in obj:
            obj['playlist_link'] = 'https://vlt-converted.s3.yandex.net/{}.m3u8'.format(
                obj['prefix']
            )
            req = retry(obj['playlist_link'])
            cnt = req.content.decode('utf8')
            if req.status_code == 200 and cnt.startswith('#EXTM3U'):
                obj['iframe_src'] = iframe_src.format(
                    urllib.quote(obj['playlist_link'].encode('utf8'))
                )
                obj['iframe'] = iframe_stub.format(obj['iframe_src'])
                badpl = 'bad_playlist.m3u8'
                target_filename = '{}.m3u8'.format(obj['prefix_bad'])
                if os.path.exists(badpl):
                    os.remove(badpl)
                with codecs.open(badpl, 'w', 'utf8') as f:
                    f.write(cnt.replace(obj['prefix'], obj['prefix_bad']))
                upload_to_mds(badpl, target_filename)
                os.remove(badpl)
                obj['playlist_link_bad'] = 'https://vlt-converted.s3.yandex.net/{}.m3u8'.format(
                    obj['prefix_bad']
                )
                obj['iframe_src_bad'] = iframe_src.format(
                    urllib.quote(obj['playlist_link_bad'].encode('utf8'))
                )
                obj['iframe_bad'] = iframe_stub.format(
                    obj['iframe_src_bad']
                )
        elif 'iframe_src' not in obj:
            obj['iframe_src'] = iframe_src.format(
                urllib.quote(obj['playlist_link'].encode('utf8'))
            )
            obj['iframe_src_bad'] = iframe_src.format(
                urllib.quote(obj['playlist_link_bad'].encode('utf8'))
            )
        else:
            obj['bad_upload'] = True
        if i % 10 == 0:
            json.dump(
                info, open('video_info_good_processed2.json', 'w'), indent=2,
                sort_keys=True
            )
    json.dump(
        info, open('video_info_good_processed2.json', 'w'), indent=2,
        sort_keys=True
    )
    import pdb; pdb.set_trace()


if __name__ == "__main__":
    main()
