#!/usr/bin/env python
# -*- coding: utf-8 -*-
from __future__ import unicode_literals
from __future__ import division
import sys
import os
import codecs
import argparse
import json
import copy


stub = {
    'inputValues': {
        'url': '',
        'code': ''
    },
    'knownSolutions': {
        'outputValues': {'result': ''}
    }
}


def main():
    obj = json.load(open('checked_good_hp_sources_10splus.json'))
    result = []
    ok = 0
    bad = 0
    for x in obj:
        if 'iframe' in x and 'iframe_src' in x:
            new = copy.deepcopy(stub)
            new['inputValues']['url'] = x['iframe_src']
            new['inputValues']['code'] = x['iframe']
            new['knownSolutions']['outputValues']['result'] = 'OK'
            result.append(new)
            ok += 1
        # if 'iframe_bad' in x and 'iframe_src_bad' in x:
        #     new = copy.deepcopy(stub)
        #     new['inputValues']['url'] = x['iframe_src_bad']
        #     new['inputValues']['code'] = x['iframe_bad']
        #     new['knownSolutions']['outputValues']['result'] = 'BAD'
        #     result.append(new)
        # if 'iframe_bad' in x and 'iframe_bad_src' in x:
        #     new = copy.deepcopy(stub)
        #     new['inputValues']['url'] = x['iframe_bad_src']
        #     new['inputValues']['code'] = x['iframe_bad']
        #     new['knownSolutions']['outputValues']['result'] = 'BAD'
        #     result.append(new)
        #     bad += 1
    print('total honeypots: {}, bad: {}, ok: {}'.format(len(result), bad, ok))
    json.dump(
        result, open('vdp_honeypots_20180125.json', 'w'), indent=2, sort_keys=True
    )



if __name__ == "__main__":
    main()
