#!/usr/bin/env python
# -*- coding: utf-8 -*-
from __future__ import division
import sys
import os
import codecs
import argparse
from nile.api.v1 import (
    clusters,
    filters as nf,
    extractors as ne,
    aggregators as na,
    Record
)
import getpass
import datetime
from pytils import yt_get_date_from_table


def parse_date(s):
    try:
        return datetime.datetime.strptime(s, '%Y-%m-%d').date()
    except (TypeError, ValueError):
        return


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--from', required=True)
    parser.add_argument('--token', required=True)
    parser.add_argument('--to', required=True)
    parser.add_argument(
        '--folder',
        default='//home/videoquality/fresh_sbr_and_delays/bar-navig-log/daily_video_plays'
    )
    parser.add_argument('--output', required=True)

    args = parser.parse_args()

    hahn = clusters.yt.Hahn(token=args.token)

    from_ = parse_date(getattr(args, 'from'))
    to_ = parse_date(getattr(args, 'to'))
    if not from_ or not to_:
        print('error in one of the dates')
        sys.exit(1)

    job = hahn.job()
    to_concat = []
    for table in hahn.driver.client.search(
        root=args.folder,
        path_filter=lambda x: yt_get_date_from_table(x) and
        from_ <= yt_get_date_from_table(x) <= to_
    ):
        to_concat.append(job.table(table))

    job.concat(*to_concat).filter(
        nf.custom(
            lambda x: (x or '').startswith(('http://', 'https://')),
            'page_url'
        )
    ).groupby(
        'page_url'
    ).aggregate(
        plays=na.count()
    ).put(
        args.output
    )

    job.run()


if __name__ == "__main__":
    main()
