#!/usr/bin/env python
# -*- coding: utf-8 -*-
# from __future__ import unicode_literals
from __future__ import division
import sys
import os
import codecs
import random
import argparse
from collections import defaultdict, Counter
import math
import json

from nile.api.v1 import (
    statface as ns,
    # Record
)
import getpass
import datetime
from decimal import Decimal, getcontext


def load_names(filename, dct, value):
    if not os.path.isfile(filename):
        return
    with codecs.open(filename, 'r', 'utf8') as f:
        for line in f:
            dct[line.strip()] = value


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--results', '-r', required=True)
    parser.add_argument('--date', '-d', default=None)
    parser.add_argument('--data_for_join', '-dj', required=True)
    args = parser.parse_args()

    try:
        datetime.datetime.strptime(args.date, '%Y-%m-%d')
    except (TypeError, ValueError):
        args.date = datetime.date.today().strftime('%Y-%m-%d')

    print('Current datetime is {}'.format(datetime.datetime.now()))
    print('Date is {}'.format(args.date))

    obj = json.load(open(args.data_for_join))
    url_to_host = {
        x: obj[x]['host'] for x in obj
    }
    host_to_category = {
        obj[x]['host']: obj[x]['type'] for x in obj
    }

    c = Counter()

    with codecs.open(args.results, 'r', 'utf8') as f:
        for line in f:
            tabs = line.strip().split('\t')
            if tabs[0] not in url_to_host:
                continue
            host = url_to_host[tabs[0]]
            if host not in host_to_category:
                continue
            category = host_to_category[host]
            status = tabs[-1]
            c[(category, host, status)] += 1
            c[(category, '_total_', status)] += 1
            c[('_total_', '_total_', status)] += 1
            c[('_total_', host, status)] += 1

    sums = {}

    percents = {}

    for tup in c:
        cathost = (tup[0], tup[1])
        if cathost not in sums:
            sums[cathost] = sum(
                c[x] for x in c if x[0] == tup[0] and x[1] == tup[1]
            )
        percents[tup] = round(c[tup] / sums[cathost], 4)

    recs = []

    for tab in c:
        category, host, status = tab
        recs.append(dict(
            fielddate=args.date,
            status=status,
            host=host,
            category=category,
            value=c[tab],
            share=percents[tab]
        ))
        print(
            'category: {}, host: {}, status: {}, value: {}'.format(
                category, host, status, c[tab]
            ))

    client = ns.StatfaceClient(
        proxy='upload.stat.yandex-team.ru',
        username='robot_ensuetina',
        password='woh8Ahshae'
    )

    report = ns.StatfaceReport().path(
        'Video/Others/SBR_by_host'
    ).scale('daily').client(
        client
    ).data(
        recs
    ).publish()

    print('Pushed to stat')


if __name__ == "__main__":
    main()
