#!/usr/bin/env python
# -*- coding: utf-8 -*-
# from __future__ import unicode_literals
from __future__ import division
import sys
import os
import codecs
import random
import argparse
from collections import defaultdict, Counter
import math
import json

from nile.api.v1 import (
    statface as ns,
    # Record
)
import getpass
import datetime
from decimal import Decimal, getcontext


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--results_desktop', '-r', required=True)
    parser.add_argument('--date', '-d')
    parser.add_argument('--basket', '-b', required=True)
    args = parser.parse_args()

    try:
        datetime.datetime.strptime(args.date, '%Y-%m-%d')
    except (TypeError, ValueError):
        args.date = datetime.date.today().strftime('%Y-%m-%d')

    c = Counter()

    with codecs.open(args.results_desktop, 'r', 'utf8') as f:
        for line in f:
            tabs = line.strip().split('\t')
            c[tabs[-1]] += 1

    recs = []

    for d in c:
        recs.append(dict(
            fielddate=args.date,
            status=d,
            basket=args.basket,
            value_desktop=c[d],
        ))

    client = ns.StatfaceClient(
        proxy='upload.stat.yandex-team.ru',
        username='robot_ensuetina',
        password='woh8Ahshae'
    )

    report = ns.StatfaceReport().path(
        'Video/Others/SBR'
    ).scale('daily').client(
        client
    ).data(
        recs
    ).publish()


if __name__ == "__main__":
    main()
