#!/usr/bin/env python
# -*- coding: utf-8 -*-
from __future__ import unicode_literals
from __future__ import division
import sys
import os
import codecs
import argparse
import json


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('original_statuses')
    parser.add_argument('new_statuses')
    parser.add_argument('correspondence')
    parser.add_argument('tsv_out')
    args = parser.parse_args()

    corr = json.load(open(args.correspondence))
    reverse_corr = {v: k for k, v in corr.items()}

    url_to_status = {}

    with codecs.open(args.new_statuses, 'r', 'utf8') as f:
        for line in f:
            tabs = line.strip().split('\t')
            if tabs[0] in reverse_corr:
                url_to_status[reverse_corr[tabs[0]]] = tabs[-1]

    with codecs.open(args.original_statuses, 'r', 'utf8') as i, \
                codecs.open(args.tsv_out, 'w', 'utf8') as o:
            for line in i:
                tabs = line.strip().split('\t')
                if tabs[0] in url_to_status:
                    tabs[-1] = url_to_status[tabs[0]]
                    o.write('\t'.join(tabs) + '\n')
                else:
                    o.write(line)


if __name__ == "__main__":
    main()
