#!/usr/bin/env python
# -*- coding: utf-8 -*-
from __future__ import unicode_literals
from __future__ import division
import sys
import os
import codecs
import argparse


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('input')
    parser.add_argument('output_true')
    parser.add_argument('output_false')
    parser.add_argument('output_false_full')
    parser.add_argument('output_false2')
    args = parser.parse_args()

    with codecs.open(args.input, 'r', 'utf8') as i, \
            codecs.open(args.output_true, 'w', 'utf8') as ot, \
            codecs.open(args.output_false, 'w', 'utf8') as of, \
            codecs.open(args.output_false_full, 'w', 'utf8') as off, \
            codecs.open(args.output_false2, 'w', 'utf8') as of2:
        for line in i:
            tabs = line.strip().split('\t')
            if tabs[-1].startswith(('SEARCHABLE', 'DELETED')):
                ot.write(line)
            else:
                of.write('\t'.join(tabs[:3]) + '\n')
                off.write(line)
                of2.write(tabs[0] + '\n')


if __name__ == "__main__":
    main()
