pragma yt.Pool = "@pool";
pragma yt.PoolTrees = "physical";
pragma yt.UseDefaultTentativePoolTrees;

$tmp_table = "@tmp_table";
$additive_table = "@additive_table";
$publish_table = "@publish_table";
$publish_table_last_date = "@publish_table_last_date";
$threshold = "@date_threshold";
$date_to = "@date_to";
$last_date_table = $additive_table || "_last_date";

$step1_tmp = (
    select
        page_url,
        frame_url,
        AsStruct(
            fielddate as fielddate,
            count(distinct user_id) as users,
            sum(shows) as shows,
            sum(view_time) as tvt,
            sum(lvt) as lvt,
            avg(view_time) as avg_vt
        ) as data_struct,
        AsStruct(
            some(duration) as duration,
            page_url as page_url,
            frame_url as frame_url
        ) as static_data
    from $tmp_table
    group by page_url, frame_url, fielddate
);

$step1_additive = (
    select
        page_url,
        frame_url,
        static_data,
        data as data_struct
    from $additive_table
    flatten by data
);

$step1_union = (
    select * from $step1_tmp
    union all
    select * from $step1_additive
    where data_struct.fielddate >= $threshold
);

$lenCheck = ($p, $f) -> ((length($p) ?? 0) + (length($f) ?? 0) <= 4000);

$static_data_type = Struct<
    page_url: String?,
    frame_url: String?,
    duration: Double?
>;

$data_struct_type = Struct<
    fielddate: String?,
    users: Int64?,
    shows: Int64?,
    tvt: Double?,
    lvt: Double?,
    avg_vt: Double?
>;

$py = @@
from yt import yson

def process_struct(stru):
    dct = {}
    for k in ["users", "tvt", "lvt", "avg_vt"]:
        dct[k] = getattr(stru, k) or 0
        dct["shows"] = dct["users"]
    return dct
    
def convert_data(lst):
    return yson.dumps({
        x.fielddate: process_struct(x) for x in lst
    })
    
def convert_static_data(stru):
    dct = {}
    for k in ["page_url", "frame_url", "duration"]:
        dct[k] = getattr(stru, k) or (0 if k == "duration" else "")
    return yson.dumps(dct)
@@;

$convert_data = Python::convert_data(
    Callable<(List<$data_struct_type>)->Yson?>, $py
);

$convert_static_data = Python::convert_static_data(
    Callable<($static_data_type)->Yson?>, $py
);

$step2 = (
    select
        page_url,
        frame_url,
        AGGREGATE_LIST(data_struct) as data,
        SOME(static_data) as static_data
    from $step1_union
    where $lenCheck(page_url, frame_url)
    group by page_url, frame_url
);

insert into $additive_table WITH TRUNCATE
select * from $step2;

insert into $publish_table WITH TRUNCATE 
select
    page_url,
    frame_url,
    $convert_data(data) as data,
    $convert_static_data(static_data) as static_data
from $step2;

insert into $last_date_table WITH TRUNCATE
select $date_to as last_date;

insert into $publish_table_last_date WITH TRUNCATE
select $date_to as last_date;
