pragma yt.Pool = "@pool";
pragma yt.PoolTrees = "physical";
pragma yt.UseDefaultTentativePoolTrees;
pragma SimpleColumns;
pragma yt.DefaultMemoryLimit = "6G";
pragma yt.MaxJobCount = "25000";
pragma yson.DisableStrict;

$output_table = "@output_table";
$date_from = "@date_from";
$date_to = "@date_to";

$countLvt = ($view_time) -> {
    RETURN IF(
        $view_time < 25, 0, Math::Log($view_time)
    )
};

$extract_video_info_old = ($inner_list_elem, $url) -> {
    $list2 = Yson::ConvertToList($inner_list_elem);
    $guid = Yson::ConvertToString($list2[0]) ?? "";
    $cor = IF(Length($guid) > 1, 0, -1);
    $view_time = Yson::ConvertToDouble($list2[5 + $cor]) ?? 0.0;
    $duration = Yson::ConvertToDouble($list2[4 + $cor]) ?? 0.0;
    $frame_url = Yson::ConvertToString($list2[11 + $cor]) ?? "";
    $frame_url = IF(Length($frame_url) > 0, $frame_url, $url);
    RETURN AsStruct(
        $url as page_url,
        $frame_url as frame_url,
        $guid as guid,
        $duration as duration,
        $view_time as view_time
    )
};

$process_list_elem_old = ($elem) -> {
    $elem = Yson::ConvertToDict($elem);
    $video_infos = ListFlatMap(
        DictKeys($elem),
        ($url) -> {
            RETURN ListMap(
                Yson::ConvertToList(Yson::YPath($elem[$url], "/p")),
                ($x) -> {
                    RETURN $extract_video_info_old(
                        $x,
                        $url
                    )
                }
            )
        }
    );
    RETURN $video_infos
};

$extract_video_info_new = ($inner_list_elem, $url) -> {
    $guid = Yson::LookupString($inner_list_elem, "uid") ?? "";
    $view_time = Yson::LookupDouble(
        $inner_list_elem, "total_played_duration"
    ) ?? 0.0;
    $duration = Yson::LookupDouble($inner_list_elem, "duration") ?? 0.0;
    $frame_url_candidate = Yson::LookupString(
        $inner_list_elem, "frame_url"
    );
    $frame_url = IF(
        $frame_url_candidate IS NOT NULL,
        $frame_url_candidate,
        $url
    );
    RETURN AsStruct(
        $url as page_url,
        $frame_url as frame_url,
        $guid as guid,
        $duration as duration,
        $view_time as view_time
    )
};

$process_list_elem_new = ($elem) -> {
    $elem = Yson::ConvertToDict($elem);
    $url = Yson::ConvertToString($elem["url"]);
    RETURN ListMap(
        Yson::ConvertToList($elem["data"]),
        ($x) -> {RETURN $extract_video_info_new($x, $url)}
    )
};

$parseVc = ($decoded_vc, $function) -> {
    $parsed_vc = Yson::ParseJson($decoded_vc);
    $list = Yson::ConvertToList($parsed_vc);
    $processed = ListFlatMap($list, $function);
    RETURN $processed
};

$parseVcOld = ($decoded_vc) -> {
    RETURN $parseVc($decoded_vc, $process_list_elem_old)
};

$parseVcNew = ($decoded_vc) -> {
    RETURN $parseVc($decoded_vc, $process_list_elem_new)
};

$version_filter = ($version) -> {
    $version = ListMap(
        String::SplitToList($version, "."), ($x) -> {RETURN CAST($x AS Int32)}
    );
    $version = ListTake($version, 3);
    RETURN IF($version < AsList(72, 0, 3626), 1, 2)
};

$ensureParsing = ($s) -> {
    RETURN IF($s LIKE "?%", $s, "?" || $s)
};

-- pragma yt.DataSizePerJob = "512M";
$step1 = (
    select 
        IF(
            $version_filter(Url::GetCGIParam($ensureParsing(http_params), "ver")) == 1,
            $parseVcOld(Url::Decode(Url::GetCGIParam($ensureParsing(http_params), "decoded_vc"))),
            $parseVcNew(Url::Decode(Url::GetCGIParam($ensureParsing(http_params), "decoded_vc")))
        ) as parsed_vc,
        yandexuid as user_id,
        ListReverse(String::SplitToList(TablePath(), "/"))[0] as fielddate
    from RANGE(`//logs/bar-navig-log/1d`, $date_from, $date_to)
    where http_params like '%decoded_vc=%'
    and yandexuid is not null
    and yandexuid != "-"
);

$step2 = (
    select
        user_id,
        parsed_vc,
        fielddate
    from $step1
    flatten by parsed_vc
);

pragma yt.DefaultMemoryLimit = "2G";

$step3 = (
    select
        fielddate,
        user_id,
        parsed_vc.guid as guid,
        parsed_vc.duration as duration,
        parsed_vc.view_time as view_time,
        VideoCanonLib::CanonizeUrl(
            Url::Normalize(parsed_vc.page_url ?? "")
        ) as page_url,
        VideoCanonLib::CanonizeContentUrl(Url::Normalize(
            parsed_vc.frame_url
        )) ?? "" as frame_url
    from $step2
    where (parsed_vc.page_url ?? "") NOT LIKE "%//yandex.ru/video%"
    and (parsed_vc.frame_url ?? "") NOT LIKE "%//yandex.ru/video%"
    and (parsed_vc.page_url ?? "") LIKE "http%"
    and parsed_vc.view_time > 0
);
pragma yt.DataSizePerJob = "1G";

$step4_noguid = (
    select
        fielddate,
        user_id,
        duration,
        view_time,
        $countLvt(view_time) as lvt,
        page_url,
        frame_url
    from $step3
    where guid is null
);

$step4_guid = (
    select
        fielddate,
        user_id,
        SOME(page_url) as page_url,
        SOME(frame_url) as frame_url,
        MAX(view_time) as view_time,
        $countLvt(MAX(view_time)) as lvt,
        SOME(duration) as duration
    from $step3
    where guid is not null
    group by fielddate, user_id, guid
);

$preliminary = (
    select * from $step4_noguid
    union all
    select * from $step4_guid
);
