pragma yt.Pool = "@pool";
pragma yt.PoolTrees = "physical";
pragma yt.UseDefaultTentativePoolTrees;
pragma SimpleColumns;
pragma yt.DefaultMemoryLimit = "2G";
pragma yt.MaxJobCount = "25000";
pragma yson.DisableStrict;

$output_table = "@output_table";
$date_from = "@date_from";
$date_to = "@date_to";

$getData = ($json) -> {
    $parsed = Yson::ParseJson($json);
    $page_url = Yson::LookupString($parsed, "page url");
    $frame_url = Yson::LookupString($parsed, "frame url");
    $viewtime = CAST(Yson::LookupString($parsed, "play length") AS Double);
    $duration = CAST(Yson::LookupString($parsed, "length") AS Double);
    $lvt = IF($viewtime < 30, 0, Math::Log($viewtime));
    RETURN AsStruct(
        $page_url as page_url,
        $frame_url as frame_url,
        $viewtime as view_time,
        $duration as duration,
        $lvt as lvt
    )
};

$step1 = (
    select
        ListReverse(String::SplitToList(TablePath(), "/"))[0] as fielddate,
        $getData(EventValue) as get_data,
        DeviceID,
        EventValue
    from RANGE(
        `//home/logfeller/logs/browser-metrika-mobile-log/1d`,
        `@date_from`,
        `@date_to`
    )
    where EventName == 'video statistics'
    union all
    select
        ListReverse(String::SplitToList(TablePath(), "/"))[0] as fielddate,
        $getData(EventValue) as get_data,
        DeviceID,
        EventValue
    from RANGE(
        `//home/logfeller/logs/superapp-metrika-mobile-log/1d`,
        `@date_from`,
        `@date_to`
    )
    where EventName == 'video statistics'
);

$preliminary = (
    select
        fielddate,
        VideoCanonLib::CanonizeUrl(
            Url::Normalize(get_data.page_url ?? "")
        ) as page_url,
        VideoCanonLib::CanonizeContentUrl(
            Url::Normalize(get_data.frame_url ?? "")
        ) as frame_url,
        get_data.duration as duration,
        get_data.view_time as view_time,
        get_data.lvt as lvt,
        DeviceID as user_id
    from $step1
    where get_data.page_url LIKE "http%"
);
