#!/usr/bin/env python
# -*- coding: utf-8 -*-
from __future__ import unicode_literals
import sys
import argparse

try:
    import pyperclip
except ImportError:
    pyperclip = False


stub = """\
  {}:
    type: Selector
    default: _total_
"""


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument("dimensions")
    parser.add_argument("--mode", default="clipboard")
    args = parser.parse_args()

    if args.mode == "clipboard" and not pyperclip:
        sys.stderr.write(
            "pyperclip is not installed/available, unable to use clipboard,\n"
            "will use stdout instead\n\n"
        )
        args.mode = "stdout"

    dimensions = args.dimensions.split(",")
    result = "view_types:\n"

    for dim in dimensions:
        result += stub.format(dim)

    if args.mode == "clipboard":
        try:
            pyperclip.copy(result)
        except pyperclip.PyperclipException:
            print(result)
    else:
        print(result)


if __name__ == "__main__":
    main()
