pragma AnsiInForEmptyOrNullableItemsCollections;
pragma library("get_ugc_meta.sql");
import get_ugc_meta symbols $_get_ugc_meta;

$base_table = "home/videoquality/strm_meta/base/ContentGroup";
$resource_table = "home/videoquality/strm_meta/base/ContentResource";
$content_type_table = "home/video-hosting/base/ContentType";
$tags_data_table = "home/video-hosting/adv_tags/tags_data";
$old_ugc_table = "home/videoquality/strm_meta/old_ugc";
-- $ugc_table = "//home/video-hosting/ugc_replica/ugc_video_prod";
$root = "@root/";
$acg_table = $root || "active_cgs";
$ontoids_table = $root || "onto_ids_data";
$current_table = $root || "current";
$output_table = $root || "concat";
$content_attribution_table = $root || "content_attribution";
$current_ts = @[current_ts];


$channel_data_table = "@[channel_data_table]";
$meta_data_table = "@[meta_data_table]";
$file_data_table = "@[file_data_table]";
$prod_data_table = "@[prod_data_table]";

define subquery $get_ugc_meta() as
select * from $_get_ugc_meta(
    $channel_data_table,
    $meta_data_table,
    $file_data_table
);
end define;


define subquery $get_ugc_content() as
$video_prod = (
    select
        `video.id`,
        categories
    from $prod_data_table
);

$w = ($x) -> {
    $x = String::Strip($x);
    return IF($x = "", null, $x)
};

$tmp = (
    select
        video_content_id as `UUID`,
        video_id as ugc_id,
        `video_title` as Name,
        IF(video_stream_id is not null, "UGCLive.", "") || `video_title` as computed_program,
        service as ugc_service,
        moderation_info,
        moderation_status,
        Yson::SerializeJson(Yson::YPath(Yson::ParseJson(moderation_info), "/effective_verdicts")) as effective_verdicts,
        owner_id as ugc_owner_id,
        case
        when ugc_yt_imported then "Youtube."
        when o.ugc_channel_id is not null then "UGC."
        when channel_service = "zen_cinema" then "Zen."
        else "UGC."
        end || ($w(publisherName) ?? $w(channel_name) ?? "-") as computed_channel,
        channel_id as ugc_channel_id,
        channel_service as ugc_channel_service,
        video_duration as duration,
        deleted,
        cast(video_release_date as String) as release_date,
        video_create_time as CreateTime,
        video_update_time as UpdateTime,
        live_start_time,
        live_finish_time,
        -- `categories` as ugc_categories,
        page_id,
        publisherId,
        publisherName,
        agencyId,
        agencyName,
        itemId,
        sourceId,
        isVideoShort,
        is_native_ad
    from $get_ugc_meta() as m
    left join any $old_ugc_table as o on (m.channel_id = o.ugc_channel_id)
);

$joined = (
    select
        t.*,
        categories as ugc_categories
    from $tmp as t
    left join $video_prod as vp on (t.ugc_id == vp.`video.id`)
);

select t.*, `UUID` as JoinKey from $joined as t
union all
select t.*, CAST(ugc_id as String) as JoinKey from $joined as t
end define;

/*ugc_debug
insert into `@[ugc_debug_table]` with truncate
select * from $get_ugc_content();
ugc_debug*/

$ct_map = (
    SELECT ToDict(
        AGGREGATE_LIST(
            AsTuple(ContentTypeID, Name)
        )
    )
    from $content_type_table
);

$list_lookup = ($list, $key) -> {
    $filtered = ListNotNull(ListMap(
        $list, ($x) -> {RETURN IF($x.ResourceName == $key, $x.Value, NULL)}
    ));
    RETURN IF(
        ListLength($filtered) > 0, $filtered[0], NULL
    )
};

$resources_for_join_1 = (
    SELECT ContentGroupID, AGGREGATE_LIST(AsStruct(
        ResourceName as ResourceName,
        Value as Value
    )) as values_list
    from $resource_table
    where ResourceName in (
        "parent_channel_uuid",
        "program_title",
        "original_uuid",
        "channel_type",
        "project_alias",
        "start_time",
        "finish_time",
        "page_id",
        "duration",
        -- "detailed_tags",
        "tags",
        "title_full_computed_name",
        "commercial_category",
        "channel_category",
        "release_date",
        "use_ad_session",
        "green_url",
        "auto_fields"
    )
    group by ContentGroupID
);

$resources_for_join = (
    SELECT
        ContentGroupID,
        $list_lookup(values_list, "parent_channel_uuid") as parent_channel_uuid,
        $list_lookup(values_list, "program_title") as program_title,
        $list_lookup(values_list, "title_full_computed_name") as title_full_computed_name,
        $list_lookup(values_list, "original_uuid") as original_uuid,
        $list_lookup(values_list, "channel_type") as channel_type,
        $list_lookup(values_list, "commercial_category") as commercial_category,
        $list_lookup(values_list, "channel_category") as channel_category,
        $list_lookup(values_list, "project_alias") as project_alias,
        $list_lookup(values_list, "green_url") as green_url,
        $list_lookup(values_list, "release_date") as release_date,
        $list_lookup(values_list, "use_ad_session") as use_ad_session,
        cast($list_lookup(values_list, "start_time") as Int64) as start_time,
        cast($list_lookup(values_list, "finish_time") as Int64) as finish_time,
        $list_lookup(values_list, "page_id") as page_id,
        cast($list_lookup(values_list, "duration") as Int64) as duration,
        -- $list_lookup(values_list, "detailed_tags") as detailed_tags,
        $list_lookup(values_list, "tags") as tags,
        $list_lookup(values_list, "auto_fields") as auto_fields
    from $resources_for_join_1
);

$getLicense = ($struct) -> {
    $exact = CASE
    WHEN $struct.AvodEndDate >= $current_ts THEN "Avod"
    WHEN $struct.SvodEndDate >= $current_ts THEN "Svod"
    WHEN $struct.TvodEndDate >= $current_ts THEN "Tvod"
    WHEN $struct.EstEndDate >= $current_ts THEN "Est"
    ELSE NULL
    END;
    $old = IF(
        $exact is not null and $exact in ("Tvod", "Est"),
        "Tvod_Est",
        $exact
    );
    RETURN AsTuple($old, $exact)
};

$getServiceFlags = ($attrs) -> {
    $flags = ListSort(
        ListMap(ListFilter(
            $attrs, ($x)->($x.Name == "service_flag")
        ), ($x)->($x.Value))
    );
    return ToBytes(Yson::SerializeJson(Yson::From($flags)))
};

$direct_index = (
    SELECT 
        omniData.VhUuid as `UUID`,
        $getLicense(omniData.License).0 as license,
        $getLicense(omniData.License).1 as license_exact,
        mediainfo.Author.Host == "www.youtube.com" as is_yt_direct_index,
        ToBytes(
            Yson::SerializeJson(Yson::From(
                ListNotNull(ListMap(mediainfo.OvsDetailedTags, ($x)->($x.Text)))
            ))
        ) as detailed_tags,
        $getServiceFlags(searchAttrs.SearchAttrs) as TMP_OvsServiceFlags
    from `//home/videoindex/vhs/docbase/dynamic/direct_index`
);

$collect_path = ($chain) -> {
    $list = ListMap($chain, ($x) -> {RETURN CAST($x.ContentTypeID AS String)});
    RETURN String::JoinFromList($list, ",")
};


$make_hr_path = ($chain) -> {
    $hr_list = ListMap(
        $chain, ($x) -> {RETURN DictLookup($ct_map, $x.ContentTypeID) ?? "unknown"}
    );
    RETURN String::JoinFromList($hr_list, ",")
};

$special_type_to_prefix = AsDict(
    AsTuple("yatv", "Яндекс."),
    AsTuple("special_project", "Спецпроекты."),
    AsTuple("youtube", "Youtube."),
    AsTuple("yandex_originals", "YandexOriginals.")
);

$searchForChannel = ($chain) -> {
    $rev = ListReverse($chain);
    $strong = ListFilter(
        $rev,
        ($x) -> {RETURN ($ct_map[$x.ContentTypeID] ?? "") in ("channel", "ntv-vod-library")}
    );
    $weak = ListFilter(
        $rev,
        ($x) -> {RETURN ($ct_map[$x.ContentTypeID] ?? "") in ("type-folder", "vod-broadcast")}
    );
    $special_types = ListNotNull(ListMap($rev, ($x) -> {RETURN $x.special_type}));
    $prefix = IF(ListLength($special_types) > 0, $special_type_to_prefix[$special_types[0]] ?? "", "");
    RETURN CASE
    WHEN ListLength($strong) > 0 THEN $prefix || $strong[0].Name
    WHEN ListLength($weak) > 0 THEN $prefix || $weak[0].Name
    ELSE NULL
    END
};

$searchForProgram = ($chain) -> {
    $filtered  = ListFilter(
        ListReverse($chain),
        ($x) -> {
            RETURN ($ct_map[$x.ContentTypeID] ?? "") in (
                "episode",
                "zen-episode",
                "vod-library",
                "ntv-vod-series",
                "tv-series",
                "ott-trailer",
                "ott-movie",
                "ntv-vod-movie",
                "yandex-market-library",
                "high-light",
                "zen-namespace",
                "vod-broadcast-episode"
            )
        }
    );
    RETURN $filtered[0].Name
};

$getComputedChannel = ($chain, $path, $parent_chain, $yt_patch) -> {
    $ch = CASE
    WHEN $path LIKE "%music-clip%" THEN "# MUSIC CLIPS"
    WHEN $path LIKE "%ott-%" THEN "ott"
    WHEN $path LIKE "%ya-news%" THEN "ya-news"
    WHEN $path LIKE "%zen-%" THEN "zen"
    WHEN ($parent_chain IS NOT NULL AND $searchForChannel($parent_chain) IS NOT NULL) THEN $searchForChannel($parent_chain)
    WHEN $searchForChannel($chain) IS NOT NULL THEN $searchForChannel($chain)
    ELSE ListReverse($chain)[1].Name
    END;
    $is_highlight = "highlights" in ListMap($chain, ($x)->($x.Name));
    return case
    when $yt_patch and $ch not like "Youtube.%" then "Youtube." || $ch
    when $is_highlight then "ContentModified." || $ch
    else $ch
    end
};

$getComputedProgram = ($chain) -> {
    RETURN CASE
    WHEN $searchForProgram($chain) IS NOT NULL THEN $searchForProgram($chain)
    ELSE ListReverse($chain)[0].Name
    END
};

$getHeurCategory = ($path) -> {
    RETURN CASE
    WHEN $path like "%vod%" THEN "vod"
    WHEN $path like "%ott%" THEN "vod"
    WHEN $path like "%music-clip%" THEN "vod"
    WHEN $path like "%kp-trailer%" THEN "vod"
    WHEN $path like "%yandex-market%" THEN "vod"
    WHEN $path like "%yandex-disribution%" THEN "vod"
    ELSE "live_or_catchup"
    END
};

$joined = (
    SELECT
        parent_channel_uuid,
        CreateTime,
        channel_type,
        project_alias,
        start_time,
        finish_time,
        page_id,
        license,
        license_exact,
        duration,
        detailed_tags,
        green_url,
        auto_fields,
        tags,
        onto_id,
        onto_tags,
        onto_type,
        commercial_category,
        original_uuid,
        channel_category,
        release_date,
        title_full_computed_name,
        program_title,
        use_ad_session,
        di.TMP_OvsServiceFlags ?? "[]" as TMP_OvsServiceFlags,
        $collect_path(chain) as path,
        $make_hr_path(chain) as hr_path,
        $getHeurCategory($make_hr_path(chain)) as heur_category,
        ListHas(ListExtract(chain, "OptionsDeleted"), true) as deleted,
        ContentGenres,
        ContentCategories,
        BrandSafetyTags,
        is_yt_direct_index,
        c.*
    from $current_table as c
    left join $resources_for_join as r
    on (c.ContentGroupID == r.ContentGroupID)
    left join $ontoids_table as o
    on (c.ContentGroupID == o.ContentGroupID)
    left join $acg_table as acg
    on (c.ContentGroupID == acg.ContentGroupID)
    left join $direct_index as di
    on (c.`UUID` == di.`UUID`)
    left join $base_table as b
    on (c.ContentGroupID == b.ContentGroupID)
    left join $tags_data_table as td
    on (c.`UUID` == td.`UUID`)
);

$ugc_join = (
    select u.*,
        di.TMP_OvsServiceFlags ?? "[]" as TMP_OvsServiceFlags,
        detailed_tags,
        license,
        license_exact,
    from $get_ugc_content() as u
    left join $direct_index as di
    on (u.`UUID` == di.`UUID`)
);

$parents_map = (
    SELECT
        path as parent_path,
        hr_path as parent_hr_path,
        chain as parent_chain,
        `UUID` as parent_channel_uuid
    from $joined
    where parent_channel_uuid is not null
);

$addCTName = ($chain) -> {
    RETURN ListMap($chain, ($x) -> {
        RETURN AddMember(
            $x,
            "content_type_id_name",
            $ct_map[$x.ContentTypeID] ?? "unknown"
        )
    })
};

$ysonify = ($x) -> {
    RETURN Yson::Serialize(Yson::From($x))
};

$joined2 = (
    SELECT
        parent_path,
        parent_hr_path,
        $ysonify(parent_chain) as parent_chain,
        IF(parent_path is not null, path || "+" || parent_path, path) as path_unified,
        IF(parent_hr_path is not null, hr_path || "+" || parent_hr_path, hr_path) as hr_path_unified,
        $getComputedChannel(chain, hr_path, parent_chain, is_yt_direct_index) as computed_channel,
        $getComputedProgram(chain) as computed_program,
        $ysonify($addCTName(chain)) as chain,
        c.* without c.chain
    from $joined as c
    left join $parents_map as p using (parent_channel_uuid)
);

$concat = (
    select CAST(ContentGroupID as String) as JoinKey, c.* from $joined2 as c
    union all
    select `UUID` as JoinKey, c.* from $joined2 as c
    union all
    select * from $ugc_join
);

$getChannel = ($chain) -> {
    $chain = ListReverse(Yson::ConvertToList($chain));
    $channels = ListFilter($chain, ($x)->(Yson::LookupInt64($x, "ContentTypeID") == 2));
    return AsTuple(
        Yson::LookupUint64($channels[0], "ContentGroupID"),
        Yson::LookupString($channels[0], "Name"),
        Yson::LookupString($chain[0], "Name"),
        Yson::LookupString($chain[0], "content_type_id_name"),
    )
};

$channel_ids = (
    select distinct channel_id
    from (
        select $getChannel(chain).0 as channel_id
        from $concat
        where green_url is not null and $getChannel(chain).0 is not null
    )
);

$wrap_channel = ($channel, $path, $chain) -> {
    $parent_uuid = Yson::LookupString(ListReverse(Yson::ConvertToList($chain))[1], "UUID");
    RETURN CASE
        WHEN (
            String::StartsWith($channel, "UGC.")
            or String::StartsWith($channel, "Youtube.")
            or String::StartsWith($channel, "Zen.")
        ) THEN "bloggers"
        WHEN String::StartsWith($channel, "YandexOriginals.") or $channel = "Просто о сложном с Софико Шеварднадзе" THEN "originals" -- собственные шоу яндекса
        WHEN String::StartsWith($channel, "Яндекс.") then "yandex_channels"
        WHEN $channel = "ya-news" THEN "yanews"
        WHEN $getChannel($chain).0 in $channel_ids then "external_partner"
        WHEN $channel = "ott" and $parent_uuid in ("4bd70910dee2e0a0a4d960995c786334", "4f75ab2350acb20fb77c8014bdb4d3a9") THEN "ott.trailers"
        WHEN $channel = "ott" THEN "ott"
        WHEN $channel = "# MUSIC CLIPS" THEN "music"
        WHEN (
            $channel like "%НХЛ%"
            or $channel like "%NHL%"
            or $channel like "%ФНЛ%"
            or String::StartsWith($channel, "Спецпроекты.")
            or $path is not Null and ListHas(String::SplitToList($path, ","), "2")
        ) THEN "tv_nhl_fnl_special"
    ELSE 'other'
    END
};

$add_content_attribution = (
    select
        c.*, $wrap_channel(computed_channel, path, chain) as content_attribution
    from $concat as c
);

$content_attribution = (
    select
        JoinKey,
        unwrap(ListReverse(AGGREGATE_LIST(AsTuple(CreateTime, content_attribution)))[0].1) as content_attribution
    from $add_content_attribution
    group by JoinKey
);

insert into $output_table WITH TRUNCATE
select * from $add_content_attribution
order by JoinKey;

insert into $content_attribution_table WITH TRUNCATE
select * from $content_attribution
order by JoinKey;
