
$base_table = "home/videoquality/strm_meta/base/ContentGroup";
$root = "@root/";
$parents_table = $root || "parents";
$current_table = $root || "current";
$step_table_for_debug = $root || "@step";
$yatv_channels = $root || "yatv_channels";

$step = (
    SELECT
        b.ContentGroupID as ContentGroupID,
        `UUID`,
        UpdateTime,
        Name,
        special_type,
        ListExtend(p.chain, AsList(AsStruct(
            b.ContentGroupID as ContentGroupID,
            `UUID` as `UUID`,
            Name as Name,
            ParentID as ParentID,
            ContentTypeID as ContentTypeID,
            ListHas(
                ListFlatMap(
                    Yson::ConvertToList(Yson::ParseJson(Options)),
                    ($x) -> {RETURN Yson::ConvertToString($x)}
                ), "deleted"
            ) as OptionsDeleted,
            special_type as special_type
        ))) as chain
    from $base_table as b
    inner join $parents_table as p on (b.ParentID == p.ContentGroupID)
    left join $yatv_channels as y on (b.ContentGroupID == y.ContentGroupID)
);

insert into $parents_table WITH TRUNCATE 
select ContentGroupID, chain from $step;

$concat = (
    select * from $step
    union all
    select * from $current_table
);

insert into $current_table WITH TRUNCATE 
select * from $concat;

insert into $step_table_for_debug WITH TRUNCATE 
select * from $concat;