from yt import yson

BAD_FIELDS = {
    "count",
    "index",
    "n_fields",
    "n_unnamed_fields",
    "n_sequence_fields",
}


def convert_struct(ys):
    attrs = dir(ys)
    return {
        k: getattr(ys, k)
        for k in attrs
        if not k.startswith("__") and k not in BAD_FIELDS
    }


def wrap_rec(obj):
    if "yql.Struct" in str(type(obj)):
        return wrap_rec(convert_struct(obj))
    if isinstance(obj, bytes):
        return obj.decode("utf8", errors="replace")
    if isinstance(obj, dict):
        return {wrap_rec(k): wrap_rec(v) for k, v in obj.items()}
    if isinstance(obj, list):
        return [wrap_rec(x) for x in obj]
    return obj


def make_yson(obj):
    if not obj:
        return
    return yson.dumps([wrap_rec(x) for x in obj])
