use hahn;
pragma AnsiInForEmptyOrNullableItemsCollections;
pragma yt.DefaultMaxJobFails = "1";
pragma yson.DisableStrict;
pragma DqEngine = "disable";

$output_table = "//home/strm/vh_analytics/staff_data_public/clickhouse_counters";

$table_paths = (
    SELECT AGGREGATE_LIST(Path)
    FROM FOLDER("//home/strm/vh_analytics/staff_data_private", "schema;row_count")
    WHERE
        Type = "table"
        AND Yson::LookupInt64(Attributes, "row_count") > 0
        AND (FIND(Path, $date) is not null or FIND(Path, $date_weekago) is not null)
);

$getIdentifier = ($s) -> {
    $s = ListLast(String::SplitToList($s, "/"));
    $s = String::SplitToList($s, "_");
    $s = ListSkip($s, 1);
    return String::JoinFromList($s, "_")
};

$select = (
    select s.*, $getIdentifier(TablePath()) as user_action
    from each($table_paths) as s
);


$staff_data = (
    select
        login,
        String::SplitToList(department_grouping, ";") as department_grouping,
        position_grouping,
        management_level
    from `//home/strm/vh_analytics/staff_data_private/staff_data`
);


$join_ = (
    select f.*, department_grouping,
            position_grouping,
            management_level
    from $select as f
    left join any $staff_data as s on (
        f.login = s.login
    )
);
$join_1 = (
    select
        ListExtend(department_grouping, ["_total_"]) as department_grouping,
        [position_grouping, "_total_"] as position_grouping,
        [management_level, 999] as management_level,
        s.* without department_grouping, position_grouping, management_level
    from $join_ as s
    where management_level is not null
);
$joined = select * from $join_1 flatten list by (department_grouping, position_grouping, management_level);

$grouped = (
    (select
        fielddate,
        department_grouping,
        position_grouping,
        management_level,
        user_action,
        count(distinct login) as `count`
    from $joined
    group by fielddate,
        department_grouping,
        position_grouping,
        management_level,
        user_action ?? "-" as user_action
    )
    union all
    (select
        fielddate,
        department_grouping,
        position_grouping,
        management_level,
        "any_action" as user_action,
        count(distinct login) as `count`
    from $joined
    group by fielddate,
        department_grouping,
        position_grouping,
        management_level)
);

$fielddates = select distinct fielddate from $grouped;

$ch = (
    select * from $output_table
    where fielddate not in $fielddates
);

$union = (
    select * from $grouped union all select * from $ch
);

insert into $output_table with truncate
select * from $union
order by fielddate;
