use hahn;
pragma AnsiInForEmptyOrNullableItemsCollections;
pragma yt.DefaultMaxJobFails = "1";
pragma yson.DisableStrict;
pragma DqEngine = "disable";

$w = ($x) -> (IF($x = "", null, $x));

$fielddateFormat = DateTime::Format("%Y-%m-%d %H:%M:%S");
$getMin = ($ts) -> {
    $ts = CAST($ts as Int64);
    $ts = CAST(($ts / 60 * 60) as UInt32);
    $tm = AddTimezone(DateTime::FromSeconds($ts), "Europe/Moscow");
    RETURN $fielddateFormat($tm)
};

$tables = [
    "//logs/strm-gogol-log/1h/" || $date || "T11:00:00",
    "//logs/strm-gogol-log/1h/" || $date || "T12:00:00",
    "//logs/strm-gogol-log/1h/" || $date || "T13:00:00"
];

$vconfCheck = Re2::Grep("int_(bluewhale|vconf[0-9])");
$tsCheck = Re2::Grep(" (09|10|11|12)");

$filter = (
    select
        substring(TableName(), 0, 10) as fielddate,
        cast(clientTimestamp / 1000 as Uint64) as ts,
        $w(yandexuid) as yandexuid,
        $w(yandex_login) as login,
        streamUrl as stream_url
    from each($tables)
    where $tsCheck($getMin(clientTimestamp / 1000))
    and $vconfCheck(streamUrl)
    and $w(yandexuid) is not null
);

$session_length = 15 * 60;

$add_session_start = ($_, $rows) -> {
    return YQL::FoldMap(
        $rows,
        AsTuple(Nothing(Int64?), Nothing(Int64?)),
        ($row, $ts_state) -> {
            $first_ts = case
                when $ts_state.0 is null or $row.ts - $ts_state.1 > $session_length then $row.ts
                else $ts_state.0
            end;
            $prev_ts = cast($row.ts as Int64?);
            Return AsTuple(
                AddMember($row, "session_start_ts", $first_ts),
                AsTuple($first_ts, $prev_ts)
            )
        }
    )
};

$add_session_ts = (
    reduce $filter presort ts on yandexuid, stream_url USING $add_session_start(TableRow())
);

$grouped = (
    select
        yandexuid,
        stream_url,
        session_start_ts,
        some(fielddate) as fielddate,
        some(login) as login,
        min(ts) as unixtime_start,
        max(ts) as unixtime_finish
    from $add_session_ts
    group by yandexuid, stream_url, session_start_ts
);

insert into `//home/strm/vh_analytics/staff_data_private/by_login`
select * from $grouped;

$wrapLogin = ($login) -> {
    $login = cast(Unicode::ToLower(cast($login as Utf8)) as String);
    return IF($login = "", null, $login)
};
$makeUnixtime = ($fielddate, $hour) -> {
    $tzd = unwrap($fielddate || "T" || $hour || ":00,Europe/Moscow");
    return DateTime::ToSeconds(cast($tzd as TzDatetime))
};
$ts_intersect = ($ts1_start, $ts1_end, $ts2_start, $ts2_end) -> {
    $max_start = max_of($ts1_start, $ts2_start);
    $min_end = min_of($ts1_end, $ts2_end);
    return not ($max_start > $min_end)
};

$filter = (
    select
        fielddate,
        IF(
            unixtime_start < $makeUnixtime(fielddate, "12:00"),
            $makeUnixtime(fielddate, "12:00"),
            unixtime_start
        ) as unixtime_start,
        IF(
            unixtime_finish > $makeUnixtime(fielddate, "13:00"),
            $makeUnixtime(fielddate, "13:00"),
            unixtime_finish
        ) as unixtime_finish,
        $wrapLogin(login) as login,
        yandexuid
    from $grouped
    where stream_url like "%int_bluewhale%"
    and $ts_intersect(
        unixtime_start, unixtime_finish,
        $makeUnixtime(fielddate, "12:00"), $makeUnixtime(fielddate, "13:00")
    )
    and $wrapLogin(login) is not null
);


$staff_data = (
    select
        yandex_login,
        String::SplitToList(department_grouping, ";") as department_grouping,
        position_grouping,
        management_level
    from `//home/strm/vh_analytics/staff_data_private/staff_data`
);


$join_ = (
    select f.*, department_grouping,
            position_grouping,
            management_level
    from $filter as f
    left join any $staff_data as s on (
        f.login = s.yandex_login
    )
);
$joined = select * from $join_ where management_level is not null;
$not_joined = select s.* without department_grouping, position_grouping, management_level from $join_  as s where management_level is null;

$add_crypta = (
    select s.*, department_grouping,
            position_grouping,
            management_level
    from $not_joined as s
    inner join any `//home/crypta/public/matching/by_id/yandexuid/crypta_id` as cr on (
        s.yandexuid=cr.`id`
    )
    inner join any `//home/crypta/public/ids_storage/staff/crypta_id` as crstaff on (
        cr.target_id=crstaff.target_id
    )
    inner join any $staff_data as staff on (
        $wrapLogin(crstaff.target_id) = staff.yandex_login
    )
);
$join = select * from $joined union all select * from $add_crypta;

$by_date = (
    select
        fielddate,
        department_grouping,
        position_grouping,
        management_level,
        count(*) as `count`
    FROM (
        select
            fielddate, login,
            some(department_grouping) as department_grouping,
            some(position_grouping) as position_grouping,
            some(management_level) as management_level
        from $join
        flatten list by department_grouping
        group by fielddate, login
    )
    group by fielddate, department_grouping,
        position_grouping,
        management_level
);
insert into `//home/strm/vh_analytics/staff_data_public/by_date`
select * from $by_date
order by fielddate;

$minutes = ListMap(ListFromRange(0, 60), ($x)->("12:" || String::LeftPad(cast($x as String), 2, "0")));

$add_minutes = (
    select j.*, $minutes as minute
    from $join as j
);

$flatten = select * from $add_minutes flatten list by (minute, department_grouping);

$grouped = (
    select
        fielddate,
        minute,
        department_grouping,
        position_grouping,
        management_level,
        ListLength(aggregate_list_distinct(IF(
            unixtime_start <= $makeUnixtime(fielddate, minute)
            and $makeUnixtime(fielddate, minute) <= unixtime_finish,
            login
        ))) as users
    from $flatten
    group by fielddate,
        minute,
        department_grouping,
        position_grouping,
        management_level
);

insert into `//home/strm/vh_analytics/staff_data_public/by_minute`
select * from $grouped
order by fielddate, minute;
