#!/usr/bin/env python
# -*- coding: utf-8 -*-
import os
import argparse
import datetime
import yt.wrapper as yt
from yql.api.v1.client import YqlClient
from videolog_common import YqlRunner, get_date, date_range


ANNOUNCEMENT = """
use mtch;

SELECT arrayStringConcat(groupUniqArray(ParsedParams.Key2[1]), ',') as logins
FROM visits_all as v
WHERE StartDate >= toDate('{monday}') and StartDate <= toDate('{date}') and CounterID = 41246029 and ParsedParams.Key2[1] != '' and arrayExists(x_0 -> x_0 IN (SELECT WatchID AS `ym:pv:eventID`
FROM hits_all as h
WHERE EventDate >= toDate('{monday}') and EventDate <= toDate('{date}') and CounterID = 41246029 and NOT DontCountHits and NOT Refresh and URL LIKE '%{announcement}%'),`Event.ID`)
"""

KHURAL_VIEW = """
use mtch;

select arrayStringConcat(groupUniqArray(ParsedParams.Key2[1]), ',') as logins
from hits_all
where CounterID = 53950870
    and EventDate = '{date}'
    and ParsedParams.Key2[1] != ''
    and URL = 'https://vconf.yandex-team.ru/template/85/stream'
    and EventTime >= '{date} 11:00:00'
    and EventTime <= '{date} 13:10:00'
"""

KHURAL_CUT_READ = """
use mtch;

SELECT arrayStringConcat(groupUniqArray(ParsedParams.Key2[1]), ',') as login
FROM visits_all as v
WHERE StartDate >= toDate('{date_weekago}') and StartDate <= toDate('{date}') and CounterID = 41246029 and ParsedParams.Key2[1] != '' and arrayExists(x_0 -> x_0 IN (SELECT WatchID AS `ym:pv:eventID`
FROM hits_all as h
WHERE EventDate >= toDate('{date_weekago}') and EventDate <= toDate('{date}') and CounterID = 41246029 and NOT DontCountHits and NOT Refresh and URL LIKE '%{date_weekago_nodash}\\_khural%'),`Event.ID`)
"""

KHURALNAYA = """
use mtch;

SELECT
    arrayStringConcat(groupUniqArray(cast(CryptaID as String)), ', ') as cryptaIDs
from visits_all
where CounterID == 37738105
    and StartDate == toDate('{date}')
    and arrayElement(ParsedParams.Key2, indexOf(ParsedParams.Key1, 'chatId')) = '0/0/8172145b-cec4-43f2-a73a-8e131b008ace
    and indexOf(ParsedParams.Key2, 'readMarker') > 0
"""


def get_ch_results(yr, query):
    res = yr.run(query, query_type="CLICKHOUSE", syntax_version=1)
    return res.table.rows[0][0]


def to_monday(date):
    return date - datetime.timedelta(date.weekday())


TYPE_TO_YT_TYPE = {str: "string", int: "uint64"}


def derive_schema(dict_):
    return [{"name": k, "type": TYPE_TO_YT_TYPE[type(dict_[k])]} for k in sorted(dict_)]


def write_table(table_path, rows):
    yt.write_table(yt.TablePath(table_path, schema=derive_schema(rows[0])), rows)


def process_date(date_parsed, query_types, yr):
    date = str(date_parsed)
    print(f"processing {date}...")
    # date_nodash = date.replace("-", "")
    date_weekago = str(date_parsed - datetime.timedelta(days=7))
    date_weekago_nodash = date_weekago.replace("-", "")
    date_yesterday = str(date_parsed - datetime.timedelta(days=1))
    date_yesterday_nodash = date_yesterday.replace("-", "")
    monday = str(to_monday(date_parsed))

    if "khural_cut" in query_types:
        khural_cut_read = get_ch_results(
            yr,
            KHURAL_CUT_READ.format(
                date_weekago=date_weekago,
                date=date,
                date_weekago_nodash=date_weekago_nodash,
            ),
        )
        khural_cut_read = [{"login": x, "fielddate": date_weekago} for x in khural_cut_read.split(",") if x]
        if khural_cut_read:
            write_table(f"//home/strm/vh_analytics/staff_data_private/{date_weekago}_khural_cut", khural_cut_read)


    if date == "2022-01-21":
        announcement_ = "20220120_khuralannouncement"
    elif date == "2022-01-28":
        announcement_ = "20220127_khuralanons"
    elif date == "2022-02-04":
        announcement_ = "20220203_adkhural"
    else:
        announcement_ = date_yesterday_nodash + "_khural_anons"
    announcement = get_ch_results(
        yr,
        ANNOUNCEMENT.format(
            date=date,
            monday=monday,
            date_nodash=date_yesterday_nodash,
            announcement=announcement_
        ),
    )
    announcement = [{"login": x, "fielddate": date} for x in announcement.split(",") if x]
    if announcement:
        write_table(f"//home/strm/vh_analytics/staff_data_private/{date}_announcement", announcement)

    khural_view = get_ch_results(
        yr,
        KHURAL_VIEW.format(
            date=date,
        ),
    )
    khural_view = [{"login": x, "fielddate": date} for x in khural_view.split(",") if x]
    if khural_view:
        write_table(f"//home/strm/vh_analytics/staff_data_private/{date}_khural_view", khural_view)

    # khuralnaya = get_ch_results(
    #     yr,
    #     KHURALNAYA.format(
    #         date=date,
    #     ),
    # )
    # khuralnaya = [{"crypta_id": int(x), "fielddate": date} for x in khuralnaya.split(",")]
    # write_table(f"//home/strm/vh_analytics/staff_data_private/{date}_khuralnaya", khuralnaya)


def parse_dates(dates):
    dates = dates.split(",")
    result = []
    for segment in dates:
        if ":" in segment:
            result.extend(date_range(*segment.split(":", maxsplit=1)))
        else:
            result.extend(date_range(segment, segment))
    return result


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument("--date")
    parser.add_argument("--types", default="khural_view,khural_cut,announcement")
    args = parser.parse_args()

    query_types = args.types.split(",")

    yc = YqlClient(token=os.environ["YQL_TOKEN"])
    yr = YqlRunner(yc, title="KOAN-3436 | YQL")
    yc.config.db = None

    dates = parse_dates(args.date)

    for date in dates:
        process_date(date, query_types, yr)


if __name__ == "__main__":
    main()
