-- Traffic dashboard
use hahn;
pragma yt.PoolTrees = "physical,cloud_default";

$wrapOsFamily = ($ua) -> {
    $parsed = UserAgent::Parse($ua);
    return IF(
        $parsed.OSFamily = "Unknown", null, $parsed.OSFamily
    )
};

$device_type = ($ua) -> {
    return CASE WHEN UserAgent::Parse($ua).isTablet THEN 'IsTablet' WHEN UserAgent::Parse($ua).isMobile THEN 'IsMobile' WHEN  UserAgent::Parse($ua).isTV THEN 'IsTV'ELSE 'Desktop' END
};


$re_abcid = Re2::Capture("abcID=(?P<abc_id>[0-9]+)");

$gogol_abcid = ($x) -> (cast($re_abcid($x).abc_id as Int32));

$os_aggregate = ($os) -> {
    return CASE WHEN $os = 'Unknown' then null when $os in ('Windows', 'Android', 'iOS') then $os else 'Other_OS'  end 
};

$parseData = ($data, $name) -> {
    $data = ListMap( String::SplitToList(String::RemoveAll($data,"\"{}"),',') , ($x) -> (String::SplitToList($x,':')));
    $result = ListFilter($data, ($x) -> ($x[0]=$name));
    RETURN $result[0][1]
};

$upscale = ($data) -> {
    RETURN MAX_OF(
                MIN_OF(
                    MIN_OF(CAST($parseData($data,'maxHeight') as Double),CAST($parseData($data,'containerHeight') as Double))/CAST($parseData($data,'height') as Double) - 1,
                    MIN_OF(CAST($parseData($data,'containerWidth') as Double),CAST($parseData($data,"maxWidth") as Double))/CAST($parseData($data,'width') as Double)) - 1
            ,0) 
};

$mux = ($coef) -> { RETURN Math::Pow(Math::E(),-0.33*$coef)};


$src_table = '//logs/strm-gogol-log/1d/'||$date;
$dst_table = '//home/videoquality/vh_analytics/korovinvas/KOAN_3480/data/_tmp_table';


$r = 
(select 
    vsid,
    service,
    videoContentId,
    streamUrl,
    $gogol_abcid(streamUrl) as abc_id,
    $os_aggregate($wrapOsFamily(userAgent)) as os_family,
    clientTimestamp,
    additionalParameters_from_block as from_block,
    additionalParameters_stream_block as stream_block,
    labels_from,
    data_state_watchedTime-NVL(NVL(LAG(data_state_watchedTime,1),0) OVER w ,0) as tvt_period,
    data_state_watchedTime as tvt,
    $parseData(data,'auto') as quality,
    LAG(data_state_watchedTime,1) OVER w as tvt_prev,
    LEAD(data_state_watchedTime,1) OVER w as tvt_next,
    CAST($parseData(data,"height") as Double) as height,
    CAST($parseData(data,"width") as Double) as width,
    MIN_OF(CAST($parseData(data,"containerHeight") as Double),CAST($parseData(data,"maxHeight") as Double)) as containerHeight,
    MIN_OF(CAST($parseData(data,"containerWidth") as Double),CAST($parseData(data,"maxWidth") as Double)) as containerWidth,
    $upscale(data) as upscale
from 
$src_table
WHERE 
    vsid is not null and vsid != '-' 
    and eventName='PlayerAlive' 
    and service = 'StreamPlayer'
window w as (
        partition by vsid, videoContentId
        order by clientTimestamp
));


INSERT INTO $dst_table WITH TRUNCATE 

select 
    abc_id,
    labels_from,
    from_block,
    stream_block,
    vsid,
    service,
    streamUrl,
    os_family,
    videoContentId,
    sum(CASE WHEN tvt_period>0 THEN tvt_period ELSE 0 END) as tvt,
    $mux(0.85*(sum(upscale*(CASE WHEN tvt_period<0 THEN 0 ELSE tvt_period END ))/sum(CASE WHEN tvt_period<0 THEN 0 ELSE tvt_period END) + 0.15*max(upscale)))*100 as mux_coef,
    quality as quality
from 
    $r
WHERE tvt>0 
GROUP BY 
    quality as quality,
    labels_from,
    from_block,
    stream_block,
    os_family,
    abc_id,
    vsid,
    service,
    streamUrl,
    videoContentId;

COMMIT;


$dst_table2 = '//home/videoquality/vh_analytics/korovinvas/KOAN_3480/data/_tmp_table_aggr';


INSERT INTO $dst_table2 WITH TRUNCATE


SELECT
abc_service_name, 
from_block, 
labels_from, 
quality, 
os_family, 
stream_block,
day,
avg(mux) as avg_mux,
count(distinct vsid) as vsids,
PERCENTILE(mux,0.5) as p50_mux,
PERCENTILE(mux,0.01) as p01_mux,
PERCENTILE(mux,0.05) as p05_mux,
PERCENTILE(mux,0.25) as p25_mux,
PERCENTILE(mux,0.75) as p75_mux,
FROM
(SELECT
    AsList(name,'total') as abc_service_name,
    day as day,
    AsList(from_block,'total') as from_block,   
    AsList(labels_from,'total') as labels_from,
    AsList(quality,'total') as quality,
    AsList(os_family, 'total') as os_family,
    AsList(stream_block,'total') as stream_block,
    mux as mux,     
    vsid as  vsid
from
    (select 
        abc_id,
        $date as day,
        from_block,
        labels_from,
        quality,
        os_family,
        stream_block,
        mux_coef as mux,
        vsid||NVL(videoContentId,'')||NVL(streamUrl,'') as vsid
    from 
        $dst_table as a 
    WHERE service = 'StreamPlayer' and tvt>0 and quality is not null) as a 
    LEFT JOIN  `//home/videoquality/strm_meta/abc_services` as b ON a.abc_id=b.abc_id
WHERE mux is not null
)
FLATTEN LIST BY (abc_service_name, from_block, labels_from, quality, os_family, stream_block) 
GROUP BY 
abc_service_name, 
from_block, 
labels_from, 
quality, 
os_family, 
stream_block,
day;
