use hahn;
pragma yt.UseDefaultTentativePoolTrees;
pragma yson.DisableStrict;
pragma AnsiInForEmptyOrNullableItemsCollections;
pragma yt.PoolTrees = "physical";
pragma yt.TentativePoolTrees = "cloud";
pragma SimpleColumns;

$parseUA = ($ua) -> {
    return case
        when $ua='Mozilla/5.0 (Macintosh; U; Intel Mac OS X 10.4; en-US; rv:1.9.2.2) Gecko/20100316 Firefox/3.6.2' then 'Android'
        when $ua like 'search_app_ios/%' then 'search_app_ios'
        when $ua like 'browser_ios/%' then 'browser_ios'
        when $ua like 'zen_app_ios/%' then 'zen_app_ios'
        else null
    end;
};

$aggrparseUA = ($ua) -> {
    return case
        when $ua='Mozilla/5.0 (Macintosh; U; Intel Mac OS X 10.4; en-US; rv:1.9.2.2) Gecko/20100316 Firefox/3.6.2' then 'Android'
        when $ua like 'search_app_ios/%' then 'iOS'
        when $ua like 'browser_ios/%' then 'iOS'
        when $ua like 'zen_app_ios/%' then 'iOS'
        else null
    end;
};

$pargs = ($args) -> {
    return case 
        when $args = "webp=false" then 'false'
        when $args = "webp=true" then 'true'
        else null
    end;
};

$pucs = ($ucs) -> {
    return case 
        when $ucs = "MISS" then 'false'
        when $ucs = "HIT" then 'true'
        else null
    end;
};



$src_table = '//home/logfeller/logs/avatars-mds-access-log/1d/' || $date;
$dst_table = 'home/videoquality/vh_analytics/korovinvas/KOAN_3642/day_stat/_new_day';

$data = 
(SELECT 
    day,
    aggr_ua, 
    args, 
    bytes_sent 
FROM
    (SELECT 
        TableName() as day,
        AsList($aggrparseUA(user_agent),'total') as aggr_ua, 
        AsList($pargs(args),'total') as args, 
        CAST(bytes_sent as Double) as bytes_sent
    FROM $src_table
    WHERE 
        $aggrparseUA(user_agent) is not null and 
        $pargs(args) is not null and
        request like '/get-vh/%' and 
        referer like "-" and 
        (user_agent not like 'Mozilla/%' or user_agent = 'Mozilla/5.0 (Macintosh; U; Intel Mac OS X 10.4; en-US; rv:1.9.2.2) Gecko/20100316 Firefox/3.6.2'))
FLATTEN LIST BY (aggr_ua, args)
);



INSERT INTO $dst_table WITH TRUNCATE 

SELECT     
    aggr_ua,
    args, 
    PERCENTILE(bytes_sent, 0.25) / 1024 as bytes_sent_25,
    PERCENTILE(bytes_sent, 0.5) / 1024 as bytes_sent_50,
    PERCENTILE(bytes_sent, 0.75) / 1024 as bytes_sent_75,
    PERCENTILE(bytes_sent, 0.95) / 1024 as bytes_sent_95,  
    PERCENTILE(bytes_sent, 0.99) / 1024 as bytes_sent_99,       
    sum(CAST(bytes_sent as Double)),
    day,
    count(*) as hits 
FROM $data
WHERE aggr_ua is not null
GROUP BY  args, aggr_ua,     day as day;

COMMIT;

INSERT INTO `home/videoquality/vh_analytics/korovinvas/KOAN_3642/aggr_stat` WITH TRUNCATE

select 
day as day,
hits,
aggr_ua,
args	,
bytes_sent_25  as bytes_sent_25,
bytes_sent_50  as bytes_sent_50,	
bytes_sent_75  as bytes_sent_75,
bytes_sent_95  as bytes_sent_95,
bytes_sent_99  as bytes_sent_99
from 
`home/videoquality/vh_analytics/korovinvas/KOAN_3642/aggr_stat`
WHERE args is not null and day not in (select day from $dst_table group by day)


UNION ALL 

select 
day as day,
hits,
aggr_ua,
args	,
bytes_sent_25 as bytes_sent_25,
bytes_sent_50 as bytes_sent_50,	
bytes_sent_75 as bytes_sent_75,
bytes_sent_95 as bytes_sent_95,
bytes_sent_99 as bytes_sent_99
from 
$dst_table
WHERE args is not null
