use hahn;
pragma AnsiInForEmptyOrNullableItemsCollections;
pragma yt.DefaultMaxJobFails = "1";
pragma yson.DisableStrict;
pragma yt.Pool = "zen-video-analytics";
pragma yt.PoolTrees = "physical,cloud_default";
pragma DqEngine = "disable";
pragma library("quality_report_avglog_common.sql");
import quality_report_avglog_common symbols $parsePlayerState;
pragma yt.MaxRowWeight="128M";

$gogol_src = 'logs/strm-gogol-log/1d/' || $date;
$dst_table = 'home/zen-analytics/korovinvas/fatals_dashboard/data/' || $date;

$source = select * from $gogol_src where vsid is not null and vsid!='-';

$isAd = ($streamUrl) -> (
    FIND($streamUrl, "-canvas-") is not null
    or FIND($streamUrl, "-bsvideo-") is not null
    or FIND($streamUrl, "-adfox-") is not null
);

$wrapOsFamily = ($ua) -> {
    $parsed = UserAgent::Parse($ua);
    return IF(
        $parsed.OSFamily = "Unknown", null, $parsed.OSFamily
    )};

$device_type = ($ua) -> {
    return CASE WHEN UserAgent::Parse($ua).isTablet THEN 'IsTablet' WHEN UserAgent::Parse($ua).isMobile THEN 'IsMobile' WHEN  UserAgent::Parse($ua).isTV THEN 'IsTV'ELSE 'Desktop' END
};

$os_aggregate = ($os) -> {
    return CASE WHEN $os = "Unknown" then null when $os in ("Windows", "Android", "iOS") then $os else "Other_OS"  end 
};   

    $pa = (
        select
            $parsePlayerState(Yson::ParseJson(data)).`timestamp` as ts,
            $parsePlayerState(Yson::ParseJson(data)).isVisible as vis,
            service,
            additionalParameters_from_block as from_block,
            additionalParameters_stream_block as stream_block,
            labels_from,
            $device_type(userAgent) as device,
            $os_aggregate($wrapOsFamily(userAgent)) as os_family,
            $isAd(streamUrl) as isAd,
            vsid,
            streamUrl,
            videoContentId
        from $source
        where eventName = "PlayerAlive"
    );

$windowed = (
    select
        s.*,
        lag(vis, 1) over w as prev_vis,
        lead(vis, 1) over w as next_vis,
        lag(ts, 1) over w as prev_ts,
        lead(ts, 1) over w as next_ts
    from $pa as s
    window w as (
        partition by vsid, videoContentId
        order by ts
    )
);


$visible_windows = (
    select
        vsid,
        isAd,
        max(from_block) as from_block,
        max(stream_block) as stream_block,
        max(device) as device,
        max(os_family) as os_family,
        max(service) as service,
        videoContentId,
        streamUrl,
        max(labels_from) as labels_from,
        aggregate_list(AsTuple(prev_ts,ts,next_ts,vis)) as visible_window
    from $windowed
    group by vsid,         NVL(videoContentId,'-') as videoContentId,
        NVL(streamUrl,'-') as streamUrl, $isAd(streamUrl) as isAd
);


$fatals = (
    select
        vsid,
        NVL(videoContentId,'-') as videoContentId,
        NVL(streamUrl,'-') as streamUrl,
        eventName,
        clientTimestamp,
        Yson::YPathString(Yson::ParseJson(data), "/visualState/isVisible") as isVisible
    from $source
    where eventType = "fatal" 
);


select *      FROM 
            $visible_windows as a 
        FULL JOIN 
            $fatals as b ON a.vsid=b.vsid and a.videoContentId=b.videoContentId and a.streamUrl=b.streamUrl
            WHERE eventName = 'DRM_PROXY_ERROR_SIGNATURE_EXPIRED';


$all_fatals = 
    (SELECT 
        from_block as from_block,
        isAd as isAd,
        labels_from as labels_from,
        os_family as os_family,
        'all fatals' as visible,
        service as service,
        stream_block as stream_block,
        CASE WHEN ListLength(ListNotNull(fatals))=0 THEN AsList('total') ELSE ListExtend(ListNotNull(fatals),AsList('total','w_fatals')) END as fatals,
        videoContentId,
        streamUrl,
        vsid as vsid
    FROM
        (SELECT 
            a.isAd as isAd,
            a.from_block as from_block,
            a.labels_from as labels_from,
            a.os_family as os_family,
            a.service as service,
            a.stream_block as stream_block,
            a.videoContentId as videoContentId,
            a.streamUrl as streamUrl,
            aggregate_list(eventName) as fatals,
            a.vsid as vsid
        FROM 
            $visible_windows as a 
        FULL JOIN 
            $fatals as b ON a.vsid=b.vsid and a.videoContentId=b.videoContentId and a.streamUrl=b.streamUrl
        GROUP BY 
            a.isAd as isAd,
            a.videoContentId as videoContentId,
            a.streamUrl as streamUrl,            
            a.from_block as from_block,
            a.labels_from as labels_from,
            a.os_family as os_family,
            a.service as service,
            a.stream_block as stream_block,
            a.vsid as vsid))
;


$test_fatal = ($visible_window, $fatal_name, $ts) -> {
    RETURN ListNotNull(
        ListMap($visible_window,($x) -> {RETURN CASE WHEN ($ts>=$x.0 or $x.0 is null) and ($ts<=$x.1 or $x.2 is null)  and $x.3 = true THEN $fatal_name ELSE null END})
    )[0];
};

$visible_fatals = 
    (SELECT 
        isAd as isAd,
        from_block as from_block,
        videoContentId,
        streamUrl,
        labels_from as labels_from,
        os_family as os_family,
        'visible fatals' as visible,
        service as service,
        stream_block as stream_block,
        CASE WHEN ListLength(ListNotNull(fatals))=0 THEN AsList('total') ELSE ListExtend(ListNotNull(fatals),AsList('total','w_fatals')) END as fatals,
        vsid as vsid
    FROM
        (SELECT 
            a.isAd as isAd,
            a.from_block as from_block,
            a.videoContentId as videoContentId,
            a.streamUrl as streamUrl,
            a.labels_from as labels_from,
            a.os_family as os_family,
            a.service as service,
            a.stream_block as stream_block,
            aggregate_list($test_fatal(visible_window,eventName,clientTimestamp)) as fatals,
            a.vsid as vsid
        FROM 
            $visible_windows as a 
        FULL JOIN 
            $fatals as b ON a.vsid=b.vsid and a.videoContentId=b.videoContentId and a.streamUrl=b.streamUrl
        GROUP BY 
            a.isAd as isAd,
            a.videoContentId as videoContentId,
            a.streamUrl as streamUrl,
            a.from_block as from_block,
            a.labels_from as labels_from,
            a.os_family as os_family,
            a.service as service,
            a.stream_block as stream_block,
            a.vsid as vsid))
;

INSERT INTO $dst_table WITH TRUNCATE


select 
from_block as from_block,
labels_from as labels_from,
os_family as os_family,
visible as visible,
isAd as isAd,
service as service,
stream_block as stream_block,
fatal,
count(distinct vsid||"-"||videoContentId) as vsids 
from $all_fatals 
FLATTEN LIST BY fatals as  fatal
GROUP BY 
isAd as isAd,
from_block as from_block,
labels_from as labels_from,
os_family as os_family,
visible as visible,
service as service,
stream_block as stream_block,
fatal

UNION ALL 

select 
isAd as isAd,
from_block as from_block,
labels_from as labels_from,
os_family as os_family,
visible as visible,
service as service,
stream_block as stream_block,
fatal,
count(distinct vsid||"-"||videoContentId) as vsids 
from $visible_fatals
FLATTEN LIST BY fatals as  fatal
GROUP BY 
isAd as isAd,
from_block as from_block,
labels_from as labels_from,
os_family as os_family,
visible as visible,
service as service,
stream_block as stream_block,
fatal
