use hahn;
pragma yt.UseDefaultTentativePoolTrees;
pragma yson.DisableStrict;
pragma AnsiInForEmptyOrNullableItemsCollections;
pragma yt.PoolTrees = "physical";
pragma yt.TentativePoolTrees = "cloud";
pragma SimpleColumns;
PRAGMA yt.TmpFolder="home/videoquality/vh_analytics/korovinvas/tmp";

$gogol_table = '//logs/strm-gogol-log/1d/' || $date;
$dst_table = '//home/videoquality/vh_analytics/korovinvas/KOAN_3831/days/_new_date';



$chooseService = ($list) -> {
    $list = ListNotNull($list);
    $wo_vas = ListFilter($list, ($x)->($x != "VAS"));
    return case
    when ListLength($wo_vas) > 0 then ListMax($wo_vas)
    when ListLength($list) > 0 then ListMax($list)
    else null
    end
};

$wrapOsFamily = ($ua) -> {
    $parsed = UserAgent::Parse($ua);
    return IF(
        $parsed.OSFamily = "Unknown", null, $parsed.OSFamily
    )
};

$os_aggregate = ($os) -> {
    return CASE WHEN $os = "Unknown" then null when $os in ("Windows", "Android", "iOS") then $os else "Other_OS"  end 
};


$data = select
    TableName() as day,
    vsid,
    $os_aggregate($wrapOsFamily(userAgent)) as os_family,
    cast(eventIndex as Uint64) as eventIndex,
    service,
    labels_from as labels_from
from $gogol_table
where cast(eventIndex as Uint64) >= 0 and vsid!='-' and vsid is not null;

$sessions = select 
    day,
    service,
    labels_from,
    os_family,
    vsid,
    count(distinct eventIndex) as gotEvents,
    (max(eventIndex) - min(eventIndex) + 1) as sentEvents,
from $data
group by service, vsid,labels_from, os_family, day;

INSERT INTO $dst_table WITH TRUNCATE

select 
    day,
    service,
    os_family,
    labels_from,
    sum(sentEvents) as sentEvents,
    count(distinct vsid) as vsids,
    sum(gotEvents) as gotEvents,
    1.0 * sum(gotEvents) / sum(sentEvents) as ratio
from $sessions
group by   
    day,
    service,
    os_family,
    labels_from;
