use hahn;
pragma yt.Pool = "@[pool]";
pragma AnsiInForEmptyOrNullableItemsCollections;
pragma yt.PublishedAutoMerge = "economy";
PRAGMA File('bigb.so', 'https://proxy.sandbox.yandex-team.ru/last/BIGB_UDF?attrs={"released":"stable"}&cache=1235435');
PRAGMA udf('bigb.so');


$date = "@[date]";
$chevent_table = "//cooked_logs/bs-chevent-cooked-log/1d/" || $date;
$chtracking_table = "//logs/bs-chtracking-log/1d/" || $date;
$efh_root = "//home/bs/logs/JoinedEFH/1h";
$range_1h_start = $date || "T00:00:00";
$range_1h_end = $date || "T23:00:00";
$inapp_table = "//home/bs/users/yabs-analytics/video/pageimp_ids_video_with_inapp";
$joined_table = "//home/videoquality/vh_analytics/cpmadv-150-cooked/" || $date;

$cpm_packages = (
    select cid, package_id
    from LIKE(`home/direct/mysql-sync/current`, `ppc:%`, `straight/campaigns_cpm_price`)
    group by cid, package_id
);

$cpm_packages_with_names = (
    select c.*, title as package_title
    from $cpm_packages as c
    left join any (
        select package_id, title
        from `//home/direct/mysql-sync/current/ppcdict/straight/cpm_price_packages`
    ) as d using (package_id)
);

$deviceTypeToHR = ($dt) -> (case
when $dt in (1, 2) then "other"
when $dt in (3, 4) then "mobile"
else "desktop"
end);

$chevent = (
    select
        hitlogid,
        position,
        producttype,
        creativeid,
        impressionoptions_rewarded as is_rewarded,
        `impressionoptions_in-app` as is_inapp,
        $deviceTypeToHR(devicetype) as device_type,
        pageid,
        impid,
        orderid,
        bannerid,
        countertype,
        eventcost
    from $chevent_table
    where fraudbits = 0 and producttype like "%reach%"
);

$inbanner_data = (
    select 
        a.ClientID as ClientID,
        a.creative_id as creative_id,
        width,
        height,
        a.bid as bid,
        a.cid as cid,
        a.pid as pid,
        c.BannerID as BannerID,
        c.image_BannerID as iBannerID
from
    (
        select 
            ClientID,
            a.creative_id as creative_id,
            width,
            height,
            bid,
            cid,
            pid
    from 
    `home/direct/db/perf_creatives` as a 
    INNER JOIN LIKE(`//home/direct/mysql-sync/current`, `ppc:%`, `straight/banners_performance`) AS bp ON a.creative_id = bp.creative_id
    WHERE creative_type='canvas' and  nvl(layout_id, 0) IN (21, 22, 23, 24, 25) ) as a 
    INNER JOIN 
    `home/direct/db/banners` as c ON a.bid=c.bid
);

$inbanner = select distinct creative_id as creativeid from $inbanner_data;

$caesar = '//home/bs/logs/AdsCaesarOrdersFullDump/latest';

$order_info = (
    select
    IF(
        Bigb::ParseOrderProfile(TableRow()).Resources.DirectBannersLogFields.OrderType in (1, 8),
        "commerce", "non-commerce"
    ) as order_type, 
    OrderID from $caesar
);

$campaigns = (
    select
        cid, ClientID, OrderID, type
    from `home/direct/db/campaigns`
);

$counterparty = (
    select client_id, curr_counterparty_name, client_name
    from `//home/comdep-analytics/public/client_tiers/fact/latest_v2`
);

$banners  = (
    select
        BannerID as bannerid,
        phr.pid as pid,
        adgroup_type
    from `home/direct/db/banners` as b
    left join any `home/direct/db/phrases` as phr using (pid)
);

$chevent_grouped_1 = (
    SELECT
        hitlogid,
        position,
        max(is_rewarded) as is_rewarded,
        max(is_inapp) as is_inapp,
        some(producttype) as producttype,
        some(creativeid) as creativeid,
        some(device_type) as device_type,
        some(pageid) as pageid,
        some(impid) as impid,
        some(orderid) as orderid,
        some(bannerid) as bannerid,
        count_if(countertype = 1) as shows,
        count_if(countertype = 2) as clicks,
        sum(eventcost / 1000000.0 / 1.18 * 30.0) as eventcost_rub,
    from $chevent
    group by hitlogid, position
);

$efh = (
    select
        HitLogID as hitlogid,
        Position as position,
        IF(CounterType = 2 and HasCounter == 1, 1, 0) as vclick,
        IF(CounterType = 2 and HasCounter == 1 and VisitIsBounce == 0, 1, 0) as lclick,
        IF(CounterType = 2 and HasCounter == 1 and VisitIsBounce == 1, 1, 0) as bounce,
        VisitPrggGoodModelScore as prgg
    from range($efh_root, $range_1h_start, $range_1h_end)
    where FraudBits = 0
);

$efh_grouped = (
    select
        hitlogid, position,
        sum(vclick) as vclicks,
        sum(lclick) as lclicks,
        sum(bounce) as bounces,
        sum(prgg) as prgg
    from $efh
    group by hitlogid, position
);

$chtracking = (
    SELECT
        cast(hitlogid as Uint64) as hitlogid,
        cast(position as Uint64) as position,
        `action`
    from $chtracking_table
    where fraudbits = "0" and `action` in ("complete",)
);

$chtracking_grouped = (
    select
        hitlogid, position,
        count_if(`action` = "complete") as completes
    from $chtracking
    group by hitlogid, position
);

$creatives_dict = (
    select
        creativeid,
        some(
            if(
                ConstructorData like '%duration%', 
                Yson::ConvertToDouble(
                    Yson::YPath(
                        Yson::ParseJson(ConstructorData),
                        "/duration"
                    )
                )
            )
        ) as duration
    from
        `home/yabs/dict/DSPCreative`
    where ConstructorData like "%duration%"
    group by 
        cast(CreativeID as Int64) as creativeid
);

$chevent_joined = (
    select
        c.*,
        lclicks,
        vclicks,
        bounces,
        prgg,
        completes,
        video_placement_name,
        ib.creativeid is not null as is_inbanner,
        camp.type as camp_type,
        camp.cid as campaignid,
        camp.ClientID as clientid,
        o.order_type as order_type,
        b.pid as pid,
        b.adgroup_type as adgroup_type,
        IF(
            cp.curr_counterparty_name like "%client_id%",
            cp.client_name,
            cp.curr_counterparty_name
        ) as counterparty_name,
        (cp.client_name ?? "-") || " (client_id: " || (cast(camp.ClientID as String) ?? "") || ")" as client_name,
        duration,
        package_title
    from $chevent_grouped_1 as c
    left join any $inapp_table as i on (c.pageid = i.pageid and c.impid = i.impid)
    left join any $inbanner as ib on (c.creativeid = ib.creativeid)
    left join any $campaigns as camp on (c.orderid = camp.OrderID)
    left join any $order_info as o on (c.orderid = o.OrderID)
    left join any $counterparty as cp on (camp.ClientID = cp.client_id)
    left join any $banners as b on (c.bannerid = b.bannerid)
    left join any $efh_grouped as efh on (c.hitlogid = efh.hitlogid and c.position = efh.position)
    left join any $chtracking_grouped as ch on (c.hitlogid = ch.hitlogid and c.position = ch.position)
    left join any $creatives_dict as cd on (c.creativeid = cd.creativeid)
    left join any $cpm_packages_with_names as cn on (camp.cid = cn.cid)
);

insert into $joined_table WITH TRUNCATE 
select * from $chevent_joined;
