#!/usr/bin/env python
# -*- coding: utf-8 -*-
from __future__ import division
import sys
import os
import argparse
import datetime
from nile.api.v1 import clusters
from yql.api.v1.client import YqlClient
from videolog_common import (
    apply_replacements,
    date_range,
    get_cluster,
    get_driver,
    get_stat_headers,
    get_dates_from_stat,
    get_date,
    YqlRunner,
)

TITLE = "[CPMADV-150] Push to Stat | YQL"

# ATTACHMENTS = [
#     {"path": "analytics/videolog/strm-stats/strm_cube_2/stability/stability_common.sql"}
# ]


def process_date(date, args):
    proxy = os.environ["YT_PROXY"]
    yc = YqlClient(db=proxy.lower(), token=os.environ["YQL_TOKEN"])
    yr = YqlRunner(client=yc, title=TITLE)
    with open("cpmadv_150_stat_stub.sql", "rb") as f:
        query = f.read().decode("utf8")
    query = apply_replacements(query, {"@[pool]": args["pool"], "@[date]": str(date)})
    yr.run(query, wait=True)


def get_available_dates(yt):
    return {
        get_date(x)
        for x in yt.search(
            root="//home/videoquality/vh_analytics/cpmadv-150-cooked",
            node_type="table",
            path_filter=lambda x: bool(get_date(x)),
        )
    }


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument("--pool", default="robot-mma-nirvana")
    parser.add_argument("--title", default=TITLE)
    parser.add_argument("--from")
    parser.add_argument("--to")
    parser.add_argument("--redo", action="store_true")
    args = vars(parser.parse_args())

    cluster = get_cluster(clusters, args)
    yt = get_driver(cluster).client

    date_to_process = None

    if args["from"] and args["to"]:
        dates_to_process = date_range(args["from"], args["to"])
    else:
        last_date = get_dates_from_stat(
            get_stat_headers(), "Video/Others/CPMADV-150-media-dash"
        )[-1]
        last_available_date = max(get_available_dates(yt))
        print("last date: {}".format(last_date))
        print("last available date: {}".format(last_available_date))
        if last_date >= last_available_date:
            print("no dates to process")
            sys.exit(0)
        dates_to_process = sorted(
            date_range(last_date + datetime.timedelta(days=1), last_available_date),
            reverse=True,
        )

    if dates_to_process:
        for date_to_process in dates_to_process:
            process_date(date_to_process, args)
    else:
        print("no dates to process")


if __name__ == "__main__":
    main()
