use hahn;
pragma AnsiInForEmptyOrNullableItemsCollections;
pragma yt.Pool = "@[pool]";

$date = "@[date]";
$cooked_table = "//home/videoquality/vh_analytics/cpmadv-150-cooked/" || $date;
$output_table = "//home/videoquality/vh_analytics/cpmadv-150-stat/" || $date;

$chevent_joined2 = (
    select
        if(
            is_inbanner,
            "media-creative-reach-inbanner",
            producttype
        ) as producttype,
        c.* without producttype
    from $cooked_table as c
);

-- Видео аукцион/Непропускаемое видео аукцион/Видео фикс/Баннеры/Инбаннер Видео

$chevent_grouped = (
    select
        producttype,
        placement,
        campaignid,
        some(package_title) as package_title,
        some(orderid) as orderid,
        some(clientid) as clientid,
        some(order_type) as order_type,
        some(client_name) as client_name,
        some(counterparty_name) as counterparty_name,
        sum(shows) as shows,
        sum(clicks) as clicks,
        sum(eventcost_rub) as eventcost_rub
    from $chevent_joined2
    group by
        case
        when package_title is not null then package_title
        when producttype = "media-creative-reach-inbanner" then "Видео Инбаннер"
        when camp_type = "cpm_price" and producttype like "%video%" then "Видео фикс"
        when camp_type = "cpm_price" and adgroup_type = "cpm_yndx_frontpage" and producttype like "%media%" then "Баннеры на морде фикс"
        when producttype = "video-creative-reach-non-skippable" then "Непропускаемое видео аукцион"
        when producttype like "%media%" and camp_type = "cpm_yndx_frontpage" then "Баннеры на морде аукцион"
        when producttype like "%media%" then "Баннеры"
        else "Видео аукцион"
        end as producttype,
        case
        when producttype like "%media%" then "Баннеры"
        when video_placement_name = "instream" then "Инстрим"
        when video_placement_name = "inpage" then "Инпейдж"
        else "Видео остальное"
        end as placement,
        campaignid
);

$chevent_join_bu = (
    select c.*, b.name as business_unit
    from $chevent_grouped as c
    left join any `home/direct/db/campaigns` as camp on (cast(c.campaignid as Int64) = camp.cid)
    left join any  `//home/direct/mysql-sync/current/ppcdict/straight/products` AS pr on camp.ProductID = pr.ProductID
    left join any `//home/direct/mysql-sync/current/ppcdict/straight/business_units_info` AS b ON b.id = pr.business_unit
);

$lstMultiple = ($lst) -> {
    $lst = ListNotNull($lst);
    $len = ListLength($lst);
    return ListMap(
        ListFromRange(1, $len + 1),
        ($n)->(ListNotNull(ListTake($lst, $n)))
    )
};

$ident_with_package = Python::ident_with_package(@@#py
import re
from yql.typing import *

re_sp = re.compile("[,\.] ")

def ident_with_package(lst: List[Optional[Utf8]], package_title: Utf8) -> List[String]:
    if re_sp.search(package_title):
        sp = re_sp.split(package_title)
        package_comp = [sp[0], package_title]
    else:
        package_comp = [package_title]
    result = list(lst[:2]) + package_comp + list(lst[3:])
    result = [x for x in result if x]
    return [x.encode("utf8") for x in result]
@@);

$makeIdentificator = ($lst, $package_title) -> {
    return IF(
        $package_title is not null,
        $lstMultiple($ident_with_package(
            ListMap($lst, ($x)->(cast($x as Utf8))), unwrap(cast($package_title as Utf8))
        )),
        $lstMultiple($lst)
    )
};

$add_identificator = (
    select c.*,
        $makeIdentificator([
            order_type, business_unit, producttype, counterparty_name ?? "(Бренд не указан)", client_name
        ], package_title) as identificator
    from $chevent_join_bu as c
);

$totalize = ($row) -> {
    $result = [$row];
    $add = ListMap($result, ($x)->(AddMember(RemoveMember($x, "placement"), "placement", "_total_")));
    $result = ListUnionAll($result, $add);
    return $result
};

$totalized = (
    select * from (process $add_identificator using $totalize(TableRow()))
    flatten list by identificator
);

$grouped = (
    select
        $date as fielddate,
        identificator,
        placement,
        SUM(shows) as shows,
        SUM(clicks) as clicks,
        SUM(eventcost_rub) as eventcost_rub,
    from $totalized
    group by identificator, placement
);

insert into $output_table WITH TRUNCATE 
select * from $grouped;

upsert into stat.`Video/Others/CPMADV-150-media-dash/daily` erase by (fielddate)
select * from $grouped;
